/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreTileEntityElectricBlock
extends GCCoreTileEntityUniversalElectrical
implements IPacketReceiver,
IDisableableMachine {
    public float ueWattsPerTick;
    private final float ueMaxEnergy;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = true;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    public boolean hasEnoughEnergyToRun = false;

    public boolean shouldPullEnergy() {
        return this.shouldUseEnergy() || this.getEnergyStored() < this.ueMaxEnergy;
    }

    public abstract boolean shouldUseEnergy();

    public abstract ForgeDirection getElectricInputDirection();

    public abstract ItemStack getBatteryInSlot();

    public GCCoreTileEntityElectricBlock(float ueWattsPerTick, float maxEnergy) {
        this.ueMaxEnergy = maxEnergy;
        this.ueWattsPerTick = ueWattsPerTick;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.ueMaxEnergy;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStored() * (float)i / (this.getMaxEnergyStored() - this.ueWattsPerTick));
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.shouldPullEnergy()) {
            return Math.max(this.ueWattsPerTick * 3.0f, this.getMaxEnergyStored() - this.getEnergyStored());
        }
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.shouldPullEnergy() && this.getEnergyStored() < this.getMaxEnergyStored() && this.getBatteryInSlot() != null && this.getElectricInputDirection() != null) {
                this.discharge(this.getBatteryInSlot());
            }
            if (this.getEnergyStored() > this.ueWattsPerTick) {
                this.hasEnoughEnergyToRun = true;
                if (this.shouldUseEnergy()) {
                    this.setEnergyStored(this.getEnergyStored() - this.ueWattsPerTick);
                }
            } else {
                this.hasEnoughEnergyToRun = false;
            }
        }
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.disableCooldown > 0) {
            --this.disableCooldown;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isDisabled", this.getDisabled(0));
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setDisabled(0, nbt.func_74767_n("isDisabled"));
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled(int index) {
        return this.disabled;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public short getFacing() {
        return (short)this.field_70331_k.func_72805_g(MathHelper.func_76128_c((double)this.field_70329_l), MathHelper.func_76128_c((double)this.field_70330_m), MathHelper.func_76128_c((double)this.field_70327_n));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public void setFacing(short facing) {
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.tile.IWrenchable", modID="IC2")
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return Block.field_71973_m[this.func_70311_o().field_71990_ca].getPickBlock(null, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        if (this.getElectricInputDirection() == null) {
            return EnumSet.noneOf(ForgeDirection.class);
        }
        return EnumSet.of(this.getElectricInputDirection());
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }
}

