/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityPack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkHelper;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectricalStorage;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvanced;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class GCCoreTileEntityUniversalElectrical
extends GCCoreTileEntityAdvanced
implements IElectrical,
IElectricalStorage {
    protected boolean isAddedToEnergyNet;
    public Object bcPowerHandler;
    public float maxInputEnergy = 100.0f;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public float energyStored = 0.0f;
    private float IC2surplus = 0.0f;

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (from == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(from)) {
            if (!doReceive) {
                return this.getRequest(from);
            }
            return this.receiveElectricity(receive, doReceive);
        }
        return 0.0f;
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        if (this.getElectricalOutputDirections().contains(from)) {
            if (!doProvide) {
                return ElectricityPack.getFromWatts(this.getProvide(from), this.getVoltage());
            }
            return this.provideElectricity(request, doProvide);
        }
        return new ElectricityPack();
    }

    public float receiveElectricity(ElectricityPack receive, boolean doReceive) {
        if (receive != null) {
            float prevEnergyStored = this.getEnergyStored();
            float newStoredEnergy = Math.min(this.getEnergyStored() + receive.getWatts(), this.getMaxEnergyStored());
            if (doReceive) {
                this.setEnergyStored(newStoredEnergy);
            }
            return Math.max(newStoredEnergy - prevEnergyStored, 0.0f);
        }
        return 0.0f;
    }

    public float receiveElectricity(float energy, boolean doReceive) {
        return this.receiveElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doReceive);
    }

    public ElectricityPack provideElectricity(ElectricityPack request, boolean doProvide) {
        if (request != null) {
            float requestedEnergy = Math.min(request.getWatts(), this.energyStored);
            if (doProvide) {
                this.setEnergyStored(this.energyStored - requestedEnergy);
            }
            return ElectricityPack.getFromWatts(requestedEnergy, this.getVoltage());
        }
        return new ElectricityPack();
    }

    public ElectricityPack provideElectricity(float energy, boolean doProvide) {
        return this.provideElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doProvide);
    }

    @Override
    public void setEnergyStored(float energy) {
        this.energyStored = Math.max(Math.min(energy, this.getMaxEnergyStored()), 0.0f);
    }

    @Override
    public float getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        return this.getElectricalInputDirections().contains(direction) || this.getElectricalOutputDirections().contains(direction);
    }

    @Override
    public float getVoltage() {
        return 0.12f;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStored = nbt.func_74760_g("energyStored");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74776_a("energyStored", this.energyStored);
    }

    public void recharge(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                this.setEnergyStored(this.getEnergyStored() - ElectricItemHelper.chargeItem(itemStack, this.getProvide(ForgeDirection.UNKNOWN)));
            } else if (NetworkConfigHandler.isIndustrialCraft2Loaded() && itemStack.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)itemStack.func_77973_b();
                IElectricItemManager manager = electricItem.getManager(itemStack);
                float energy = Math.max(this.getProvide(ForgeDirection.UNKNOWN) * NetworkConfigHandler.IC2_RATIO, 0.0f);
                energy = (float)manager.charge(itemStack, (int)(energy * NetworkConfigHandler.TO_IC2_RATIO), 0, false, false) * NetworkConfigHandler.IC2_RATIO;
                this.provideElectricity(energy, true);
            } else if (GCCoreCompatibilityManager.isTELoaded() && itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                int accepted = ((IEnergyContainerItem)itemStack.func_77973_b()).receiveEnergy(itemStack, (int)Math.floor(this.getProvide(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_TE_RATIO), false);
                this.provideElectricity((float)accepted * NetworkConfigHandler.TE_RATIO, true);
            }
        }
    }

    public void produce() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection outputDirection : this.getElectricalOutputDirections()) {
                if (outputDirection == ForgeDirection.UNKNOWN || this.produceUE(outputDirection)) continue;
                this.produceExternal(outputDirection);
            }
        }
    }

    public boolean produceUE(ForgeDirection outputDirection) {
        float provide;
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN && (provide = this.getProvide(outputDirection)) > 0.0f) {
            float requestedEnergy;
            Vector3 thisVec = new Vector3(this);
            TileEntity outputTile = thisVec.modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k);
            IElectricityNetwork outputNetwork = NetworkHelper.getElectricalNetworkFromTileEntity(outputTile, outputDirection);
            if (outputNetwork != null) {
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                ElectricityPack powerRequest = outputNetwork.getRequest(tileEntityArray);
                if (powerRequest.getWatts() > 0.0f) {
                    ElectricityPack sendPack = ElectricityPack.min(ElectricityPack.getFromWatts(this.getEnergyStored(), this.getVoltage()), ElectricityPack.getFromWatts(provide, this.getVoltage()));
                    float rejectedPower = outputNetwork.produce(sendPack, true, this);
                    this.provideElectricity(Math.max(sendPack.getWatts() - rejectedPower, 0.0f), true);
                    return true;
                }
            } else if (outputTile instanceof IElectrical && (requestedEnergy = ((IElectrical)outputTile).getRequest(outputDirection.getOpposite())) > 0.0f) {
                ElectricityPack sendPack = ElectricityPack.min(ElectricityPack.getFromWatts(this.getEnergyStored(), this.getVoltage()), ElectricityPack.getFromWatts(provide, this.getVoltage()));
                float acceptedEnergy = ((IElectrical)outputTile).receiveElectricity(outputDirection.getOpposite(), sendPack, true);
                this.provideElectricity(acceptedEnergy, true);
                return true;
            }
        }
        return false;
    }

    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                this.setEnergyStored(this.getEnergyStored() + ElectricItemHelper.dischargeItem(itemStack, this.getRequest(ForgeDirection.UNKNOWN)));
            } else if (NetworkConfigHandler.isIndustrialCraft2Loaded() && itemStack.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)itemStack.func_77973_b();
                if (electricItem.canProvideEnergy(itemStack)) {
                    IElectricItemManager manager = electricItem.getManager(itemStack);
                    float energy = Math.max(this.getRequest(ForgeDirection.UNKNOWN) * NetworkConfigHandler.IC2_RATIO, 0.0f);
                    energy = manager.discharge(itemStack, (int)(energy * NetworkConfigHandler.TO_IC2_RATIO), 0, false, false);
                    this.receiveElectricity(energy, true);
                }
            } else if (GCCoreCompatibilityManager.isTELoaded() && itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                float given = ((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, (int)Math.floor(this.getRequest(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_TE_RATIO), false);
                this.receiveElectricity(given * NetworkConfigHandler.TE_RATIO, true);
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        this.initBuildCraft();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            PowerHandler handler;
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (this.bcPowerHandler == null) {
                this.initBuildCraft();
            }
            if (NetworkConfigHandler.isBuildcraftLoaded() && (handler = (PowerHandler)this.bcPowerHandler).getEnergyStored() > 0.0f) {
                this.receiveElectricity(handler.getEnergyStored() * NetworkConfigHandler.BC3_RATIO, true);
                handler.setEnergy(0.0f);
            }
        }
    }

    public boolean produceExternal(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f) {
                TileEntity adjacentEntity = new Vector3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k);
                if (NetworkConfigHandler.isThermalExpansionLoaded() && adjacentEntity instanceof IEnergyHandler) {
                    int teProvide = (int)Math.floor(provide * NetworkConfigHandler.TO_TE_RATIO);
                    int energyUsed = Math.min(((IEnergyHandler)adjacentEntity).receiveEnergy(outputDirection.getOpposite(), teProvide, false), teProvide);
                    this.provideElectricity((float)energyUsed * NetworkConfigHandler.TE_RATIO, true);
                    return true;
                }
                if (NetworkConfigHandler.isBuildcraftLoaded() && adjacentEntity instanceof IPowerReceptor) {
                    PowerHandler.PowerReceiver receiver = ((IPowerReceptor)adjacentEntity).getPowerReceiver(outputDirection.getOpposite());
                    if (receiver != null && receiver.powerRequest() > 0.0f) {
                        float bc3Provide = provide * NetworkConfigHandler.TO_BC_RATIO;
                        float energyUsed = Math.min(receiver.receiveEnergy(PowerHandler.Type.MACHINE, bc3Provide, outputDirection.getOpposite()), bc3Provide);
                        this.provideElectricity(energyUsed * NetworkConfigHandler.BC3_RATIO, true);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getElectricalInputDirections().contains(direction);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="IC2")
    public double getOfferedEnergy() {
        return this.getProvide(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_IC2_RATIO;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="IC2")
    public void drawEnergy(double amount) {
        this.provideElectricity((float)amount * NetworkConfigHandler.IC2_RATIO, true);
    }

    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_70331_k.field_72995_K) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_70331_k.field_72995_K) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double demandedEnergyUnits() {
        if (this.IC2surplus < 0.001f) {
            this.IC2surplus = 0.0f;
            return Math.ceil(this.getRequest(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_IC2_RATIO);
        }
        ElectricityPack toSend = ElectricityPack.getFromWatts(this.IC2surplus, this.getVoltage());
        float received = this.receiveElectricity(ForgeDirection.UNKNOWN, toSend, true);
        this.IC2surplus -= received;
        if (this.IC2surplus < 0.001f) {
            this.IC2surplus = 0.0f;
            return Math.ceil(this.getRequest(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_IC2_RATIO);
        }
        return 0.0;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergyUnits(ForgeDirection direction, double amount) {
        if (direction == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(direction)) {
            float convertedEnergy = (float)amount * NetworkConfigHandler.IC2_RATIO;
            ElectricityPack toSend = ElectricityPack.getFromWatts(convertedEnergy, this.getVoltage());
            float receive = this.receiveElectricity(direction, toSend, true);
            this.IC2surplus = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return Math.round(amount - (double)(receive * NetworkConfigHandler.TO_IC2_RATIO));
        }
        return amount;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyEmitter", modID="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return receiver instanceof IEnergyTile && this.getElectricalOutputDirections().contains(direction);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void initBuildCraft() {
        if (!NetworkConfigHandler.isBuildcraftLoaded()) {
            return;
        }
        if (this.bcPowerHandler == null) {
            this.bcPowerHandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
        }
        ((PowerHandler)this.bcPowerHandler).configure(0.0f, this.maxInputEnergy, 0.0f, (float)((int)Math.ceil(this.getMaxEnergyStored() * NetworkConfigHandler.BC3_RATIO)));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        this.initBuildCraft();
        return ((PowerHandler)this.bcPowerHandler).getPowerReceiver();
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public void doWork(PowerHandler workProvider) {
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public World getWorld() {
        return this.func_70314_l();
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0;
        }
        return (int)Math.floor(this.receiveElectricity((float)maxReceive * NetworkConfigHandler.TE_RATIO, !simulate));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.getElectricalOutputDirections().contains(from)) {
            return 0;
        }
        return (int)Math.floor(this.provideElectricity((float)maxExtract * NetworkConfigHandler.TE_RATIO, !simulate).getWatts() * NetworkConfigHandler.TO_TE_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public boolean canInterface(ForgeDirection from) {
        return this.getElectricalInputDirections().contains(from) || this.getElectricalOutputDirections().contains(from);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.floor(this.getEnergyStored() * NetworkConfigHandler.TO_TE_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.floor(this.getMaxEnergyStored() * NetworkConfigHandler.TO_TE_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double transferEnergyToAcceptor(ForgeDirection from, double amount) {
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0.0;
        }
        return (int)Math.floor(this.receiveElectricity((float)amount * NetworkConfigHandler.MEKANISM_RATIO, true));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getElectricalInputDirections().contains(side) || this.getElectricalOutputDirections().contains(side);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getEnergy() {
        return this.getEnergyStored() * NetworkConfigHandler.TO_MEKANISM_RATIO;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public void setEnergy(double energy) {
        this.setEnergyStored((float)(energy * (double)NetworkConfigHandler.MEKANISM_RATIO));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getMaxEnergy() {
        return this.getMaxEnergyStored() * NetworkConfigHandler.MEKANISM_RATIO;
    }
}

