/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.moon.GalacticraftMoon;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class GCMoonBlock
extends GCCoreBlockAdvancedTile
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock {
    @SideOnly(value=Side.CLIENT)
    private Icon[] moonBlockIcons;

    public GCMoonBlock(int i) {
        super(i, Material.field_76246_e);
        this.field_71989_cb = 3.0f;
        this.func_71864_b("moonBlock");
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_71872_e(world, x, y, z);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_71911_a_(world, x, y, z);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return false;
        }
        return super.isBlockNormalCube(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.moonBlockIcons = new Icon[17];
        this.moonBlockIcons[0] = par1IconRegister.func_94245_a("galacticraftmoon:top");
        this.moonBlockIcons[1] = par1IconRegister.func_94245_a("galacticraftmoon:brick");
        this.moonBlockIcons[2] = par1IconRegister.func_94245_a("galacticraftmoon:middle");
        this.moonBlockIcons[3] = par1IconRegister.func_94245_a("galacticraftmoon:top_side");
        this.moonBlockIcons[4] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_1");
        this.moonBlockIcons[5] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_2");
        this.moonBlockIcons[6] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_3");
        this.moonBlockIcons[7] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_4");
        this.moonBlockIcons[8] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_5");
        this.moonBlockIcons[9] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_6");
        this.moonBlockIcons[10] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_7");
        this.moonBlockIcons[11] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_8");
        this.moonBlockIcons[12] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_copper");
        this.moonBlockIcons[13] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_tin");
        this.moonBlockIcons[14] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_cheese");
        this.moonBlockIcons[15] = par1IconRegister.func_94245_a("galacticraftmoon:bottom");
        this.moonBlockIcons[16] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "blank");
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_71882_w() {
        return GalacticraftMoon.galacticraftMoonTab;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        if (world.func_72805_g(x, y, z) == 15 || world.func_72805_g(x, y, z) == 14) {
            return 10000.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_71934_m(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta == 3 || meta >= 5 && meta <= 13) {
            return 0.1f;
        }
        if (meta == 14 || meta == 15) {
            return -1.0f;
        }
        return this.field_71989_cb;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (meta == 3 || meta >= 5 && meta <= 13) {
            return true;
        }
        return super.canHarvestBlock(player, meta);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta >= 5 && meta <= 13) {
            if (side != 1) {
                if (side != 0) return this.moonBlockIcons[3];
                return this.moonBlockIcons[2];
            }
            switch (meta - 5) {
                case 0: {
                    return this.moonBlockIcons[0];
                }
                case 1: {
                    return this.moonBlockIcons[4];
                }
                case 2: {
                    return this.moonBlockIcons[5];
                }
                case 3: {
                    return this.moonBlockIcons[6];
                }
                case 4: {
                    return this.moonBlockIcons[7];
                }
                case 5: {
                    return this.moonBlockIcons[8];
                }
                case 6: {
                    return this.moonBlockIcons[9];
                }
                case 7: {
                    return this.moonBlockIcons[10];
                }
                case 8: {
                    return this.moonBlockIcons[11];
                }
            }
            return null;
        }
        switch (meta) {
            case 0: {
                return this.moonBlockIcons[12];
            }
            case 1: {
                return this.moonBlockIcons[13];
            }
            case 2: {
                return this.moonBlockIcons[14];
            }
            case 3: {
                return this.moonBlockIcons[2];
            }
            case 4: {
                return this.moonBlockIcons[15];
            }
            case 14: {
                return this.moonBlockIcons[1];
            }
            case 15: {
                return this.moonBlockIcons[16];
            }
        }
        return this.moonBlockIcons[16];
    }

    public int func_71885_a(int meta, Random random, int par3) {
        switch (meta) {
            case 2: {
                return GCCoreItems.cheeseCurd.field_77779_bT;
            }
            case 15: {
                return 0;
            }
        }
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        if (meta >= 5 && meta <= 13) {
            return 5;
        }
        if (meta == 2) {
            return 0;
        }
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        switch (meta) {
            case 15: {
                return 0;
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        int var4;
        for (var4 = 0; var4 < 6; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
        for (var4 = 14; var4 < 15; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 15) {
            return new GCCoreTileEntityDungeonSpawner();
        }
        return null;
    }

    @Override
    public boolean isValueable(int metadata) {
        switch (metadata) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 5 && metadata > 13) {
            return false;
        }
        plant.getPlantID(world, x, y + 1, z);
        return plant instanceof BlockFlower;
    }

    @Override
    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    @Override
    public boolean isPlantable(int metadata) {
        return metadata >= 5 && metadata <= 13;
    }

    @Override
    public boolean isTerraformable(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 5 && meta <= 13) {
            return world.func_72798_a(x, y + 1, z) == 0;
        }
        return false;
    }
}

