/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network;

import com.mrcrayfish.furniture.FurnitureAchievements;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.api.FurnitureAPI;
import com.mrcrayfish.furniture.api.ItemData;
import com.mrcrayfish.furniture.blocks.BlockStereo;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.inventory.InventoryPresent;
import com.mrcrayfish.furniture.tileentity.TileEntityBasin;
import com.mrcrayfish.furniture.tileentity.TileEntityBath;
import com.mrcrayfish.furniture.tileentity.TileEntityBin;
import com.mrcrayfish.furniture.tileentity.TileEntityComputer;
import com.mrcrayfish.furniture.tileentity.TileEntityPresent;
import com.mrcrayfish.furniture.tileentity.TileEntityStereo;
import com.mrcrayfish.furniture.tileentity.TileEntityTV;
import com.mrcrayfish.furniture.util.NBTHelper;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;

public class PacketManager
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        if (packet.field_73630_a.equals("cfmenvelope")) {
            this.handleEnvelopePacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmpackage")) {
            this.handlePackagePacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmminebay")) {
            this.handleMineBayPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmtv")) {
            this.handleTVPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmstereo")) {
            this.handleStereoPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmpresent")) {
            this.handlePresentPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmbath")) {
            this.handleBathPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmbasin")) {
            this.handleBasinPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmbin")) {
            this.handleBinPacket(inputStream, (EntityPlayer)player);
        }
        if (packet.field_73630_a.equals("cfmfart")) {
            this.handleFartPacket(inputStream, (EntityPlayer)player);
        }
    }

    public void handleEnvelopePacket(DataInputStream inputStream, EntityPlayer player) {
        EntityPlayerMP player1 = (EntityPlayerMP)player;
        try {
            if (player1.func_71045_bC() != null) {
                ItemStack mail = PacketManager.readItemStack(inputStream);
                ItemStack mail2 = player1.field_71071_by.func_70448_g();
                System.out.println(mail);
                if (mail != null && mail.field_77993_c == MrCrayfishFurnitureMod.itemEnvelopeSigned.field_77779_bT && mail2.field_77993_c == MrCrayfishFurnitureMod.itemEnvelope.field_77779_bT) {
                    mail2.field_77990_d = mail.field_77990_d;
                    mail2.func_77983_a("Author", (NBTBase)new NBTTagString("Author", player1.field_71092_bJ));
                    mail2.field_77993_c = MrCrayfishFurnitureMod.itemEnvelopeSigned.field_77779_bT;
                    mail2.func_82834_c("Mail");
                } else {
                    mail2.field_77990_d = mail.field_77990_d;
                    mail2.func_77983_a("Author", (NBTBase)new NBTTagString("Author", player1.field_71092_bJ));
                    mail2.field_77993_c = mail.field_77993_c;
                    if (mail2.field_77993_c == MrCrayfishFurnitureMod.itemPresentRed.field_77779_bT) {
                        mail2.func_82834_c(EnumChatFormatting.RED + "Wrapped Present");
                    } else {
                        mail2.func_82834_c(EnumChatFormatting.GREEN + "Wrapped Present");
                    }
                }
                player1.func_70062_b(0, mail2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handlePackagePacket(DataInputStream inputStream, EntityPlayer player) {
        EntityPlayerMP player1 = (EntityPlayerMP)player;
        try {
            if (player1.func_71045_bC() != null) {
                ItemStack mail = PacketManager.readItemStack(inputStream);
                ItemStack mail2 = player1.field_71071_by.func_70448_g();
                if (mail != null && mail.field_77993_c == MrCrayfishFurnitureMod.itemPackageSigned.field_77779_bT && mail2.field_77993_c == MrCrayfishFurnitureMod.itemPackage.field_77779_bT) {
                    mail2.field_77990_d = mail.field_77990_d;
                    mail2.func_77983_a("Author", (NBTBase)new NBTTagString("Author", player1.field_71092_bJ));
                    mail2.field_77993_c = MrCrayfishFurnitureMod.itemPackageSigned.field_77779_bT;
                    mail2.func_82834_c("Mail");
                }
                player1.func_70062_b(0, mail2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleMineBayPacket(DataInputStream inputStream, EntityPlayer player) {
        EntityPlayerMP player1 = (EntityPlayerMP)player;
        try {
            int z;
            int y;
            int x;
            TileEntity tile_entity;
            int id2 = inputStream.readInt();
            int itemNum = 0;
            if (id2 == 0 | id2 == 1) {
                itemNum = inputStream.readInt();
            }
            if ((tile_entity = player1.field_70170_p.func_72796_p(x = inputStream.readInt(), y = inputStream.readInt(), z = inputStream.readInt())) instanceof TileEntityComputer) {
                TileEntityComputer tileEntityComputer = (TileEntityComputer)tile_entity;
                if (id2 == 0) {
                    ItemData[] data = FurnitureAPI.getMineBayItems();
                    int price = data[itemNum].getPrice();
                    boolean shouldClear = inputStream.readBoolean();
                    if (shouldClear) {
                        tileEntityComputer.clearInventory();
                    } else {
                        tileEntityComputer.takeEmeraldFromSlot(price);
                    }
                    player.func_71021_b(data[itemNum].getInput().func_77946_l());
                    player.func_71029_a((StatBase)FurnitureAchievements.buyItem);
                } else if (id2 == 1) {
                    tileEntityComputer.setBrowsingInfo(itemNum);
                    PacketDispatcher.sendPacketToPlayer((Packet)tileEntityComputer.func_70319_e(), (Player)((Player)player));
                } else if (id2 == 2) {
                    if (tileEntityComputer.func_70301_a(0) != null) {
                        player1.func_71021_b(tileEntityComputer.func_70301_a(0));
                        tileEntityComputer.func_70299_a(0, null);
                    }
                    tileEntityComputer.setTrading(false);
                    PacketDispatcher.sendPacketToPlayer((Packet)tileEntityComputer.func_70319_e(), (Player)((Player)player));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleTVPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            int channel = inputStream.readInt();
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityTV) {
                TileEntityTV tileEntityTV = (TileEntityTV)tile_entity;
                tileEntityTV.setChannel(channel);
                player.field_70170_p.func_72902_n(x, y, z);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleStereoPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            int station = inputStream.readInt();
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityStereo) {
                TileEntityStereo tileEntityStereo = (TileEntityStereo)tile_entity;
                tileEntityStereo.count = station;
                if (station < 13) {
                    ItemStack itemstack = (ItemStack)BlockStereo.records.get(station);
                    player.field_70170_p.func_72934_a(((ItemRecord)itemstack.func_77973_b()).field_77837_a, x, y, z);
                    player.field_70170_p.func_72902_n(x, y, z);
                } else {
                    player.field_70170_p.func_72926_e(1005, x, y, z, 0);
                    player.field_70170_p.func_72934_a((String)null, x, y, z);
                    tileEntityStereo.setRecord(null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handlePresentPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            ItemStack present = PacketManager.readItemStack(inputStream);
            InventoryPresent presentInventory = new InventoryPresent(player, present);
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            String author = NBTHelper.getString(present, "Author");
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityPresent) {
                TileEntityPresent tileEntityPresent = (TileEntityPresent)tile_entity;
                for (int i = 0; i < presentInventory.func_70302_i_(); ++i) {
                    tileEntityPresent.setContents(i, presentInventory.func_70301_a(i));
                }
                tileEntityPresent.setOwner(author);
                PacketDispatcher.sendPacketToPlayer((Packet)tileEntityPresent.func_70319_e(), (Player)((Player)player));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleBathPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            TileEntity tile_entity2;
            int waterLevel = inputStream.readInt();
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            int x2 = inputStream.readInt();
            int y2 = inputStream.readInt();
            int z2 = inputStream.readInt();
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityBath) {
                TileEntityBath tileEntityBath = (TileEntityBath)tile_entity;
                tileEntityBath.setWaterLevel(waterLevel);
                player.field_70170_p.func_72902_n(x, y, z);
            }
            if ((tile_entity2 = player.field_70170_p.func_72796_p(x2, y2, z2)) instanceof TileEntityBath) {
                TileEntityBath tileEntityBath = (TileEntityBath)tile_entity2;
                tileEntityBath.setWaterLevel(waterLevel);
                player.field_70170_p.func_72902_n(x2, y2, z2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleBasinPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            boolean hasWater = inputStream.readBoolean();
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityBasin) {
                TileEntityBasin tileEntityBasin = (TileEntityBasin)tile_entity;
                tileEntityBasin.setHasWater(hasWater);
            }
            player.field_70170_p.func_72902_n(x, y, z);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleBinPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            int x = inputStream.readInt();
            int y = inputStream.readInt();
            int z = inputStream.readInt();
            TileEntity tile_entity = player.field_70170_p.func_72796_p(x, y, z);
            if (tile_entity instanceof TileEntityBin) {
                TileEntityBin tileEntityBin = (TileEntityBin)tile_entity;
                tileEntityBin.empty();
            }
            player.field_70170_p.func_72845_h(x, y, z);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleFartPacket(DataInputStream inputStream, EntityPlayer player) {
        try {
            double x = inputStream.readDouble();
            double y = inputStream.readDouble();
            double z = inputStream.readDouble();
            if (player.field_70154_o instanceof EntitySittableBlock) {
                player.field_70170_p.func_72908_a(x, y, z, "cfm:fart", 0.75f, 1.0f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack readItemStack(DataInput par0DataInput) throws IOException {
        ItemStack itemstack = null;
        short short1 = par0DataInput.readShort();
        if (short1 >= 0) {
            byte b0 = par0DataInput.readByte();
            short short2 = par0DataInput.readShort();
            itemstack = new ItemStack((int)short1, (int)b0, (int)short2);
            itemstack.field_77990_d = PacketManager.readNBTTagCompound(par0DataInput);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(DataInput par0DataInput) throws IOException {
        short short1 = par0DataInput.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInput.readFully(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeItemStack(ItemStack par0ItemStack, DataOutput par1DataOutput) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutput.writeShort(-1);
        } else {
            par1DataOutput.writeShort(par0ItemStack.field_77993_c);
            par1DataOutput.writeByte(par0ItemStack.field_77994_a);
            par1DataOutput.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = par0ItemStack.field_77990_d;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            PacketManager.writeNBTTagCompound(nbttagcompound, par1DataOutput);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutput par1DataOutput) throws IOException {
        if (par0NBTTagCompound == null) {
            System.out.println("null");
            par1DataOutput.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutput.writeShort((short)abyte.length);
            par1DataOutput.write(abyte);
        }
    }
}

