/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cofh.block.ISubSelectionBoxProvider;
import cofh.network.Payload;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.block.TileRSBase;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.item.TravelingItem;

public abstract class TileConduitBase
extends TileRSBase
implements ISubSelectionBoxProvider {
    public byte internalType = 0;
    public static Cuboid6[] subSelection = new Cuboid6[6];

    public TileConduitBase() {
    }

    public boolean canUpdate() {
        return false;
    }

    public TileConduitBase(int type) {
        this.internalType = BlockConduit.internalTypeMap[type];
    }

    public String getName() {
        return "tile.thermalexpansion.conduit." + BlockConduit.NAMES[this.getType()] + ".name";
    }

    public boolean punchSide(EntityPlayer player, int subHit) {
        return false;
    }

    public boolean punchMiddle(EntityPlayer player, int hitSide) {
        return false;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte(this.internalType);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.internalType = payload.getByte();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public FluidStack getRenderFluid() {
        return null;
    }

    public int getRenderFluidLevel() {
        return 0;
    }

    public List<TravelingItem> getRenderItems() {
        return null;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.internalType = nbt.func_74771_c("SubType");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("SubType", this.internalType);
    }

    public void setRouteInvalid() {
    }

    public void setUnvisited() {
    }

    public void cacheTile(TileEntity theTile, int side) {
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        double minZ = 0.3;
        double minY = 0.3;
        double minX = 0.3;
        double maxZ = 0.7;
        double maxY = 0.7;
        double maxX = 0.7;
        Vector3 pos = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
        cuboids.add(new IndexedCuboid6((Object)6, new Cuboid6(minX, minY, minZ, maxX, maxY, maxZ).add(pos)));
    }

    public abstract int getRenderType();

    public abstract int getConnectionType(int var1);

    public int[] getConnectionTypeArray() {
        return new int[]{this.getConnectionType(0), this.getConnectionType(1), this.getConnectionType(2), this.getConnectionType(3), this.getConnectionType(4), this.getConnectionType(5)};
    }

    public int getStuffedSize() {
        return 0;
    }

    static {
        double min = 0.25;
        double max = 0.75;
        double min2 = 0.2;
        double max2 = 0.8;
        TileConduitBase.subSelection[0] = new Cuboid6(min2, 0.0, min2, max2, min, max2);
        TileConduitBase.subSelection[1] = new Cuboid6(min2, 1.0 - min, min2, max2, 1.0, max2);
        TileConduitBase.subSelection[2] = new Cuboid6(min2, min2, 0.0, max2, max2, min);
        TileConduitBase.subSelection[3] = new Cuboid6(min2, min2, 1.0 - min, max2, max2, 1.0);
        TileConduitBase.subSelection[4] = new Cuboid6(0.0, min2, min2, min, max2, max2);
        TileConduitBase.subSelection[5] = new Cuboid6(1.0 - min, min2, min2, 1.0, max2, max2);
    }

    public static class FluidRenderType {
        public static final byte EMPTY = 0;
        public static final byte LOW = 1;
        public static final byte LOW_MED = 2;
        public static final byte MEDIUM = 3;
        public static final byte MED_HIGH = 4;
        public static final byte HIGH = 5;
        public static final byte FULL = 6;
    }
}

