/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cofh.render.IconRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class PartItemBase
extends Item {
    public HashMap<Integer, ItemEntry> itemMap = new HashMap();
    public ArrayList<Integer> itemList = new ArrayList();

    public PartItemBase(int i) {
        super(i);
        this.func_77627_a(true);
    }

    public ItemStack addItem(int number, String name, int rarity, boolean register) {
        if (this.itemMap.containsKey(number)) {
            return null;
        }
        this.itemMap.put(number, new ItemEntry(name, rarity));
        this.itemList.add(number);
        ItemStack item = new ItemStack(this.field_77779_bT, 1, number);
        if (register) {
            GameRegistry.registerCustomItemStack((String)name, (ItemStack)item);
        }
        return item;
    }

    public ItemStack addItem(int number, String name, int rarity) {
        return this.addItem(number, name, rarity, true);
    }

    public ItemStack addItem(int number, String name) {
        return this.addItem(number, name, 0);
    }

    public Icon func_77617_a(int i) {
        if (!this.itemMap.containsKey(i)) {
            return null;
        }
        return IconRegistry.getIcon((String)this.itemMap.get((Object)Integer.valueOf((int)i)).name);
    }

    public String func_77667_c(ItemStack itemstack) {
        int i = itemstack.func_77960_j();
        if (!this.itemMap.containsKey(i)) {
            return "item.invalid";
        }
        return this.func_77658_a().replace("item", "tile") + '.' + this.itemMap.get((Object)Integer.valueOf((int)i)).name;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        int i = itemstack.func_77960_j();
        if (!this.itemMap.containsKey(i)) {
            return EnumRarity.common;
        }
        return EnumRarity.values()[this.itemMap.get((Object)Integer.valueOf((int)itemstack.func_77960_j())).rarity];
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            list.add(new ItemStack(itemId, 1, this.itemList.get(i).intValue()));
        }
    }

    public void func_94581_a(IconRegister ir) {
    }

    public TMultiPart newPart(ItemStack arg0, EntityPlayer arg1, World arg2, BlockCoord arg3, int arg4, Vector3 arg5) {
        return null;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockCoord pos = new BlockCoord(x, y, z);
        Vector3 vhit = new Vector3((double)hitX, (double)hitY, (double)hitZ);
        double d = this.getHitDepth(vhit, side);
        if (d < 1.0 && this.placePart(item, player, world, pos, side, vhit)) {
            return true;
        }
        pos.offset(side);
        return this.placePart(item, player, world, pos, side, vhit);
    }

    boolean placePart(ItemStack item, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 vHit) {
        TMultiPart part = this.newPart(item, player, world, pos, side, vHit);
        if (part == null || !TileMultipart.canPlacePart((World)world, (BlockCoord)pos, (TMultiPart)part)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            world.func_72908_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, Block.field_71974_j.func_82593_b(), (Block.field_71974_j.func_72677_b() + 1.0f) / 2.0f, Block.field_71974_j.func_72678_c() * 0.8f);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --item.field_77994_a;
        }
        return true;
    }

    double getHitDepth(Vector3 vhit, int side) {
        return vhit.copy().scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }

    public class ItemEntry {
        public String name;
        public int rarity = 0;
        public int maxDamage = 0;

        public ItemEntry(String name, int rarity, int maxDamage) {
            this.name = name;
            this.rarity = rarity;
            this.maxDamage = maxDamage;
        }

        public ItemEntry(String name, int rarity) {
            this.name = name;
            this.rarity = rarity;
        }

        public ItemEntry(String name) {
            this.name = name;
        }
    }
}

