/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.JCuboidPart;
import cofh.api.tileentity.IRedstoneControl;
import cofh.util.ServerHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.network.TEPacketHandler;

public abstract class PartRSBase
extends JCuboidPart
implements IRedstoneControl {
    public boolean isPowered;
    protected boolean rsDisable;
    protected boolean rsSetting;
    protected boolean wasPowered;

    public boolean redstoneControlOrDisable() {
        return this.rsDisable || this.isPowered == this.rsSetting;
    }

    public void handleRedstoneUpdate(boolean newPowered) {
        this.isPowered = newPowered;
    }

    public void onNeighborChanged() {
        if (this.sendRedstoneUpdates()) {
            boolean wasPowered = this.isPowered;
            this.isPowered = this.world().func_72864_z(this.x(), this.y(), this.z());
            if (wasPowered != this.isPowered && ServerHelper.isServerWorld((World)this.world())) {
                TEPacketHandler.sendRSPowerUpdatePacketToClients(this, this.world(), this.x(), this.y(), this.z());
            }
        } else {
            this.isPowered = this.world().func_72864_z(this.x(), this.y(), this.z());
        }
    }

    public void onNeighborChangedRS() {
        if (this.sendRedstoneUpdates()) {
            boolean wasPowered = this.isPowered;
            this.isPowered = this.world().func_72864_z(this.x(), this.y(), this.z());
            if (wasPowered != this.isPowered && ServerHelper.isServerWorld((World)this.world())) {
                TEPacketHandler.sendRSPowerUpdatePacketToClients(this, this.world(), this.x(), this.y(), this.z());
            }
        } else {
            this.isPowered = this.world().func_72864_z(this.x(), this.y(), this.z());
        }
    }

    public boolean sendRedstoneUpdates() {
        return false;
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.onNeighborChanged();
    }

    public void writeDesc(MCDataOutput payload) {
        super.writeDesc(payload);
        payload.writeBoolean(this.isPowered);
        payload.writeBoolean(this.rsDisable);
        payload.writeBoolean(this.rsSetting);
    }

    public void readDesc(MCDataInput payload) {
        super.readDesc(payload);
        this.isPowered = payload.readBoolean();
        this.rsDisable = payload.readBoolean();
        this.rsSetting = payload.readBoolean();
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        NBTTagCompound rsControl = nbt.func_74775_l("RS");
        this.isPowered = rsControl.func_74767_n("Powered");
        this.rsDisable = rsControl.func_74767_n("Disable");
        this.rsSetting = rsControl.func_74767_n("Setting");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        NBTTagCompound rsControl = new NBTTagCompound();
        rsControl.func_74757_a("Powered", this.isPowered);
        rsControl.func_74757_a("Disable", this.rsDisable);
        rsControl.func_74757_a("Setting", this.rsSetting);
        nbt.func_74782_a("RS", (NBTBase)rsControl);
    }

    public boolean getControlDisable() {
        return this.rsDisable;
    }

    public boolean getControlSetting() {
        return this.rsSetting;
    }

    public boolean setControlDisable(boolean disable) {
        this.rsDisable = disable;
        return true;
    }

    public boolean setControlSetting(boolean setting) {
        this.rsSetting = setting;
        return true;
    }

    public boolean setRedstoneConfig(boolean disable, boolean setting) {
        this.rsDisable = disable;
        this.rsSetting = setting;
        if (ServerHelper.isClientWorld((World)this.world())) {
            TEPacketHandler.sendRSConfigUpdatePacketToServer(this, this.x(), this.y(), this.z());
        }
        return true;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void handlePowerUpdate(boolean powered) {
        this.isPowered = powered;
        this.tile().markRender();
    }

    public void handleConfigUpdate(boolean disable, boolean setting) {
        this.rsDisable = disable;
        this.rsSetting = setting;
        this.sendDescUpdate();
    }
}

