/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.fluid;

import cofh.core.ProxyClient;
import cofh.hud.CoFHHUD;
import cofh.hud.HUDHelper;
import cofh.hud.IHUDModule;
import cofh.render.RenderHelper;
import cofh.util.StringHelper;
import cofh.util.TimeTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.TEProps;
import thermalexpansion.part.conduit.IConduit;

public class HUDModuleFluid
implements IHUDModule {
    public static final HUDModuleFluid instance = new HUDModuleFluid();
    public static int moduleID;
    public static final int UPDATE_DELAY = 64;
    public TimeTracker myTimeTracker = new TimeTracker();
    int blockX;
    int blockY;
    int blockZ;
    int widthModifier = 0;
    public FluidStack fluidToRender;

    public static void initialize() {
        if (TEProps.enableFluidModule) {
            CoFHHUD.registerHUDModule((IHUDModule)instance);
        }
    }

    public void renderHUD(Minecraft mc, int scaledHeight, int scaledWidth) {
        if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == EnumMovingObjectType.TILE) {
            IConduit theConduit;
            TileEntity theTile = mc.field_71441_e.func_72796_p(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            if (theTile instanceof IConduit && (theConduit = (IConduit)theTile).isFluidConduit() && theConduit.getConduitFluid().getRenderFluid() != null) {
                this.fluidToRender = theConduit.getConduitFluid().getRenderFluid().copy();
                this.doRender(false, scaledHeight, scaledWidth);
                return;
            }
        } else {
            this.blockZ = 0;
            this.blockY = 0;
            this.blockX = 0;
        }
        if (this.widthModifier > 0) {
            this.doRender(true, scaledHeight, scaledWidth);
        } else {
            this.widthModifier = 0;
        }
    }

    public void doRender(boolean reverseAnimation, int scaledHeight, int scaledWidth) {
        if (this.fluidToRender == null || this.fluidToRender.getFluid() == null) {
            this.widthModifier -= 5;
            return;
        }
        int width = 0;
        int absWidth = 0;
        width = ProxyClient.fontRenderer.func_78256_a(this.fluidToRender.getFluid().getLocalizedName());
        GL11.glDisable((int)32826);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        absWidth = width += 35;
        if (reverseAnimation) {
            this.widthModifier -= 5;
            width = this.widthModifier;
        } else {
            this.widthModifier += 5;
            if (this.widthModifier < width) {
                width = this.widthModifier;
            } else {
                this.widthModifier = width;
            }
        }
        int height = 40;
        HUDHelper.drawTooltipBoxOnSide((int)width, (int)height, (int)scaledHeight, (int)scaledWidth, (ForgeDirection)ForgeDirection.EAST);
        HUDHelper.drawTooltipString((int)(scaledWidth - width + 2 + (absWidth - ProxyClient.fontRenderer.func_78256_a(StringHelper.localize((String)"info.cofh.fluid"))) / 2), (int)(scaledHeight / 2 - height / 2 + 6), (int)-1, (String)StringHelper.localize((String)"info.cofh.fluid"));
        RenderHelper.setDefaultFontTextureSheet();
        HUDHelper.drawTooltipStringOnSide((int)(width - 2), (int)height, (int)scaledHeight, (int)scaledWidth, (ForgeDirection)ForgeDirection.EAST, (int)1, (String)this.fluidToRender.getFluid().getLocalizedName());
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub((int)this.fluidToRender.getFluid().getColor(this.fluidToRender));
        HUDHelper.drawFixedIconOnSide((Icon)this.fluidToRender.getFluid().getIcon(this.fluidToRender), (int)width, (int)height, (int)scaledHeight, (int)scaledWidth, (ForgeDirection)ForgeDirection.EAST, (int)1);
        GL11.glEnable((int)32826);
    }

    public void setModuleID(int i) {
        moduleID = i;
    }

    public void clientTick(Minecraft mc) {
    }
}

