/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.api.core.RegistryAccess;
import cofh.command.CommandCape;
import cofh.command.CommandHandler;
import cofh.command.CommandSkin;
import cofh.core.CoFHProps;
import cofh.masquerade.MasqueradePacketHandler;
import cofh.masquerade.RegistryCapes;
import cofh.masquerade.RegistrySkins;
import cofh.util.ConfigHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import java.util.logging.Logger;
import net.minecraftforge.common.Configuration;

@Mod(modid="CoFHMasquerade", name="CoFH Masquerade", version="2.0.0.5", dependencies="required-after:CoFHCore@[2.0.0.5,)")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class CoFHMasquerade {
    @Mod.Instance(value="CoFHMasquerade")
    public static CoFHMasquerade instance;
    public static final Logger log;
    public static final ConfigHandler config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CommandHandler.registerSubCommand(CommandCape.instance);
        CommandHandler.registerSubCommand(CommandSkin.instance);
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHMasquerade.cfg")));
        RegistryAccess.capeRegistry = new RegistryCapes();
        RegistryAccess.skinRegistry = new RegistrySkins();
        RegistryCapes.initialize();
        RegistrySkins.initialize();
        String category = "general";
        String comment = null;
        category = "feature.capes";
        comment = "Allows all players to use /cofh cape set.";
        RegistryCapes.allowPlayersUse = config.get(category, "AllowEveryone", true, comment);
        comment = "Allows Ops to use /cofh cape set and /cofh cape set (user) if that is also allowed.";
        RegistryCapes.allowOpsUse = config.get(category, "AllowOps", true, comment);
        comment = "Allows Ops to set the capes of others, if Ops are allowed to set capes.";
        RegistryCapes.allowOpsOthers = config.get(category, "AllowOpsToSetOthers", false, comment);
        category = "feature.skins";
        comment = "Allows all players to use /cofh skin set.";
        RegistrySkins.allowPlayersUse = config.get(category, "AllowEveryone", true, comment);
        comment = "Allows Ops to use /cofh skin set and /cofh skin set (user) if that is also allowed.";
        RegistrySkins.allowOpsUse = config.get(category, "AllowOps", true, comment);
        comment = "Allows Ops to set the skins of others, if Ops are allowed to set skins.";
        RegistrySkins.allowOpsOthers = config.get(category, "AllowOpsToSetOthers", false, comment);
        config.save();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MasqueradePacketHandler.initialize();
        config.cleanUp(false, false);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    static {
        log = Logger.getLogger("CoFHMasquerade");
        config = new ConfigHandler("2.0.0.5");
        log.setParent(FMLLog.getLogger());
    }
}

