/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public final class StringHelper {
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";
    public static boolean displayShiftForDetail = true;
    public static boolean displayStackCount = false;
    public static String shiftForInfo = "\u00a77" + StringHelper.localize("message.cofh.holdShift1") + " " + "\u00a7e" + "\u00a7o" + StringHelper.localize("message.cofh.holdShift2") + " " + "\u00a7r" + "\u00a77" + StringHelper.localize("message.cofh.holdShift3") + "\u00a7r";

    private StringHelper() {
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String input, int width) {
        List stringRows = fontRenderer.func_78271_c(input, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static String camelCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String localize(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static String getFluidName(FluidStack fluid) {
        return StringHelper.getFluidName(fluid.getFluid());
    }

    public static String getFluidName(Fluid fluid) {
        String fluidName = "";
        if (fluid.getRarity() == EnumRarity.uncommon) {
            fluidName = fluidName + YELLOW;
        } else if (fluid.getRarity() == EnumRarity.rare) {
            fluidName = fluidName + BRIGHT_BLUE;
        } else if (fluid.getRarity() == EnumRarity.epic) {
            fluidName = fluidName + PINK;
        }
        fluidName = fluidName + fluid.getLocalizedName() + END;
        return fluidName;
    }

    public static String getScaledNumber(int number) {
        return StringHelper.getScaledNumber(number, 2);
    }

    public static String getScaledNumber(int number, int minDigits) {
        String numString = "";
        int numMod = 10 * minDigits;
        numString = number > 100000 * numMod ? numString + number / 1000000 + "M" : (number > 100 * numMod ? numString + number / 1000 + "k" : numString + number);
        return numString;
    }

    public static String getShiftText() {
        return shiftForInfo;
    }

    public static String getActivationText(String key) {
        return "\u00a7b\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getDeactivationText(String key) {
        return "\u00a7e\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getInfoText(String key) {
        return BRIGHT_GREEN + StringHelper.localize(key) + END;
    }

    public static String getFlavorText(String key) {
        return "\u00a7f\u00a7o" + StringHelper.localize(key) + END;
    }
}

