/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.ps;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.ps.Filterbank;
import net.sourceforge.jaad.aac.ps.Huffman;
import net.sourceforge.jaad.aac.ps.HuffmanTables;
import net.sourceforge.jaad.aac.ps.PSConstants;
import net.sourceforge.jaad.aac.ps.PSTables;
import net.sourceforge.jaad.aac.ps.Utils;
import net.sourceforge.jaad.aac.syntax.BitStream;

public class PS
implements PSConstants,
PSTables,
HuffmanTables {
    private boolean header;
    private boolean enableIID;
    private boolean enableICC;
    private boolean enableExt;
    private boolean enableIPDOPD;
    private int iidMode;
    private int iccMode;
    private boolean iidQuant;
    private int iidParCount;
    private int iccParCount;
    private int ipdopdParCount;
    private boolean use34;
    private boolean use34Old;
    private int frameClass;
    private int envCount;
    private int envCountOld;
    private final int[] borderPositions;
    private final int[][] iidPars = new int[5][34];
    private final int[][] iccPars = new int[5][34];
    private final int[][] ipdPars = new int[5][34];
    private final int[][] opdPars = new int[5][34];
    private final int[] iidParsPrev = new int[34];
    private final int[] iccParsPrev = new int[34];
    private final int[] ipdParsPrev = new int[34];
    private final int[] opdParsPrev = new int[34];
    private float[][][] in_buf;
    private float[][][] delay;
    private float[][][][] ap_delay;
    private float[] peak_decay_nrg;
    private float[] power_smooth;
    private float[] peak_decay_diff_smooth;
    private float[][][] H11;
    private float[][][] H12;
    private float[][][] H21;
    private float[][][] H22;
    private int[] ipd_hist;
    private int[] opd_hist;
    private int frame = 0;

    public PS() {
        this.borderPositions = new int[6];
        this.in_buf = new float[5][44][2];
        this.delay = new float[91][46][2];
        this.ap_delay = new float[50][3][37][2];
        this.peak_decay_nrg = new float[34];
        this.power_smooth = new float[34];
        this.peak_decay_diff_smooth = new float[34];
        this.H11 = new float[2][6][34];
        this.H12 = new float[2][6][34];
        this.H21 = new float[2][6][34];
        this.H22 = new float[2][6][34];
        this.ipd_hist = new int[34];
        this.opd_hist = new int[34];
    }

    public int decode(BitStream in) throws AACException {
        boolean time;
        int i;
        int i2;
        ++this.frame;
        int off = in.getPosition();
        if (in.readBool()) {
            this.header = true;
            this.enableIID = in.readBool();
            if (this.enableIID) {
                this.iidMode = in.readBits(3);
                this.iidQuant = this.iidMode > 2;
                this.iidParCount = IID_ICC_PAR_TABLE[this.iidMode];
                this.ipdopdParCount = IPDOPD_PAR_TABLE[this.iidMode];
            }
            if (this.enableICC = in.readBool()) {
                this.iccMode = in.readBits(3);
                this.iccParCount = IID_ICC_PAR_TABLE[this.iccMode];
            }
            this.enableExt = in.readBool();
        }
        this.frameClass = in.readBit();
        this.envCountOld = this.envCount;
        this.envCount = ENV_COUNT_TABLE[this.frameClass][in.readBits(2)];
        this.borderPositions[0] = -1;
        if (this.frameClass == 1) {
            for (i2 = 1; i2 <= this.envCount; ++i2) {
                this.borderPositions[i2] = in.readBits(5);
            }
        } else {
            for (i2 = 1; i2 <= this.envCount; ++i2) {
                this.borderPositions[i2] = (i2 * 32 >> LOG2_TABLE[this.envCount]) - 1;
            }
        }
        if (this.enableIID) {
            for (i = 0; i < this.envCount; ++i) {
                time = in.readBool();
                this.decodeIIDData(in, time, i);
            }
        } else {
            Arrays.fill((Object[])this.iidPars, new int[34]);
        }
        if (this.enableICC) {
            for (i = 0; i < this.envCount; ++i) {
                time = in.readBool();
                this.decodeICCData(in, time, i);
            }
        } else {
            Arrays.fill((Object[])this.iccPars, new int[34]);
        }
        this.use34Old = this.use34;
        if (this.enableIID || this.enableICC) {
            boolean bl = this.use34 = this.enableIID && this.iidParCount == 34 || this.enableICC && this.iccParCount == 34;
        }
        if (this.enableExt) {
            int bitsLeft;
            int id;
            int size = in.readBits(4);
            if (size == 15) {
                size += in.readBits(8);
            }
            for (bitsLeft = 8 * size; bitsLeft > 7; bitsLeft -= this.decodeExtension(in, id)) {
                id = in.readBits(2);
                bitsLeft -= 2;
            }
            in.skipBits(bitsLeft);
        }
        if (this.envCount == 0 || this.borderPositions[this.envCount] < 31) {
            int source;
            int n = source = this.envCount != 0 ? this.envCount - 1 : this.envCountOld - 1;
            if (source >= 0 && source != this.envCount) {
                if (this.enableIID) {
                    System.arraycopy(this.iidPars[source], 0, this.iidPars[this.envCount], 0, this.iidPars[source].length);
                }
                if (this.enableICC) {
                    System.arraycopy(this.iccPars[source], 0, this.iccPars[this.envCount], 0, this.iccPars[source].length);
                }
                if (this.enableIPDOPD) {
                    System.arraycopy(this.ipdPars[source], 0, this.ipdPars[this.envCount], 0, this.ipdPars[source].length);
                    System.arraycopy(this.opdPars[source], 0, this.opdPars[this.envCount], 0, this.opdPars[source].length);
                }
            }
            ++this.envCount;
            this.borderPositions[this.envCount] = 31;
        }
        if (this.enableIPDOPD) {
            Arrays.fill((Object[])this.ipdPars, new int[34]);
            Arrays.fill((Object[])this.opdPars, new int[34]);
        }
        System.arraycopy(this.iidPars[this.envCount - 1], 0, this.iidParsPrev, 0, 34);
        System.arraycopy(this.iccPars[this.envCount - 1], 0, this.iccParsPrev, 0, 34);
        System.arraycopy(this.ipdPars[this.envCount - 1], 0, this.ipdParsPrev, 0, 17);
        System.arraycopy(this.opdPars[this.envCount - 1], 0, this.opdParsPrev, 0, 17);
        int read = in.getPosition() - off;
        return read;
    }

    private int decodeExtension(BitStream in, int id) throws AACException {
        int off = in.getPosition();
        if (id == 0) {
            this.enableIPDOPD = in.readBool();
            if (this.enableIPDOPD) {
                for (int i = 0; i < this.envCount; ++i) {
                    boolean time = in.readBool();
                    this.decodeIPDData(in, time, i);
                    time = in.readBool();
                    this.decodeOPDData(in, time, i);
                }
            }
            in.skipBit();
        }
        return in.getPosition() - off;
    }

    private void decodeIIDData(BitStream in, boolean time, int index) throws AACException {
        int[][] table = this.iidQuant ? (time ? HUFFMAN_IID_FINE_DT : HUFFMAN_IID_FINE_DF) : (time ? HUFFMAN_IID_DEFAULT_DT : HUFFMAN_IID_DEFAULT_DF);
        Huffman.decode(in, table, this.iidPars[index], this.iidParCount);
        int[] iidP = index == 0 ? this.iidParsPrev : this.iidPars[index - 1];
        int iidSteps = this.iidQuant ? 15 : 7;
        Utils.deltaDecode(this.iidPars[index], this.iidParCount, iidP, time, this.enableIID, this.iidMode == 0 || this.iidMode == 3 ? 2 : 1, -iidSteps, iidSteps);
    }

    private void decodeICCData(BitStream in, boolean time, int index) throws AACException {
        int[][] table = time ? HUFFMAN_ICC_DT : HUFFMAN_ICC_DF;
        Huffman.decode(in, table, this.iccPars[index], this.iccParCount);
        int[] iccP = index == 0 ? this.iccParsPrev : this.iccPars[index - 1];
        Utils.deltaDecode(this.iccPars[index], this.iccParCount, iccP, time, this.enableICC, this.iccMode == 0 || this.iccMode == 3 ? 2 : 1, 0, 7);
    }

    private void decodeIPDData(BitStream in, boolean time, int index) throws AACException {
        int[][] table = time ? HUFFMAN_IPD_DT : HUFFMAN_IPD_DF;
        Huffman.decode(in, table, this.ipdPars[index], this.ipdopdParCount);
        int[] ipdP = index == 0 ? this.ipdParsPrev : this.ipdPars[index - 1];
        Utils.deltaModuloDecode(this.ipdPars[index], this.ipdopdParCount, ipdP, time, this.enableIPDOPD);
    }

    private void decodeOPDData(BitStream in, boolean time, int index) throws AACException {
        int[][] table = time ? HUFFMAN_OPD_DT : HUFFMAN_OPD_DF;
        Huffman.decode(in, table, this.opdPars[index], this.ipdopdParCount);
        int[] opdP = index == 0 ? this.opdParsPrev : this.opdPars[index - 1];
        Utils.deltaModuloDecode(this.opdPars[index], this.ipdopdParCount, opdP, time, this.enableIPDOPD);
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void process(float[][][] left, float[][][] right, int top) {
        float[][][] lBuf = new float[91][32][2];
        float[][][] rBuf = new float[91][32][2];
        int use34I = this.use34 ? 1 : 0;
        Arrays.fill((Object[])this.delay, top += BANDS[use34I] - 64, BANDS[use34I], new float[46][2]);
        if (top < ALLPASS_BANDS[use34I]) {
            Arrays.fill((Object[])this.ap_delay, top, ALLPASS_BANDS[use34I], new float[3][37][2]);
        }
        Filterbank.performAnalysis(left, lBuf, this.in_buf, this.use34);
        this.decorrelate(lBuf, rBuf);
        this.processStereo(lBuf, rBuf);
        Filterbank.performSynthesis(lBuf, left, this.use34);
        Filterbank.performSynthesis(rBuf, right, this.use34);
    }

    private void decorrelate(float[][][] s, float[][][] out) {
        int i;
        int k;
        int n;
        float[][] power = new float[34][32];
        float[][] transient_gain = new float[34][32];
        int[] k_to_i = this.use34 ? K_TO_I_34 : K_TO_I_20;
        int use34I = this.use34 ? 1 : 0;
        int n0 = 0;
        int nL = 32;
        if (this.use34 != this.use34Old) {
            Arrays.fill(this.peak_decay_nrg, 0.0f);
            Arrays.fill(this.power_smooth, 0.0f);
            Arrays.fill(this.peak_decay_diff_smooth, 0.0f);
            this.delay = new float[91][46][2];
            this.ap_delay = new float[50][3][37][2];
        }
        for (n = n0; n < nL; ++n) {
            for (k = 0; k < BANDS[use34I]; ++k) {
                i = k_to_i[k];
                float[] fArray = power[i];
                int n2 = n;
                fArray[n2] = fArray[n2] + (s[k][n][0] * s[k][n][0] + s[k][n][1] * s[k][n][1]);
            }
        }
        for (i = 0; i < PAR_BANDS[use34I]; ++i) {
            for (n = n0; n < nL; ++n) {
                float decayed_peak = 0.7659283f * this.peak_decay_nrg[i];
                this.peak_decay_nrg[i] = Math.max(decayed_peak, power[i][n]);
                int n3 = i;
                this.power_smooth[n3] = this.power_smooth[n3] + 0.25f * (power[i][n] - this.power_smooth[i]);
                int n4 = i;
                this.peak_decay_diff_smooth[n4] = this.peak_decay_diff_smooth[n4] + 0.25f * (this.peak_decay_nrg[i] - power[i][n] - this.peak_decay_diff_smooth[i]);
                float denom = 1.5f * this.peak_decay_diff_smooth[i];
                transient_gain[i][n] = denom > this.power_smooth[i] ? this.power_smooth[i] / denom : 1.0f;
            }
        }
        for (k = 0; k < ALLPASS_BANDS[use34I]; ++k) {
            int m;
            int b = k_to_i[k];
            float g_decay_slope = 1.0f - 0.05f * (float)(k - DECAY_CUTOFF[use34I]);
            float[] ag = new float[3];
            g_decay_slope = Math.min(Math.max(g_decay_slope, 0.0f), 1.0f);
            this.copyArray(this.delay[k], nL, this.delay[k], 0, 14);
            this.copyArray(s[k], 0, this.delay[k], 14, 32);
            for (m = 0; m < 3; ++m) {
                this.copyArray(this.ap_delay[k][m], 32, this.ap_delay[k][m], 0, 5);
                ag[m] = FILTER_COEF_A[m] * g_decay_slope;
            }
            for (n = n0; n < nL; ++n) {
                float in_re = this.delay[k][n + 14 - 2][0] * PHI_FRACT[use34I][k][0] - this.delay[k][n + 14 - 2][1] * PHI_FRACT[use34I][k][1];
                float in_im = this.delay[k][n + 14 - 2][0] * PHI_FRACT[use34I][k][1] + this.delay[k][n + 14 - 2][1] * PHI_FRACT[use34I][k][0];
                for (m = 0; m < 3; ++m) {
                    float a_re = ag[m] * in_re;
                    float a_im = ag[m] * in_im;
                    float link_delay_re = this.ap_delay[k][m][n + 5 - LINK_DELAY[m]][0];
                    float link_delay_im = this.ap_delay[k][m][n + 5 - LINK_DELAY[m]][1];
                    float fractional_delay_re = Q_FRACT_ALLPASS[use34I][k][m][0];
                    float fractional_delay_im = Q_FRACT_ALLPASS[use34I][k][m][1];
                    this.ap_delay[k][m][n + 5][0] = in_re;
                    this.ap_delay[k][m][n + 5][1] = in_im;
                    in_re = link_delay_re * fractional_delay_re - link_delay_im * fractional_delay_im - a_re;
                    in_im = link_delay_re * fractional_delay_im + link_delay_im * fractional_delay_re - a_im;
                    float[] fArray = this.ap_delay[k][m][n + 5];
                    fArray[0] = fArray[0] + ag[m] * in_re;
                    float[] fArray2 = this.ap_delay[k][m][n + 5];
                    fArray2[1] = fArray2[1] + ag[m] * in_im;
                }
                out[k][n][0] = transient_gain[b][n] * in_re;
                out[k][n][1] = transient_gain[b][n] * in_im;
            }
        }
        while (k < SHORT_DELAY_BAND[use34I]) {
            this.copyArray(this.delay[k], nL, this.delay[k], 0, 14);
            this.copyArray(s[k], 0, this.delay[k], 14, 32);
            for (n = n0; n < nL; ++n) {
                out[k][n][0] = transient_gain[k_to_i[k]][n] * this.delay[k][n + 14 - 14][0];
                out[k][n][1] = transient_gain[k_to_i[k]][n] * this.delay[k][n + 14 - 14][1];
            }
            ++k;
        }
        while (k < BANDS[use34I]) {
            this.copyArray(this.delay[k], nL, this.delay[k], 0, 14);
            this.copyArray(s[k], 0, this.delay[k], 14, 32);
            for (n = n0; n < nL; ++n) {
                out[k][n][0] = transient_gain[k_to_i[k]][n] * this.delay[k][n + 14 - 1][0];
                out[k][n][1] = transient_gain[k_to_i[k]][n] * this.delay[k][n + 14 - 1][1];
            }
            ++k;
        }
    }

    private void copyArray(float[][] from, int fromOff, float[][] to, int toOff, int len) {
        for (int i = 0; i < len; ++i) {
            to[toOff + i][0] = from[fromOff + i][0];
            to[toOff + i][1] = from[fromOff + i][1];
        }
    }

    private void processStereo(float[][][] l, float[][][] r) {
        int[][] iidMapped = new int[5][34];
        int[][] iccMapped = new int[5][34];
        int[][] ipdMapped = new int[5][34];
        int[][] opdMapped = new int[5][34];
        int[] k_to_i = this.use34 ? K_TO_I_34 : K_TO_I_20;
        float[][][] H_LUT = this.iidQuant ? HB : HA;
        int use34I = this.use34 ? 1 : 0;
        System.arraycopy(this.H11[0][this.envCountOld], 0, this.H11[0][0], 0, 34);
        System.arraycopy(this.H11[1][this.envCountOld], 0, this.H11[1][0], 0, 34);
        System.arraycopy(this.H12[0][this.envCountOld], 0, this.H12[0][0], 0, 34);
        System.arraycopy(this.H12[1][this.envCountOld], 0, this.H12[1][0], 0, 34);
        System.arraycopy(this.H21[0][this.envCountOld], 0, this.H21[0][0], 0, 34);
        System.arraycopy(this.H21[1][this.envCountOld], 0, this.H21[1][0], 0, 34);
        System.arraycopy(this.H22[0][this.envCountOld], 0, this.H22[0][0], 0, 34);
        System.arraycopy(this.H22[1][this.envCountOld], 0, this.H22[1][0], 0, 34);
        if (this.use34) {
            Utils.remap34(iidMapped, this.iidPars, this.iidParCount, this.envCount, true);
            Utils.remap34(iccMapped, this.iccPars, this.iccParCount, this.envCount, true);
            if (this.enableIPDOPD) {
                Utils.remap34(ipdMapped, this.ipdPars, this.ipdopdParCount, this.envCount, false);
                Utils.remap34(opdMapped, this.opdPars, this.ipdopdParCount, this.envCount, false);
            }
            if (this.use34Old) {
                Utils.map20To34Float(this.H11[0][0]);
                Utils.map20To34Float(this.H11[1][0]);
                Utils.map20To34Float(this.H12[0][0]);
                Utils.map20To34Float(this.H12[1][0]);
                Utils.map20To34Float(this.H21[0][0]);
                Utils.map20To34Float(this.H21[1][0]);
                Utils.map20To34Float(this.H22[0][0]);
                Utils.map20To34Float(this.H22[1][0]);
                this.resetIPDOPD();
            }
        } else {
            Utils.remap20(iidMapped, this.iidPars, this.iidParCount, this.envCount, true);
            Utils.remap20(iccMapped, this.iccPars, this.iccParCount, this.envCount, true);
            if (this.enableIPDOPD) {
                Utils.remap20(ipdMapped, this.ipdPars, this.ipdopdParCount, this.envCount, false);
                Utils.remap20(opdMapped, this.opdPars, this.ipdopdParCount, this.envCount, false);
            }
            if (this.use34Old) {
                Utils.map34To20Float(this.H11[0][0]);
                Utils.map34To20Float(this.H11[1][0]);
                Utils.map34To20Float(this.H12[0][0]);
                Utils.map34To20Float(this.H12[1][0]);
                Utils.map34To20Float(this.H21[0][0]);
                Utils.map34To20Float(this.H21[1][0]);
                Utils.map34To20Float(this.H22[0][0]);
                Utils.map34To20Float(this.H22[1][0]);
                this.resetIPDOPD();
            }
        }
        int iidQuantI = this.iidQuant ? 1 : 0;
        for (int e = 0; e < this.envCount; ++e) {
            float h22i;
            float h21i;
            float h12i;
            float h11i;
            int b;
            for (b = 0; b < PAR_BANDS[use34I]; ++b) {
                float h11 = H_LUT[iidMapped[e][b] + 7 + 23 * iidQuantI][iccMapped[e][b]][0];
                float h12 = H_LUT[iidMapped[e][b] + 7 + 23 * iidQuantI][iccMapped[e][b]][1];
                float h21 = H_LUT[iidMapped[e][b] + 7 + 23 * iidQuantI][iccMapped[e][b]][2];
                float h22 = H_LUT[iidMapped[e][b] + 7 + 23 * iidQuantI][iccMapped[e][b]][3];
                if (this.enableIPDOPD && b < this.ipdopdParCount) {
                    int opd_idx = this.opd_hist[b] * 8 + opdMapped[e][b];
                    int ipd_idx = this.ipd_hist[b] * 8 + ipdMapped[e][b];
                    float opd_re = PD_RE_SMOOTH[opd_idx];
                    float opd_im = PD_IM_SMOOTH[opd_idx];
                    float ipd_re = PD_RE_SMOOTH[ipd_idx];
                    float ipd_im = PD_IM_SMOOTH[ipd_idx];
                    this.opd_hist[b] = opd_idx & 0x3F;
                    this.ipd_hist[b] = ipd_idx & 0x3F;
                    float ipd_adj_re = opd_re * ipd_re + opd_im * ipd_im;
                    float ipd_adj_im = opd_im * ipd_re - opd_re * ipd_im;
                    h11i = h11 * opd_im;
                    h11 *= opd_re;
                    h12i = h12 * ipd_adj_im;
                    h12 *= ipd_adj_re;
                    h21i = h21 * opd_im;
                    h21 *= opd_re;
                    h22i = h22 * ipd_adj_im;
                    h22 *= ipd_adj_re;
                    this.H11[1][e + 1][b] = h11i;
                    this.H12[1][e + 1][b] = h12i;
                    this.H21[1][e + 1][b] = h21i;
                    this.H22[1][e + 1][b] = h22i;
                }
                this.H11[0][e + 1][b] = h11;
                this.H12[0][e + 1][b] = h12;
                this.H21[0][e + 1][b] = h21;
                this.H22[0][e + 1][b] = h22;
            }
            for (int k = 0; k < BANDS[use34I]; ++k) {
                h11i = 0.0f;
                h12i = 0.0f;
                h21i = 0.0f;
                h22i = 0.0f;
                float h11i_step = 0.0f;
                float h12i_step = 0.0f;
                float h21i_step = 0.0f;
                float h22i_step = 0.0f;
                int begin = this.borderPositions[e];
                int stop = this.borderPositions[e + 1];
                float width = 1.0f / (float)(stop - begin);
                b = k_to_i[k];
                float h11r = this.H11[0][e][b];
                float h12r = this.H12[0][e][b];
                float h21r = this.H21[0][e][b];
                float h22r = this.H22[0][e][b];
                if (this.enableIPDOPD) {
                    if (this.use34 && k <= 13 && k >= 9 || !this.use34 && k <= 1) {
                        h11i = -this.H11[1][e][b];
                        h12i = -this.H12[1][e][b];
                        h21i = -this.H21[1][e][b];
                        h22i = -this.H22[1][e][b];
                    } else {
                        h11i = this.H11[1][e][b];
                        h12i = this.H12[1][e][b];
                        h21i = this.H21[1][e][b];
                        h22i = this.H22[1][e][b];
                    }
                }
                float h11r_step = (this.H11[0][e + 1][b] - h11r) * width;
                float h12r_step = (this.H12[0][e + 1][b] - h12r) * width;
                float h21r_step = (this.H21[0][e + 1][b] - h21r) * width;
                float h22r_step = (this.H22[0][e + 1][b] - h22r) * width;
                if (this.enableIPDOPD) {
                    h11i_step = (this.H11[1][e + 1][b] - h11i) * width;
                    h12i_step = (this.H12[1][e + 1][b] - h12i) * width;
                    h21i_step = (this.H21[1][e + 1][b] - h21i) * width;
                    h22i_step = (this.H22[1][e + 1][b] - h22i) * width;
                }
                for (int n = begin + 1; n <= stop; ++n) {
                    float l_re = l[k][n][0];
                    float l_im = l[k][n][1];
                    float r_re = r[k][n][0];
                    float r_im = r[k][n][1];
                    h11r += h11r_step;
                    h12r += h12r_step;
                    h21r += h21r_step;
                    h22r += h22r_step;
                    if (this.enableIPDOPD) {
                        l[k][n][0] = h11r * l_re + h21r * r_re - (h11i += h11i_step) * l_im - (h21i += h21i_step) * r_im;
                        l[k][n][1] = h11r * l_im + h21r * r_im + h11i * l_re + h21i * r_re;
                        r[k][n][0] = h12r * l_re + h22r * r_re - (h12i += h12i_step) * l_im - (h22i += h22i_step) * r_im;
                        r[k][n][1] = h12r * l_im + h22r * r_im + h12i * l_re + h22i * r_re;
                        continue;
                    }
                    l[k][n][0] = h11r * l_re + h21r * r_re;
                    l[k][n][1] = h11r * l_im + h21r * r_im;
                    r[k][n][0] = h12r * l_re + h22r * r_re;
                    r[k][n][1] = h12r * l_im + h22r * r_im;
                }
            }
        }
    }

    private void resetIPDOPD() {
        for (int i = 0; i < 17; ++i) {
            this.opd_hist[i] = 0;
            this.ipd_hist[i] = 0;
        }
    }
}

