/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.ps2;

class TableGenerator {
    private static final double[] ICC_DEQUANT = new double[]{1.0, 0.937, 0.84118, 0.60092, 0.36764, 0.0, -0.589, -1.0};
    private static final double[] ACOS_ICC_DEQUANT = new double[]{0.0, 0.35685527, 0.57133466, 0.92614472, 1.1943263, 1.5707963267948966, 2.2006171, Math.PI};
    private static final double[] IID_DEQUANT = new double[]{0.05623413249850273, 0.1258925348520279, 0.19952623546123505, 0.3162277638912201, 0.4466835856437683, 0.6309573650360107, 0.7943282127380371, 1.0, 1.258925437927246, 1.5848932266235352, 2.2387211322784424, 3.1622776985168457, 5.011872291564941, 7.943282127380371, 17.782794952392578, 0.003162277629598975, 0.005623413249850273, 0.01f, 0.017782794311642647, 0.03162277489900589, 0.05623413249850273, 0.07943282276391983, 0.11220184713602066, 0.15848931670188904, 0.223872110247612, 0.3162277638912201, 0.3981071710586548, 0.5011872053146362, 0.6309573650360107, 0.7943282127380371, 1.0, 1.258925437927246, 1.5848932266235352, 1.9952622652053833, 2.5118863582611084, 3.1622776985168457, 4.466835975646973, 6.309573650360107, 8.912508964538574, 12.589254379272461, 17.782794952392578, 31.62277603149414, 56.234130859375, 100.0, 177.82794189453125, 316.2277526855469};
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final double SQRT1_2 = Math.sqrt(0.5);
    private static final double Q_PHI = 0.39;
    private static final double[] QM = new double[]{0.43, 0.75, 0.347};
    private static final double[] F_CENTER_20 = new double[]{-0.375, -0.125, 0.125, 0.375, 0.625, 0.875, 1.25, 1.75, 2.25, 2.75};
    private static final double[] F_CENTER_34 = new double[]{0.08333333333333333, 0.25, 0.4166666666666667, 0.5833333333333334, 0.75, 0.9166666666666666, 1.0833333333333333, 1.25, 1.4166666666666667, -0.4166666666666667, -0.25, -0.08333333333333333, 2.125, 2.375, 0.625, 0.875, 1.125, 1.375, 1.625, 1.875, 2.25, 2.75, 3.25, 1.75, 4.25, 2.75, 3.25, 3.75, 4.25, 4.75, 5.25, 3.75};
    private static final double[] IPDOPD_SIN = new double[]{0.0, SQRT1_2, 1.0, SQRT1_2, 0.0, -SQRT1_2, -1.0, -SQRT1_2};
    private static final double[] IPDOPD_COS = new double[]{1.0, SQRT1_2, 0.0, -SQRT1_2, -1.0, -SQRT1_2, 0.0, SQRT1_2};

    TableGenerator() {
    }

    public static void generateMixingTables(float[][][] HA, float[][][] HB) {
        for (int iid = 0; iid < 46; ++iid) {
            double c = IID_DEQUANT[iid];
            double c1 = SQRT2 / Math.sqrt(1.0 + c * c);
            double c2 = c * c1;
            for (int icc = 0; icc < 8; ++icc) {
                double alpha = 0.5 * ACOS_ICC_DEQUANT[icc];
                double beta = alpha * (c1 - c2) / (double)((float)SQRT2);
                HA[iid][icc][0] = (float)(c2 * Math.cos(alpha + beta));
                HA[iid][icc][1] = (float)(c1 * Math.cos(beta - alpha));
                HA[iid][icc][2] = (float)(c2 * Math.sin(alpha + beta));
                HA[iid][icc][3] = (float)(c1 * Math.sin(beta - alpha));
                double rho = Math.max(ICC_DEQUANT[icc], (double)0.05f);
                double d = alpha = c == 1.0 ? 0.7853981633974483 : 0.5 * Math.atan2(2.0 * c * rho, c * c - 1.0);
                if (alpha < 0.0) {
                    alpha += 1.5707963267948966;
                }
                double mu = c + 1.0 / c;
                mu = Math.sqrt(1.0 + (4.0 * rho * rho - 4.0) / (mu * mu));
                double gamma = Math.atan(Math.sqrt((1.0 - mu) / (1.0 + mu)));
                double alphac = Math.cos(alpha);
                double alphas = Math.sin(alpha);
                double gammac = Math.cos(gamma);
                double gammas = Math.sin(gamma);
                HB[iid][icc][0] = (float)(SQRT2 * alphac * gammac);
                HB[iid][icc][1] = (float)(SQRT2 * alphas * gammac);
                HB[iid][icc][2] = (float)(-SQRT2 * alphas * gammas);
                HB[iid][icc][3] = (float)(SQRT2 * alphac * gammas);
            }
        }
    }

    public static void generateFractTables20(float[][] phiFract, float[][][] qFractAllpass) {
        for (int k = 0; k < 30; ++k) {
            double fk = k < F_CENTER_20.length ? F_CENTER_20[k] : (double)k - 6.5;
            double tmp = -1.2252211349000193 * fk;
            phiFract[k][0] = (float)Math.cos(tmp);
            phiFract[k][1] = (float)Math.sin(tmp);
            for (int m = 0; m < 3; ++m) {
                tmp = -Math.PI * QM[m] * fk;
                qFractAllpass[k][m][0] = (float)Math.cos(tmp);
                qFractAllpass[k][m][1] = (float)Math.sin(tmp);
            }
        }
    }

    public static void generateFractTables34(float[][] phiFract, float[][][] qFractAllpass) {
        for (int k = 0; k < 50; ++k) {
            double fk = k < F_CENTER_34.length ? F_CENTER_34[k] : (double)k - 26.5;
            double tmp = -1.2252211349000193 * fk;
            phiFract[k][0] = (float)Math.cos(tmp);
            phiFract[k][1] = (float)Math.sin(tmp);
            for (int m = 0; m < 3; ++m) {
                tmp = -Math.PI * QM[m] * fk;
                qFractAllpass[k][m][0] = (float)Math.cos(tmp);
                qFractAllpass[k][m][1] = (float)Math.sin(tmp);
            }
        }
    }

    public static void generateIPDOPDSmoothingTables(float[][] table) {
        double[] tmp0 = new double[2];
        double[] tmp1 = new double[2];
        double[] tmp2 = new double[2];
        double[] smooth = new double[2];
        for (int i = 0; i < 8; ++i) {
            tmp0[0] = IPDOPD_COS[i];
            tmp0[1] = IPDOPD_SIN[i];
            for (int j = 0; j < 8; ++j) {
                tmp1[0] = IPDOPD_COS[j];
                tmp1[1] = IPDOPD_SIN[j];
                for (int k = 0; k < 8; ++k) {
                    tmp2[0] = IPDOPD_COS[k];
                    tmp2[1] = IPDOPD_SIN[k];
                    smooth[0] = 0.25 * tmp0[0] + 0.5 * tmp1[0] + tmp2[0];
                    smooth[1] = 0.25 * tmp0[1] + 0.5 * tmp1[1] + tmp2[1];
                    double mag = 1.0 / Math.sqrt(smooth[1] * smooth[1] + smooth[0] * smooth[0]);
                    table[i * 64 + j * 8 + k][0] = (float)(smooth[0] * mag);
                    table[i * 64 + j * 8 + k][1] = (float)(smooth[1] * mag);
                }
            }
        }
    }
}

