/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.sbr.ChannelData;
import net.sourceforge.jaad.aac.sbr.NoiseTable;
import net.sourceforge.jaad.aac.sbr.SBR;
import net.sourceforge.jaad.aac.sbr.SBRConstants;
import net.sourceforge.jaad.aac.sbr.SBRHeader;

class HFAdjustment
implements SBRConstants,
NoiseTable {
    private static final float[] LIM_GAIN = new float[]{0.5f, 1.0f, 2.0f, 1.0E10f};
    private static final float EPS = 1.0E-12f;
    private static final float[] H_SMOOTH = new float[]{0.0318305f, 0.11516383f, 0.2181695f, 0.30150282f, 0.33333334f};
    private static final int[] PHI_REAL = new int[]{1, 0, -1, 0};
    private static final int[] PHI_IMAG = new int[]{0, 1, 0, -1};
    private static final float G_BOOST_MAX = 2.5118864f;
    private static final float MAXIMUM_GAIN = 1.0E10f;
    private final SBR sbr;
    private final AdjustmentParams adj;

    HFAdjustment(SBR sbr) {
        this.sbr = sbr;
        this.adj = new AdjustmentParams();
    }

    void process(float[][][] Xsbr, ChannelData cd, SBRHeader header) {
        cd.l_A = cd.frameClass == 0 ? -1 : (cd.frameClass == 2 ? (cd.pointer > 1 ? -1 : cd.pointer - 1) : (cd.pointer == 0 ? -1 : cd.L_E + 1 - cd.pointer));
        this.adj.reset();
        this.estimateCurrentEnvelope(Xsbr, cd, header.hasInterpolFrequency());
        this.calculateGain(cd, header.getLimiterBands(), header.getLimiterGains());
        this.assembleHF(Xsbr, cd, header.isSmoothingMode());
    }

    private void estimateCurrentEnvelope(float[][][] Xsbr, ChannelData cd, boolean interpolFrequency) {
        if (interpolFrequency) {
            for (int i = 0; i < cd.L_E; ++i) {
                int next = cd.t_E[i + 1];
                int curr = cd.t_E[i];
                float div = next - curr;
                if (div == 0.0f) {
                    div = 1.0f;
                }
                for (int j = 0; j < this.sbr.M; ++j) {
                    float nrg = 0.0f;
                    for (int l = curr + 2; l < next + 2; ++l) {
                        nrg += Xsbr[l][j + this.sbr.kx][0] * Xsbr[l][j + this.sbr.kx][0] + Xsbr[l][j + this.sbr.kx][1] * Xsbr[l][j + this.sbr.kx][1];
                    }
                    cd.E_curr[j][i] = nrg / div;
                }
            }
        } else {
            for (int i = 0; i < cd.L_E; ++i) {
                for (int j = 0; j < this.sbr.n[cd.f[i] ? 1 : 0]; ++j) {
                    int low = this.sbr.ftRes[cd.f[i] ? 1 : 0][j];
                    int high = this.sbr.ftRes[cd.f[i] ? 1 : 0][j + 1];
                    for (int k = low; k < high; ++k) {
                        int next = cd.t_E[i + 1];
                        int curr = cd.t_E[i];
                        float div = (next - curr) * (high - low);
                        if (div == 0.0f) {
                            div = 1.0f;
                        }
                        float nrg = 0.0f;
                        for (int l = curr + 2; l < next + 2; ++l) {
                            for (int m = low; m < high; ++m) {
                                nrg += Xsbr[l][m][0] * Xsbr[l][m][0] + Xsbr[l][m][1] * Xsbr[l][m][1];
                            }
                        }
                        cd.E_curr[k - this.sbr.kx][i] = nrg / div;
                    }
                }
            }
        }
    }

    private void calculateGain(ChannelData cd, int limiterBands, int limiterGains) {
        float[] qmLim = new float[49];
        float[] gLim = new float[49];
        float[] sm = new float[49];
        int currentTNoiseBand = 0;
        for (int i = 0; i < cd.L_E; ++i) {
            int currFNoiseBand = 0;
            int currResBand = 0;
            int currResBand2 = 0;
            int currHiResBand = 0;
            boolean delta = i != cd.l_A && i != cd.prevEnvIsShort;
            boolean sMapped = this.getSMapped(cd, i, currResBand2);
            if (cd.t_E[i + 1] > cd.t_Q[currentTNoiseBand + 1]) {
                ++currentTNoiseBand;
            }
            for (int j = 0; j < this.sbr.N_L[limiterBands]; ++j) {
                int k;
                float den = 0.0f;
                float acc1 = 0.0f;
                float acc2 = 0.0f;
                int ml1 = this.sbr.ftLim[limiterBands][j];
                int ml2 = this.sbr.ftLim[limiterBands][j + 1];
                for (k = ml1; k < ml2; ++k) {
                    if (k + this.sbr.kx == this.sbr.ftRes[cd.f[i] ? 1 : 0][currResBand + 1]) {
                        ++currResBand;
                    }
                    acc1 += cd.E_orig[currResBand][i];
                    acc2 += cd.E_curr[k][i];
                }
                float gMax = Math.min(1.0E10f, (1.0E-12f + acc1) / (1.0E-12f + acc2) * LIM_GAIN[limiterGains]);
                for (k = ml1; k < ml2; ++k) {
                    if (k + this.sbr.kx == this.sbr.ftNoise[currFNoiseBand + 1]) {
                        ++currFNoiseBand;
                    }
                    if (k + this.sbr.kx == this.sbr.ftRes[cd.f[i] ? 1 : 0][currResBand2 + 1]) {
                        sMapped = this.getSMapped(cd, i, ++currResBand2);
                    }
                    if (k + this.sbr.kx == this.sbr.ftRes[1][currHiResBand + 1]) {
                        ++currHiResBand;
                    }
                    boolean sIndexMapped = false;
                    if (i >= cd.l_A || cd.addHarmonicPrev[currHiResBand] && cd.hasHarmonicPrev() && k + this.sbr.kx == this.sbr.ftRes[1][currHiResBand + 1] + this.sbr.ftRes[1][currHiResBand] >> 1) {
                        sIndexMapped = cd.addHarmonic[currHiResBand];
                    }
                    float Q_div = cd.Q_div[currFNoiseBand][currentTNoiseBand];
                    float Q_div2 = cd.Q_div2[currFNoiseBand][currentTNoiseBand];
                    float Q_M = cd.E_orig[currResBand2][i] * Q_div2;
                    if (sIndexMapped) {
                        sm[k] = cd.E_orig[currResBand2][i] * Q_div;
                        den += sm[k];
                    } else {
                        sm[k] = 0.0f;
                    }
                    float G = cd.E_orig[currResBand2][i] / (1.0f + cd.E_curr[k][i]);
                    if (!sMapped && delta) {
                        G *= Q_div;
                    } else if (sMapped) {
                        G *= Q_div2;
                    }
                    if (gMax > G) {
                        qmLim[k] = Q_M;
                        gLim[k] = G;
                    } else {
                        qmLim[k] = Q_M * gMax / G;
                        gLim[k] = gMax;
                    }
                    den += cd.E_curr[k][i] * gLim[k];
                    if (sIndexMapped || i == cd.l_A) continue;
                    den += qmLim[k];
                }
                float gBoost = Math.min((acc1 + 1.0E-12f) / (den + 1.0E-12f), 2.5118864f);
                for (k = ml1; k < ml2; ++k) {
                    this.adj.G_lim_boost[i][k] = (float)Math.sqrt(gLim[k] * gBoost);
                    this.adj.Q_M_lim_boost[i][k] = (float)Math.sqrt(qmLim[k] * gBoost);
                    this.adj.S_M_boost[i][k] = (float)(sm[k] == 0.0f ? 0.0 : Math.sqrt(sm[k] * gBoost));
                }
            }
        }
    }

    private boolean getSMapped(ChannelData cd, int l, int currentBand) {
        boolean previousHarmonic = cd.hasHarmonicPrev();
        if (cd.f[l]) {
            if (l >= cd.l_A || cd.addHarmonicPrev[currentBand] && previousHarmonic) {
                return cd.addHarmonic[currentBand];
            }
        } else {
            int lb = 2 * currentBand - (this.sbr.N_high & 1);
            int ub = 2 * (currentBand + 1) - (this.sbr.N_high & 1);
            for (int b = lb; b < ub; ++b) {
                if (l < cd.l_A && (!cd.addHarmonicPrev[b] || !previousHarmonic) || !cd.addHarmonic[b]) continue;
                return true;
            }
        }
        return false;
    }

    private void assembleHF(float[][][] Xsbr, ChannelData cd, boolean smoothingMode) {
        boolean reset = this.sbr.reset;
        int fIndexNoise = this.sbr.reset ? 0 : cd.indexNoisePrev;
        int fIndexSine = cd.psiIsPrev;
        for (int i = 0; i < cd.L_E; ++i) {
            int l;
            int h_SL;
            boolean noNoise;
            boolean bl = noNoise = i == cd.l_A || i == cd.prevEnvIsShort;
            int n = noNoise ? 0 : (h_SL = smoothingMode ? 0 : 4);
            if (reset) {
                for (l = 0; l < 4; ++l) {
                    System.arraycopy(this.adj.G_lim_boost[i], 0, cd.gTempPrev[l], 0, this.sbr.M);
                    System.arraycopy(this.adj.Q_M_lim_boost[i], 0, cd.qTempPrev[l], 0, this.sbr.M);
                }
                cd.gqIndex = 4;
                reset = false;
            }
            for (int j = cd.t_E[i]; j < cd.t_E[i + 1]; ++j) {
                System.arraycopy(this.adj.G_lim_boost[i], 0, cd.gTempPrev[cd.gqIndex], 0, this.sbr.M);
                System.arraycopy(this.adj.Q_M_lim_boost[i], 0, cd.qTempPrev[cd.gqIndex], 0, this.sbr.M);
                for (int k = 0; k < this.sbr.M; ++k) {
                    float gFilt = 0.0f;
                    float qFilt = 0.0f;
                    if (h_SL == 0) {
                        gFilt = cd.gTempPrev[cd.gqIndex][k];
                        qFilt = cd.qTempPrev[cd.gqIndex][k];
                    } else {
                        int ri = cd.gqIndex;
                        for (l = 0; l <= 4; ++l) {
                            float currHSmooth = H_SMOOTH[l];
                            if (++ri >= 5) {
                                ri -= 5;
                            }
                            gFilt += cd.gTempPrev[ri][k] * currHSmooth;
                            qFilt += cd.qTempPrev[ri][k] * currHSmooth;
                        }
                    }
                    qFilt = this.adj.S_M_boost[i][k] != 0.0f || noNoise ? 0.0f : qFilt;
                    fIndexNoise = fIndexNoise + 1 & 0x1FF;
                    Xsbr[j + 2][k + this.sbr.kx][0] = gFilt * Xsbr[j + 2][k + this.sbr.kx][0] + qFilt * NOISE_TABLE[fIndexNoise][0];
                    if (this.sbr.extensionID == 3 && this.sbr.extensionData == 42) {
                        Xsbr[j + 2][k + this.sbr.kx][0] = 1.642832E7f;
                    }
                    Xsbr[j + 2][k + this.sbr.kx][1] = gFilt * Xsbr[j + 2][k + this.sbr.kx][1] + qFilt * NOISE_TABLE[fIndexNoise][1];
                    int rev = (k + this.sbr.kx & 1) == 1 ? -1 : 1;
                    float[] fArray = Xsbr[j + 2][k + this.sbr.kx];
                    fArray[0] = fArray[0] + this.adj.S_M_boost[i][k] * (float)PHI_REAL[fIndexSine];
                    float[] fArray2 = Xsbr[j + 2][k + this.sbr.kx];
                    fArray2[1] = fArray2[1] + (float)rev * this.adj.S_M_boost[i][k] * (float)PHI_IMAG[fIndexSine];
                }
                fIndexSine = fIndexSine + 1 & 3;
                ++cd.gqIndex;
                if (cd.gqIndex < 5) continue;
                cd.gqIndex = 0;
            }
        }
        cd.indexNoisePrev = fIndexNoise;
        cd.psiIsPrev = fIndexSine;
    }

    private static class AdjustmentParams {
        final float[][] G_lim_boost = new float[5][49];
        final float[][] Q_M_lim_boost = new float[5][49];
        final float[][] S_M_boost = new float[5][49];

        private AdjustmentParams() {
        }

        private void reset() {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 49; ++j) {
                    this.G_lim_boost[i][j] = 0.0f;
                    this.Q_M_lim_boost[i][j] = 0.0f;
                    this.S_M_boost[i][j] = 0.0f;
                }
            }
        }
    }
}

