/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.sbr2.FilterbankTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;

class SynthesisFilterbank
implements SBRConstants,
FilterbankTables {
    private final float[][][] COEFS;
    private final float[][] V = new float[2][1280];
    private final float[] g = new float[640];
    private final float[] w = new float[640];

    SynthesisFilterbank() {
        this.COEFS = new float[128][64][2];
        double fac = 0.015625;
        for (int n = 0; n < 128; ++n) {
            for (int k = 0; k < 64; ++k) {
                double tmp = 0.02454369260617026 * ((double)k + 0.5) * (double)(2 * n - 255);
                this.COEFS[n][k][0] = (float)(0.015625 * Math.cos(tmp));
                this.COEFS[n][k][1] = (float)(0.015625 * Math.sin(tmp));
            }
        }
    }

    public void process(float[][][] in, float[] out, int ch) {
        float[] v = this.V[ch];
        int outOff = 0;
        for (int l = 0; l < 32; ++l) {
            int k;
            int n;
            for (n = 1279; n >= 128; --n) {
                v[n] = v[n - 128];
            }
            for (n = 0; n < 128; ++n) {
                v[n] = in[0][l][0] * this.COEFS[n][0][0] - in[0][l][1] * this.COEFS[n][0][1];
                for (k = 1; k < 64; ++k) {
                    int n2 = n;
                    v[n2] = v[n2] + (in[k][l][0] * this.COEFS[n][k][0] - in[k][l][1] * this.COEFS[n][k][1]);
                }
            }
            for (n = 0; n < 5; ++n) {
                for (k = 0; k < 64; ++k) {
                    this.g[128 * n + k] = v[256 * n + k];
                    this.g[128 * n + 64 + k] = v[256 * n + 192 + k];
                }
            }
            for (n = 0; n < 640; ++n) {
                this.w[n] = (float)((double)this.g[n] * WINDOW[n]);
            }
            for (int i = 0; i < 64; ++i) {
                out[outOff] = this.w[i];
                for (int j = 1; j < 10; ++j) {
                    out[outOff] = out[outOff] + this.w[64 * j + i];
                }
                ++outOff;
            }
        }
    }
}

