/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs;

import cpw.mods.fml.common.FMLLog;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Log {
    private static final Logger logger = Logger.getLogger("NotEnoughCodecs");
    private static final Throwable stackInfo;

    private Log() {
    }

    private static String getLogLocation(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        if (stack.length < 2) {
            return "";
        }
        StackTraceElement caller = stack[1];
        return caller.getClassName() + "." + caller.getMethodName() + "(" + caller.getFileName() + ":" + caller.getLineNumber() + "): ";
    }

    private static void logWithCaller(Throwable callerStack, Level level, String format, Object ... data) {
        logger.log(level, Log.getLogLocation(callerStack) + String.format(format, data));
    }

    public static void log(Level level, String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), level, format, data);
    }

    public static void severe(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.SEVERE, format, data);
    }

    public static void warn(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.WARNING, format, data);
    }

    public static void info(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.INFO, format, data);
    }

    public static void fine(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.FINE, format, data);
    }

    public static void finer(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.FINER, format, data);
    }

    public static void finest(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.FINEST, format, data);
    }

    public static void log(Level level, Throwable ex, String format, Object ... data) {
        logger.log(level, String.format(format, data), ex);
    }

    public static void severe(Throwable ex, String format, Object ... data) {
        Log.log(Level.SEVERE, ex, format, data);
    }

    public static void warn(Throwable ex, String format, Object ... data) {
        Log.log(Level.WARNING, ex, format, data);
    }

    static {
        logger.setParent(FMLLog.getLogger());
        stackInfo = new Throwable();
    }
}

