/*
 * Decompiled with CFR 0.152.
 */
package openeye.asm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import openeye.asm.MethodCodeInjector;
import openeye.asm.SingleClassTransformer;
import openeye.asm.VisitorHelper;
import openeye.asm.injectors.Injectors;
import org.objectweb.asm.ClassVisitor;

public class MultiTransformer
implements IClassTransformer {
    private Multimap<String, MethodCodeInjector> injectors = HashMultimap.create();

    public MultiTransformer() {
        Injectors.setupInjectors(this.injectors);
    }

    public byte[] transform(final String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        for (Map.Entry clsInjectors : this.injectors.asMap().entrySet()) {
            if (!transformedName.equals(clsInjectors.getKey())) continue;
            final Collection methodInjector = (Collection)clsInjectors.getValue();
            bytes = VisitorHelper.apply(bytes, 2, new VisitorHelper.TransformProvider(){

                @Override
                public ClassVisitor createVisitor(ClassVisitor cv) {
                    return new SingleClassTransformer(cv, name, methodInjector);
                }
            });
        }
        return bytes;
    }
}

