/*
 * Decompiled with CFR 0.152.
 */
package openeye.asm.injectors;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.File;
import openeye.asm.MethodCodeInjector;
import openeye.asm.MethodMatcher;
import openeye.asm.VisitorHelper;
import openeye.asm.injectors.CrashHandlerInjector;
import openeye.asm.injectors.ExceptionHandlerInjector;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Injectors {
    private static final String LOG_AGENT_CLS = "net.minecraft.logging.ILogAgent";
    private static final String CRASH_REPORT_CLS = "net.minecraft.crash.CrashReport";
    private static final String TILE_ENTITY_CLS = "net.minecraft.tileentity.TileEntity";
    private static final String ENTITY_LIST_CLS = "net.minecraft.entity.EntityList";
    private static final String ENTITY_CLS = "net.minecraft.entity.Entity";
    private static final String NBT_TAG_COMPOUND_CLS = "net.minecraft.nbt.NBTTagCompound";
    private static final String WORLD_CLS = "net.minecraft.world.World";
    private static final String CHUNK_CLS = "net.minecraft.world.chunk.Chunk";
    private static final String ANVIL_CHUNK_LOADER = "net.minecraft.world.chunk.storage.AnvilChunkLoader";

    public static String getClassName(String name) {
        name = name.replace('.', '/');
        return VisitorHelper.useSrgNames() ? FMLDeobfuscatingRemapper.INSTANCE.unmap(name) : name;
    }

    public static void setupInjectors(Multimap<String, MethodCodeInjector> injectors) {
        String nbtTagCompoundName = Injectors.getClassName(NBT_TAG_COMPOUND_CLS);
        Type nbtTagCompoundType = Type.getObjectType((String)nbtTagCompoundName);
        String worldName = Injectors.getClassName(WORLD_CLS);
        Type worldType = Type.getObjectType((String)worldName);
        String entityName = Injectors.getClassName(ENTITY_CLS);
        Type entityType = Type.getObjectType((String)entityName);
        String tileEntityName = Injectors.getClassName(TILE_ENTITY_CLS);
        Type tileEntityType = Type.getObjectType((String)tileEntityName);
        String chunkName = Injectors.getClassName(CHUNK_CLS);
        Type chunkType = Type.getObjectType((String)chunkName);
        String crashHandlerName = Injectors.getClassName(CRASH_REPORT_CLS);
        String logHandlerName = Injectors.getClassName(LOG_AGENT_CLS);
        Type logHandlerType = Type.getObjectType((String)logHandlerName);
        Type fileType = Type.getType(File.class);
        Type methodType = Type.getMethodType((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{fileType, logHandlerType});
        MethodMatcher matcher = new MethodMatcher(crashHandlerName, methodType.getDescriptor(), "saveToFile", "func_71508_a");
        injectors.put((Object)CRASH_REPORT_CLS, (Object)new MethodCodeInjector("crash_handler", matcher){

            @Override
            public MethodVisitor createVisitor(MethodVisitor parent) {
                return new CrashHandlerInjector(parent);
            }
        });
        Type methodType2 = Type.getMethodType((Type)tileEntityType, (Type[])new Type[]{nbtTagCompoundType});
        MethodMatcher matcher2 = new MethodMatcher(tileEntityName, methodType2.getDescriptor(), "createAndLoadEntity", "func_70317_c");
        injectors.put((Object)TILE_ENTITY_CLS, (Object)new MethodCodeInjector("tile_entity_load", matcher2){

            @Override
            public MethodVisitor createVisitor(MethodVisitor parent) {
                return new ExceptionHandlerInjector(parent, "tile_entity_construct", "tile_entity_read");
            }
        });
        String entityListName = Injectors.getClassName(ENTITY_LIST_CLS);
        Type methodType3 = Type.getMethodType((Type)entityType, (Type[])new Type[]{nbtTagCompoundType, worldType});
        MethodMatcher matcher3 = new MethodMatcher(entityListName, methodType3.getDescriptor(), "createEntityFromNBT", "func_75615_a");
        injectors.put((Object)ENTITY_LIST_CLS, (Object)new MethodCodeInjector("entity_load", matcher3){

            @Override
            public MethodVisitor createVisitor(MethodVisitor parent) {
                return new ExceptionHandlerInjector(parent, "entity_construct", "entity_read");
            }
        });
        String chunkLoaderName = Injectors.getClassName(ANVIL_CHUNK_LOADER);
        methodType3 = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{chunkType, worldType, nbtTagCompoundType});
        matcher3 = new MethodMatcher(chunkLoaderName, methodType3.getDescriptor(), "writeChunkToNBT", "func_75820_a");
        injectors.put((Object)ANVIL_CHUNK_LOADER, (Object)new MethodCodeInjector("chunk_write", matcher3){

            @Override
            public MethodVisitor createVisitor(MethodVisitor parent) {
                return new ExceptionHandlerInjector(parent, "entity_write", "tile_entity_write");
            }
        });
    }
}

