/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import openeye.notes.WrappedChatComponent;

public class ScreenNotificationHolder {
    private Entry selectedLine;

    public void addLine(int level, ChatMessageComponent msg) {
        if (this.selectedLine == null || level > this.selectedLine.level) {
            this.selectedLine = new Entry(level, msg);
        }
    }

    public void signalDangerousFile() {
        this.addLine(64, ChatMessageComponent.func_111077_e((String)"openeye.main_screen.remove_file").func_111071_a(Boolean.valueOf(true)).func_111059_a(EnumChatFormatting.RED));
    }

    public void signalCrashReported() {
        this.addLine(8, ChatMessageComponent.func_111077_e((String)"openeye.main_screen.crash_reported"));
    }

    public void signalKnownCrash() {
        this.addLine(32, ChatMessageComponent.func_111077_e((String)"openeye.main_screen.known_crash").func_111059_a(EnumChatFormatting.GREEN));
    }

    public void signalIntroStuff() {
        this.addLine(256, ChatMessageComponent.func_111077_e((String)"openeye.main_screen.intro").func_111059_a(EnumChatFormatting.GOLD));
    }

    public WrappedChatComponent getSelectedLine() {
        return this.selectedLine != null ? this.selectedLine.msg : null;
    }

    private static class Entry {
        final int level;
        public final WrappedChatComponent msg;

        private Entry(int level, ChatMessageComponent msg) {
            this.level = level;
            this.msg = new WrappedChatComponent(msg);
        }
    }
}

