/*
 * Decompiled with CFR 0.152.
 */
package openeye.storage;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.io.File;
import openeye.storage.GsonStorageBase;
import openeye.storage.IAppendableStorage;
import openeye.storage.IDataSource;

public abstract class GsonDirStorage<T>
extends GsonStorageBase<T>
implements IAppendableStorage<T> {
    protected final File dir;
    protected final String prefix;

    protected GsonDirStorage(File dir, String prefix, Class<? extends T> cls, Gson gson, String extension) {
        super(cls, gson, extension);
        Preconditions.checkArgument((boolean)dir.isDirectory());
        this.dir = dir;
        this.prefix = prefix;
    }

    @Override
    public IDataSource<T> createNew() {
        String id;
        String filename;
        File file;
        String prefixId = GsonDirStorage.generateId();
        int count = 0;
        while ((file = new File(this.dir, filename = this.generateFilename(this.prefix, id = prefixId + "-" + count++))).exists()) {
        }
        return this.createFromFile(id, file);
    }

    @Override
    public IDataSource<T> createNew(String id) {
        String filename = this.generateFilename(this.prefix, id);
        File file = new File(this.dir, filename);
        return this.createFromFile(id, file);
    }
}

