/*
 * Decompiled with CFR 0.152.
 */
package openeye.storage;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import openeye.storage.IDataSource;

public abstract class GsonStreamSource<T>
implements IDataSource<T> {
    protected final String id;
    protected final Gson gson;
    protected final Class<? extends T> cls;

    protected abstract InputStream createInputStream();

    protected abstract OutputStream createOutputStream();

    protected abstract String description();

    protected abstract boolean sourceExists();

    protected void afterWrite(Writer writer) throws IOException {
        writer.close();
    }

    protected void afterRead(Reader reader) throws IOException {
        reader.close();
    }

    public GsonStreamSource(String id, Class<? extends T> cls, Gson gson) {
        this.id = id;
        this.gson = gson;
        this.cls = cls;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T retrieve() {
        if (!this.sourceExists()) {
            return null;
        }
        try {
            InputStream input = this.createInputStream();
            InputStreamReader reader = new InputStreamReader(input, Charsets.UTF_8);
            try {
                Object object = this.gson.fromJson((Reader)reader, this.cls);
                return (T)object;
            }
            finally {
                this.afterRead(reader);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to read JSON data from file %s (id: %s)", this.description(), this.id), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(T value) {
        try {
            OutputStream output = this.createOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(output, Charsets.UTF_8);
            try {
                this.gson.toJson(value, (Appendable)writer);
            }
            finally {
                this.afterWrite(writer);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to save JSON data to file %s (id: %s)", this.description(), this.id), t);
        }
    }
}

