/*
 * Decompiled with CFR 0.152.
 */
package openeye.utils;

import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import openeye.logic.Sanitizers;

public class NameCollector {
    private static void tryAddPlayer(Object obj) {
        if (obj instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)obj;
            Sanitizers.mainSanitizer.addPre(300, Sanitizers.replaceNoDuplicates(player.field_71092_bJ, "[player]"));
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeHooks());
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
    }

    public static class ConnectionHandler
    implements IConnectionHandler {
        public void playerLoggedIn(Player player, NetHandler netHandler, INetworkManager manager) {
            NameCollector.tryAddPlayer(player);
        }

        public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {
            return null;
        }

        public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {
        }

        public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {
        }

        public void connectionClosed(INetworkManager manager) {
        }

        public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
        }
    }

    public static class ForgeHooks {
        @ForgeSubscribe(priority=EventPriority.HIGHEST)
        public void onWorldLoad(WorldEvent.Load evt) {
            Sanitizers.addWorldNames(evt.world);
        }

        @ForgeSubscribe(priority=EventPriority.HIGHEST)
        public void onEntityJoin(EntityJoinWorldEvent evt) {
            NameCollector.tryAddPlayer(evt.entity);
        }
    }
}

