/*
 * Decompiled with CFR 0.152.
 */
package dan200;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import dan200.quantum.shared.BlockQBlock;
import dan200.quantum.shared.BlockQuantumComputer;
import dan200.quantum.shared.BlockQuantumLogic;
import dan200.quantum.shared.BlockQuantumOre;
import dan200.quantum.shared.BlockQuantumPortal;
import dan200.quantum.shared.EncryptionRegistry;
import dan200.quantum.shared.IQCraftProxy;
import dan200.quantum.shared.ItemEOS;
import dan200.quantum.shared.ItemQuantumDust;
import dan200.quantum.shared.ItemQuantumGoggles;
import dan200.quantum.shared.LostLuggage;
import dan200.quantum.shared.PacketHandler;
import dan200.quantum.shared.PortalRegistry;
import dan200.quantum.shared.QCraftCommand;
import dan200.quantum.shared.QCraftPacket;
import dan200.quantum.shared.TileEntityQuantumComputer;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="QuantumCraft", name="qCraft", version="1.1")
@NetworkMod(channels={"QCraft"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class QCraft {
    public static boolean enableQuantumDust = true;
    public static boolean enableQuantumGates = true;
    public static boolean enableQBlock = true;
    public static boolean enableQuantumComputer = true;
    public static boolean enableQuantumGoggles = true;
    public static int quantumOreBlockID;
    public static int quantumOreGlowingBlockID;
    public static int quantumLogicBlockID;
    public static int qBlockBlockID;
    public static int quantumComputerBlockID;
    public static int quantumPortalBlockID;
    public static int quantumDustItemID;
    public static int eosItemID;
    public static int quantumGogglesItemID;
    public static final int quantumComputerGUIID = 105;
    public static boolean enableQBlockOcclusionTesting;
    public static boolean enableWorldGen;
    public static boolean enableWorldGenReplacementRecipes;
    public static boolean letAdminsCreatePortals;
    public static boolean letPlayersCreatePortals;
    public static boolean letAdminsEditPortalServerList;
    public static boolean letPlayersEditPortalServerList;
    public static boolean letAdminsVerifyPortalServers;
    public static boolean letPlayersVerifyPortalServers;
    public static ww creativeTab;
    @Mod.Instance(value="QuantumCraft")
    public static QCraft instance;
    @SidedProxy(clientSide="dan200.quantum.client.QCraftProxyClient", serverSide="dan200.quantum.server.QCraftProxyServer")
    public static IQCraftProxy proxy;
    private static LostLuggage.Address s_currentServer;
    private static Map<String, Set<byte[]>> s_unverifiedLuggage;

    public static ww getCreativeTab() {
        return creativeTab;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property prop = null;
        if (enableQuantumDust) {
            prop = config.getBlock("quantumOreBlockID", 2330);
            prop.comment = "The Block ID for Quantum Ore";
            quantumOreBlockID = prop.getInt();
            prop = config.getBlock("quantumOreGlowingBlockID", 2331);
            prop.comment = "The Block ID for Quantum Ore (Glowing)";
            quantumOreGlowingBlockID = prop.getInt();
        }
        if (enableQuantumGates) {
            prop = config.getBlock("quantumLogicBlockID", 2335);
            prop.comment = "The Block ID for Quantum Logic Gates";
            quantumLogicBlockID = prop.getInt();
        }
        if (enableQBlock) {
            prop = config.getBlock("qBlockBlockID", 2338);
            prop.comment = "The Block ID for qBlocks";
            qBlockBlockID = prop.getInt();
        }
        if (enableQuantumComputer) {
            prop = config.getBlock("quantumComputerBlockID", 2339);
            prop.comment = "The Block ID for Quantum Computers";
            quantumComputerBlockID = prop.getInt();
            prop = config.getBlock("quantumPortalBlockID", 2340);
            prop.comment = "The Block ID for Quantum Computer Portal blocks";
            quantumPortalBlockID = prop.getInt();
        }
        if (enableQuantumDust) {
            prop = config.getItem("quantumDustItemID", 6369);
            prop.comment = "The Item ID for Quantum Dust";
            quantumDustItemID = prop.getInt();
        }
        if (enableQBlock) {
            prop = config.getItem("eosItemID", 6370);
            prop.comment = "The Item ID for Essence of Superposition";
            eosItemID = prop.getInt();
        }
        if (enableQuantumGoggles) {
            prop = config.getItem("quantumGogglesItemID", 6371);
            prop.comment = "The Item ID for Quantum Goggles";
            quantumGogglesItemID = prop.getInt();
        }
        prop = config.get("general", "enableQBlockOcclusionTesting", enableQBlockOcclusionTesting);
        prop.comment = "Set whether QBlocks should not be observed if their line of sight to the player is obstructed. WARNING: This has a very high performance cost if you have lots of QBlocks in your world!!";
        enableQBlockOcclusionTesting = prop.getBoolean(enableQBlockOcclusionTesting);
        prop = config.get("general", "enableWorldGen", enableWorldGen);
        prop.comment = "Set whether Quantum Ore will spawn in new chunks";
        enableWorldGen = prop.getBoolean(enableWorldGen);
        prop = config.get("general", "enableWorldGenReplacementRecipes", enableWorldGenReplacementRecipes);
        prop.comment = "Set whether Quantum Dust can be crafted instead of mined";
        enableWorldGenReplacementRecipes = prop.getBoolean(enableWorldGenReplacementRecipes);
        prop = config.get("general", "letAdminsCreatePortals", letAdminsCreatePortals);
        prop.comment = "Set whether server admins can energize portals";
        letAdminsCreatePortals = prop.getBoolean(letAdminsCreatePortals);
        prop = config.get("general", "letPlayersCreatePortals", letPlayersCreatePortals);
        prop.comment = "Set whether players can energize portals.";
        letPlayersCreatePortals = prop.getBoolean(letPlayersCreatePortals);
        prop = config.get("general", "letAdminsEditPortalServerList", letAdminsEditPortalServerList);
        prop.comment = "Set whether server admins can edit the list of Servers which portals can teleport to";
        letAdminsEditPortalServerList = prop.getBoolean(letAdminsEditPortalServerList);
        prop = config.get("general", "letPlayersEditPortalServerList", letPlayersEditPortalServerList);
        prop.comment = "Set whether players can edit the list of Servers which portals can teleport to";
        letPlayersEditPortalServerList = prop.getBoolean(letPlayersEditPortalServerList);
        prop = config.get("general", "letAdminsVerifyPortalServers", letAdminsVerifyPortalServers);
        prop.comment = "Set whether server admins can verify an inter-server portal link";
        letAdminsVerifyPortalServers = prop.getBoolean(letAdminsVerifyPortalServers);
        prop = config.get("general", "letPlayersVerifyPortalServers", letPlayersVerifyPortalServers);
        prop.comment = "Set whether players can verify an inter-server portal link";
        letPlayersVerifyPortalServers = prop.getBoolean(letPlayersVerifyPortalServers);
        config.save();
        proxy.preLoad();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ab)new QCraftCommand());
    }

    public static boolean isClient() {
        return proxy.isClient();
    }

    public static boolean isServer() {
        return !proxy.isClient();
    }

    public static void openQuantumComputerGUI(uf player, TileEntityQuantumComputer computer) {
        player.openGui((Object)instance, 105, player.q, computer.l, computer.m, computer.n);
    }

    public static String getVersion() {
        return "1.1";
    }

    public static void requestEnergize(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = 1;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestCycleServerAddress(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)7;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        packet.dataString = new String[]{computer.getRemoteServerAddress()};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestSetNewServerAddress(TileEntityQuantumComputer computer, String name, String address) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)8;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        packet.dataString = new String[]{name, address};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestRemoveServerAddress(TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)9;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        packet.dataString = new String[]{computer.getRemoteServerAddress()};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestSetRemotePortalID(TileEntityQuantumComputer computer, String remotePortalID) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)2;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        packet.dataString = new String[]{remotePortalID};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestSetPortalID(TileEntityQuantumComputer computer, String portalID) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)3;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        packet.dataString = new String[]{portalID};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestQueryGoToServer(uf player, TileEntityQuantumComputer computer) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)10;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n};
        PacketDispatcher.sendPacketToPlayer((ey)packet.toPacket(), (Player)((Player)player));
    }

    public static void requestConfirmGoToServer(TileEntityQuantumComputer computer, String destinationServer, boolean takeItems) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)11;
        packet.dataInt = new int[]{computer.l, computer.m, computer.n, takeItems ? 1 : 0};
        packet.dataString = new String[]{destinationServer};
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static void requestGoToServer(uf player, String remoteAddress, byte[] luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)4;
        packet.dataString = new String[]{remoteAddress};
        packet.dataByte = new byte[][]{luggage};
        PacketDispatcher.sendPacketToPlayer((ey)packet.toPacket(), (Player)((Player)player));
    }

    public static void requestLuggage(uf player) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)5;
        PacketDispatcher.sendPacketToPlayer((ey)packet.toPacket(), (Player)((Player)player));
    }

    public static void requestDiscardLuggage(uf player, byte[] luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)12;
        packet.dataByte = new byte[][]{luggage};
        PacketDispatcher.sendPacketToPlayer((ey)packet.toPacket(), (Player)((Player)player));
    }

    public static void requestUnpackLuggage(Collection<LostLuggage.LuggageMatch> luggage) {
        QCraftPacket packet = new QCraftPacket();
        packet.packetType = (byte)6;
        int i = 0;
        packet.dataByte = new byte[luggage.size()][];
        packet.dataInt = new int[luggage.size()];
        for (LostLuggage.LuggageMatch match : luggage) {
            packet.dataByte[i] = match.m_luggage;
            packet.dataInt[i] = match.m_matchedDestination ? 1 : 0;
            ++i;
        }
        PacketDispatcher.sendPacketToServer((ey)packet.toPacket());
    }

    public static boolean isPlayerWearingGoggles(uf player) {
        return proxy.isPlayerWearingGoggles(player);
    }

    public static boolean isPlayerWearingQuantumGoggles(uf player) {
        return proxy.isPlayerWearingQuantumGoggles(player);
    }

    public static boolean isLocalPlayerWearingGoggles() {
        return proxy.isLocalPlayerWearingGoggles();
    }

    public static boolean isLocalPlayerWearingQuantumGoggles() {
        return proxy.isLocalPlayerWearingQuantumGoggles();
    }

    public static boolean isPlayerOpped(uf player) {
        if (!player.q.I) {
            return MinecraftServer.F().af().e(player.bu);
        }
        return false;
    }

    public static boolean canAnybodyCreatePortals() {
        return letAdminsCreatePortals || letPlayersCreatePortals;
    }

    public static boolean canPlayerCreatePortals(uf player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsCreatePortals;
        }
        return letPlayersCreatePortals;
    }

    public static boolean canPlayerEditPortalServers(uf player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsEditPortalServerList;
        }
        return letPlayersEditPortalServerList;
    }

    public static boolean canAnybodyVerifyPortalServers() {
        return letAdminsVerifyPortalServers || letPlayersVerifyPortalServers;
    }

    public static boolean canEverybodyVerifyPortalServers() {
        return letAdminsVerifyPortalServers && letPlayersVerifyPortalServers;
    }

    public static boolean canPlayerVerifyPortalServers(uf player) {
        if (QCraft.isPlayerOpped(player)) {
            return letAdminsVerifyPortalServers;
        }
        return letPlayersVerifyPortalServers;
    }

    public static void renderQuantumGogglesOverlay(float width, float height) {
        proxy.renderQuantumGogglesOverlay(width, height);
    }

    public static void renderAOGogglesOverlay(float width, float height) {
        proxy.renderAOGogglesOverlay(width, height);
    }

    public static void handlePacket(QCraftPacket packet, Player player) {
        block27: {
            abw world;
            uf entityPlayer;
            block26: {
                entityPlayer = (uf)player;
                world = entityPlayer.q;
                if (world.I) break block26;
                switch (packet.packetType) {
                    case 1: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        computer.tryEnergize();
                        break;
                    }
                    case 3: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        if (QCraft.canPlayerCreatePortals(entityPlayer) && !computer.isTeleporterEnergized()) {
                            computer.setPortalID(packet.dataString[0]);
                            world.j(x, y, z);
                            break;
                        }
                        break block27;
                    }
                    case 2: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        if (QCraft.canPlayerCreatePortals(entityPlayer) && !computer.isTeleporterEnergized()) {
                            computer.setRemotePortalID(packet.dataString[0]);
                            world.j(x, y, z);
                            break;
                        }
                        break block27;
                    }
                    case 7: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        if (QCraft.canPlayerCreatePortals(entityPlayer) && !computer.isTeleporterEnergized()) {
                            computer.cycleRemoteServerAddress(packet.dataString[0]);
                            world.j(x, y, z);
                            break;
                        }
                        break block27;
                    }
                    case 8: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        String name = packet.dataString[0];
                        String address = packet.dataString[1];
                        if (QCraft.canPlayerEditPortalServers(entityPlayer) && name != null && address != null) {
                            PortalRegistry.PortalRegistry.registerServer(name, address);
                        }
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        if (QCraft.canPlayerCreatePortals(entityPlayer) && !computer.isTeleporterEnergized()) {
                            computer.setRemoteServerAddress(address);
                            world.j(x, y, z);
                            break;
                        }
                        break block27;
                    }
                    case 9: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        String address = packet.dataString[0];
                        if (QCraft.canPlayerEditPortalServers(entityPlayer) && address != null) {
                            PortalRegistry.PortalRegistry.unregisterServer(address);
                        }
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        if (QCraft.canPlayerCreatePortals(entityPlayer) && !computer.isTeleporterEnergized()) {
                            computer.setRemoteServerAddress(null);
                            world.j(x, y, z);
                            break;
                        }
                        break block27;
                    }
                    case 11: {
                        int x = packet.dataInt[0];
                        int y = packet.dataInt[1];
                        int z = packet.dataInt[2];
                        asp entity = world.r(x, y, z);
                        if (entity == null || !(entity instanceof TileEntityQuantumComputer)) break;
                        boolean takeItems = packet.dataInt[3] > 0;
                        String expectedServer = packet.dataString[0];
                        TileEntityQuantumComputer computer = (TileEntityQuantumComputer)entity;
                        String actualServer = computer.getRemoteServerAddress();
                        if (computer.isTeleporterEnergized() && expectedServer != null && actualServer != null && expectedServer.equals(actualServer)) {
                            computer.teleportPlayerRemote(entityPlayer, takeItems);
                            break;
                        }
                        break block27;
                    }
                    case 6: {
                        boolean teleported = false;
                        for (int l = 0; l < packet.dataByte.length; ++l) {
                            boolean isDestination;
                            byte[] signedLuggageData = packet.dataByte[l];
                            boolean bl = isDestination = packet.dataInt[l] > 0;
                            if (!QCraft.unpackLuggage(entityPlayer, signedLuggageData, isDestination, teleported, false)) continue;
                            teleported = true;
                        }
                        break block27;
                    }
                }
                break block27;
            }
            switch (packet.packetType) {
                case 10: {
                    TileEntityQuantumComputer computer;
                    int x = packet.dataInt[0];
                    int y = packet.dataInt[1];
                    int z = packet.dataInt[2];
                    asp entity = world.r(x, y, z);
                    if (entity == null || !(entity instanceof TileEntityQuantumComputer) || (computer = (TileEntityQuantumComputer)entity).getRemoteServerAddress() == null) break;
                    proxy.showItemTransferGUI(entityPlayer, computer);
                    break;
                }
                case 4: {
                    String destination = packet.dataString[0];
                    byte[] luggage = packet.dataByte[0];
                    LostLuggage.Address destinationAddress = QCraft.resolveServerAddress(destination);
                    LostLuggage.Instance.load();
                    LostLuggage.Instance.storeLuggage(QCraft.getCurrentServerAddress(), destinationAddress, luggage);
                    LostLuggage.Instance.save();
                    atv minecraft = atv.w();
                    minecraft.f.F();
                    minecraft.a(destinationAddress.getIP(), destinationAddress.getPort());
                    break;
                }
                case 5: {
                    LostLuggage.Address address = QCraft.getCurrentServerAddress();
                    if (address == null) break;
                    LostLuggage.Instance.load();
                    LostLuggage.Instance.removeOldLuggage();
                    Collection<LostLuggage.LuggageMatch> luggages = LostLuggage.Instance.getMatchingLuggage(address);
                    if (luggages.size() <= 0) break;
                    QCraft.requestUnpackLuggage(luggages);
                    break;
                }
                case 12: {
                    LostLuggage.Instance.load();
                    for (int i = 0; i < packet.dataByte.length; ++i) {
                        byte[] luggage = packet.dataByte[i];
                        LostLuggage.Instance.removeLuggage(luggage);
                    }
                    LostLuggage.Instance.save();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static LuggageVerificationResult verifyIncomingLuggage(uf entityPlayer, byte[] signedLuggageData, boolean forceVerify) throws IOException {
        PublicKey key;
        boolean luggageFromLocalServer;
        by luggage;
        byte[] luggageData;
        by signedLuggage;
        block14: {
            signedLuggage = ci.a((byte[])signedLuggageData);
            luggageData = signedLuggage.j("luggage");
            luggage = ci.a((byte[])luggageData);
            if (!signedLuggage.b("key")) {
                entityPlayer.a("Portal Link failed:");
                entityPlayer.a("Signature missing.");
                QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
                return LuggageVerificationResult.UNTRUSTED;
            }
            luggageFromLocalServer = false;
            key = EncryptionRegistry.Instance.decodePublicKey(signedLuggage.j("key"));
            if (EncryptionRegistry.Instance.getLocalKeyPair().getPublic().equals(key)) {
                QCraft.log("Player " + entityPlayer.bu + " has luggage from this server.");
                luggageFromLocalServer = true;
            } else {
                if (!EncryptionRegistry.Instance.getVerifiedPublicKeys().contains(key)) {
                    if (forceVerify) {
                        QCraft.log("Player " + entityPlayer.bu + " has luggage from unverified server. Verifying.");
                        EncryptionRegistry.Instance.getVerifiedPublicKeys().add(key);
                        entityPlayer.a("Portal Link verified.");
                        break block14;
                    } else {
                        QCraft.log("Player " + entityPlayer.bu + " has luggage from unverified server. Ignoring.");
                        entityPlayer.a("Portal Link failed:");
                        if (QCraft.canAnybodyVerifyPortalServers()) {
                            if (QCraft.canEverybodyVerifyPortalServers()) {
                                entityPlayer.a("The server link must be verified first.");
                            } else {
                                entityPlayer.a("The server link must be verified by an admin first.");
                            }
                            QCraft.addUnverifiedLuggage(entityPlayer, signedLuggageData);
                        } else {
                            entityPlayer.a("This server does not allow incoming inter-server portals.");
                        }
                        boolean canVerify = QCraft.canPlayerVerifyPortalServers(entityPlayer);
                        boolean hasItems = luggage.b("items");
                        if (canVerify && hasItems) {
                            entityPlayer.a("Type \"/qcraft verify\" to do this now, or return to the original server within 24 hours to get your items back.");
                            return LuggageVerificationResult.UNTRUSTED;
                        }
                        if (canVerify) {
                            entityPlayer.a("Type \"/qcraft verify\" to do this now.");
                            return LuggageVerificationResult.UNTRUSTED;
                        }
                        if (!hasItems) return LuggageVerificationResult.UNTRUSTED;
                        entityPlayer.a("Return to the original server within 24 hours to get your items back.");
                        return LuggageVerificationResult.UNTRUSTED;
                    }
                }
                QCraft.log("Player " + entityPlayer.bu + " has luggage from verified server.");
            }
        }
        byte[] luggageSignature = signedLuggage.j("signature");
        if (!EncryptionRegistry.Instance.verifyData(key, luggageSignature, luggageData)) {
            QCraft.log("Player " + entityPlayer.bu + "'s luggage failed signature check. Ignoring.");
            entityPlayer.a("Portal Link failed:");
            entityPlayer.a("Signature violation.");
            QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
            return LuggageVerificationResult.UNTRUSTED;
        }
        UUID uuid = UUID.fromString(luggage.i("uuid"));
        if (EncryptionRegistry.Instance.getReceivedLuggageIDs().contains(uuid)) {
            QCraft.log("Player " + entityPlayer.bu + "'s luggage is a duplicate. Ignoring.");
            entityPlayer.a("Portal Link failed:");
            entityPlayer.a("Luggage duplicate.");
            QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
            return LuggageVerificationResult.UNTRUSTED;
        }
        EncryptionRegistry.Instance.getReceivedLuggageIDs().add(uuid);
        QCraft.requestDiscardLuggage(entityPlayer, signedLuggageData);
        if (!luggageFromLocalServer) return LuggageVerificationResult.TRUSTED;
        return LuggageVerificationResult.LOCALKEY;
    }

    private static boolean unpackLuggage(uf entityPlayer, byte[] signedLuggageData, boolean isDestination, boolean teleported, boolean forceVerify) {
        try {
            LuggageVerificationResult verificationResult = QCraft.verifyIncomingLuggage(entityPlayer, signedLuggageData, forceVerify);
            if (verificationResult != LuggageVerificationResult.UNTRUSTED) {
                by signedLuggage = ci.a((byte[])signedLuggageData);
                byte[] luggageData = signedLuggage.j("luggage");
                by luggage = ci.a((byte[])luggageData);
                if (luggage.b("items")) {
                    if (verificationResult == LuggageVerificationResult.LOCALKEY && !isDestination) {
                        entityPlayer.a("Previous attempted Portal Link failed, restoring inventory.");
                    }
                    cg items = luggage.m("items");
                    QCraft.log("Adding " + items.c() + " items to " + entityPlayer.bu + "'s inventory");
                    for (int i = 0; i < items.c(); ++i) {
                        by item;
                        ye stack;
                        cl tag = items.b(i);
                        if (!(tag instanceof by) || entityPlayer.bn.a(stack = ye.a((by)(item = (by)tag)))) continue;
                        entityPlayer.b(stack);
                    }
                    entityPlayer.bn.e();
                }
                if (!teleported && luggage.b("destinationPortal") && (verificationResult == LuggageVerificationResult.TRUSTED || verificationResult == LuggageVerificationResult.LOCALKEY && isDestination)) {
                    String destination = luggage.i("destinationPortal");
                    TileEntityQuantumComputer.PortalLocation location = PortalRegistry.PortalRegistry.getPortal(destination);
                    if (location != null) {
                        QCraft.log("Teleporting " + entityPlayer.bu + " to portal \"" + destination + "\"");
                        TileEntityQuantumComputer.teleportPlayerLocal(entityPlayer, destination);
                    } else {
                        entityPlayer.a("Portal Link failed:");
                        entityPlayer.a("There is no portal on this server called \"" + destination + "\"");
                    }
                    teleported = true;
                }
            }
            return teleported;
        }
        catch (IOException e) {
            throw new RuntimeException("Error unpacking luggage");
        }
    }

    public static void spawnQuantumDustFX(abw world, double x, double y, double z) {
        proxy.spawnQuantumDustFX(world, x, y, z);
    }

    public static LostLuggage.Address resolveServerAddress(String addressString) {
        bdl address = bdl.a((String)addressString);
        if (address != null) {
            return new LostLuggage.Address(address.a(), address.b());
        }
        return null;
    }

    public static void setCurrentServerAddress(LostLuggage.Address address) {
        s_currentServer = address;
    }

    public static LostLuggage.Address getCurrentServerAddress() {
        return s_currentServer;
    }

    public static void addUnverifiedLuggage(uf player, byte[] luggage) {
        Set<byte[]> luggageSet;
        String username = player.bu;
        if (!s_unverifiedLuggage.containsKey(username)) {
            s_unverifiedLuggage.put(username, new HashSet());
        }
        if (!(luggageSet = s_unverifiedLuggage.get(username)).contains(luggage)) {
            luggageSet.add(luggage);
        }
    }

    public static void clearUnverifiedLuggage(uf player) {
        String username = player.bu;
        if (s_unverifiedLuggage.containsKey(username)) {
            s_unverifiedLuggage.remove(username);
        }
    }

    public static void verifyUnverifiedLuggage(uf player) {
        String username = player.bu;
        if (s_unverifiedLuggage.containsKey(username)) {
            Set<byte[]> luggageSet = s_unverifiedLuggage.remove(username);
            boolean teleported = false;
            for (byte[] signedLuggageData : luggageSet) {
                if (!QCraft.unpackLuggage(player, signedLuggageData, true, teleported, true)) continue;
                teleported = true;
            }
        }
    }

    public static void log(String text) {
        MinecraftServer server = MinecraftServer.F();
        if (server != null) {
            server.e("[qCraft] " + text);
        }
    }

    static {
        enableQBlockOcclusionTesting = false;
        enableWorldGen = true;
        enableWorldGenReplacementRecipes = false;
        letAdminsCreatePortals = true;
        letPlayersCreatePortals = true;
        letAdminsEditPortalServerList = true;
        letPlayersEditPortalServerList = false;
        letAdminsVerifyPortalServers = true;
        letPlayersVerifyPortalServers = false;
        s_currentServer = null;
        s_unverifiedLuggage = new HashMap<String, Set<byte[]>>();
    }

    private static enum LuggageVerificationResult {
        UNTRUSTED,
        TRUSTED,
        LOCALKEY;

    }

    public static class Items {
        public static ItemQuantumDust quantumDust;
        public static ItemEOS eos;
        public static ItemQuantumGoggles quantumGoggles;
    }

    public static class Blocks {
        public static BlockQuantumOre quantumOre;
        public static BlockQuantumOre quantumOreGlowing;
        public static BlockQuantumLogic quantumLogic;
        public static BlockQBlock qBlock;
        public static BlockQuantumComputer quantumComputer;
        public static BlockQuantumPortal quantumPortal;
    }
}

