/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import dan200.QCraft;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class EncryptionRegistry {
    public static final EncryptionRegistry Instance = new EncryptionRegistry();
    private KeyPair m_localKeyPair;
    private Set<PublicKey> m_verifiedPublicKeys;
    private Set<UUID> m_receivedLuggageIDs;

    public EncryptionRegistry() {
        this.reset();
    }

    public void reset() {
        this.m_localKeyPair = EncryptionRegistry.generateKeyPair();
        this.m_verifiedPublicKeys = new HashSet<PublicKey>();
        this.m_receivedLuggageIDs = new HashSet<UUID>();
    }

    public void readFromNBT(by nbt) {
        by key;
        int i;
        PublicKey localPublicKey = this.decodePublicKey(nbt.j("localPublicKey"));
        PrivateKey localPrivateKey = this.decodePrivateKey(nbt.j("localPrivateKey"));
        this.m_localKeyPair = new KeyPair(localPublicKey, localPrivateKey);
        if (nbt.b("verifiedPublicKeys")) {
            cg verifiedPublicKeys = nbt.m("verifiedPublicKeys");
            for (i = 0; i < verifiedPublicKeys.c(); ++i) {
                key = (by)verifiedPublicKeys.b(i);
                this.m_verifiedPublicKeys.add(this.decodePublicKey(key.j("publicKey")));
            }
        }
        if (nbt.b("receivedLuggageIDs")) {
            cg receivedLuggageIDs = nbt.m("receivedLuggageIDs");
            for (i = 0; i < receivedLuggageIDs.c(); ++i) {
                key = (by)receivedLuggageIDs.b(i);
                this.m_receivedLuggageIDs.add(UUID.fromString(key.i("uuid")));
            }
        }
    }

    public void writeToNBT(by nbt) {
        nbt.a("localPublicKey", this.encodePublicKey(this.m_localKeyPair.getPublic()));
        nbt.a("localPrivateKey", this.encodePrivateKey(this.m_localKeyPair.getPrivate()));
        cg knownPublicKeys = new cg();
        for (PublicKey publicKey : this.m_verifiedPublicKeys) {
            by key = new by();
            key.a("publicKey", this.encodePublicKey(publicKey));
            knownPublicKeys.a((cl)key);
        }
        nbt.a("verifiedPublicKeys", (cl)knownPublicKeys);
        cg receivedLuggageIDs = new cg();
        for (UUID uuid : this.m_receivedLuggageIDs) {
            by key = new by();
            key.a("uuid", uuid.toString());
            receivedLuggageIDs.a((cl)key);
        }
        nbt.a("receivedLuggageIDs", (cl)receivedLuggageIDs);
    }

    public KeyPair getLocalKeyPair() {
        return this.m_localKeyPair;
    }

    public Set<PublicKey> getVerifiedPublicKeys() {
        return this.m_verifiedPublicKeys;
    }

    public Set<UUID> getReceivedLuggageIDs() {
        return this.m_receivedLuggageIDs;
    }

    public byte[] encodePublicKey(PublicKey key) {
        return new X509EncodedKeySpec(key.getEncoded()).getEncoded();
    }

    public PublicKey decodePublicKey(byte[] encodedKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (Exception e) {
            System.out.println("QCraft: decoding key failed with exception: " + e.toString());
            return null;
        }
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        return new PKCS8EncodedKeySpec(key.getEncoded()).getEncoded();
    }

    public PrivateKey decodePrivateKey(byte[] encodedKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (Exception e) {
            QCraft.log("QCraft: Decoding key failed with exception: " + e.toString());
            return null;
        }
    }

    public byte[] signData(byte[] message) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA", "SUN");
            signature.initSign(this.m_localKeyPair.getPrivate());
            signature.update(message);
            return signature.sign();
        }
        catch (Exception ex) {
            QCraft.log("QCraft: Signing data failed with exception: " + ex.toString());
            return null;
        }
    }

    public boolean verifyData(PublicKey verifyKey, byte[] digest, byte[] message) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA", "SUN");
            signature.initVerify(verifyKey);
            signature.update(message);
            return signature.verify(digest);
        }
        catch (Exception e) {
            QCraft.log("QCraft: Verifying data failed with exception: " + e.toString());
            return false;
        }
    }

    private static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA", "SUN");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(1024, random);
            return keyGen.generateKeyPair();
        }
        catch (Exception ex) {
            QCraft.log("QCraft: Generating keypair failed with exception: " + ex.toString());
            return null;
        }
    }
}

