/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class QCraftPacket {
    public static final byte EnergizeComputer = 1;
    public static final byte SetComputerRemotePortalID = 2;
    public static final byte SetComputerPortalID = 3;
    public static final byte GoToServer = 4;
    public static final byte RequestLuggage = 5;
    public static final byte UnpackLuggage = 6;
    public static final byte CycleServerAddress = 7;
    public static final byte SetNewServerAddress = 8;
    public static final byte RemoveServerAddress = 9;
    public static final byte QueryGoToServer = 10;
    public static final byte ConfirmGoToServer = 11;
    public static final byte DiscardLuggage = 12;
    public byte packetType = 0;
    public String[] dataString = null;
    public int[] dataInt = null;
    public byte[][] dataByte = null;

    private void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.packetType);
        if (this.dataString != null) {
            data.writeByte(this.dataString.length);
        } else {
            data.writeByte(0);
        }
        if (this.dataInt != null) {
            data.writeByte(this.dataInt.length);
        } else {
            data.writeByte(0);
        }
        if (this.dataByte != null) {
            data.writeInt(this.dataByte.length);
        } else {
            data.writeInt(0);
        }
        if (this.dataString != null) {
            for (String s2 : this.dataString) {
                if (s2 != null) {
                    data.writeBoolean(true);
                    data.writeUTF(s2);
                    continue;
                }
                data.writeBoolean(false);
            }
        }
        if (this.dataInt != null) {
            for (int i : this.dataInt) {
                data.writeInt(i);
            }
        }
        if (this.dataByte != null) {
            for (byte[] bytes : this.dataByte) {
                if (bytes != null) {
                    data.writeInt(bytes.length);
                    data.write(bytes);
                    continue;
                }
                data.writeInt(0);
            }
        }
    }

    private void readData(DataInputStream data) throws IOException {
        int k;
        this.packetType = data.readByte();
        int nString = data.readByte();
        int nInt = data.readByte();
        int nByte = data.readInt();
        if (nString > 128 || nInt > 128 || nString < 0 || nInt < 0 || nByte < 0) {
            throw new IOException("");
        }
        if (nString == 0) {
            this.dataString = null;
        } else {
            this.dataString = new String[nString];
            for (k = 0; k < nString; ++k) {
                if (!data.readBoolean()) continue;
                this.dataString[k] = data.readUTF();
            }
        }
        if (nInt == 0) {
            this.dataInt = null;
        } else {
            this.dataInt = new int[nInt];
            for (k = 0; k < nInt; ++k) {
                this.dataInt[k] = data.readInt();
            }
        }
        if (nByte == 0) {
            this.dataByte = null;
        } else {
            this.dataByte = new byte[nByte][];
            for (k = 0; k < nByte; ++k) {
                int length = data.readInt();
                if (length <= 0) continue;
                this.dataByte[k] = new byte[length];
                data.readFully(this.dataByte[k]);
            }
        }
    }

    public ey toPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        ea pkt = new ea();
        try {
            this.writeData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pkt.a = "QCraft";
        pkt.c = bytes.toByteArray();
        pkt.b = pkt.c.length;
        return pkt;
    }

    public static QCraftPacket parse(byte[] bytes) throws IOException {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        QCraftPacket pkt = new QCraftPacket();
        pkt.readData(data);
        return pkt;
    }
}

