/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Random;
import net.fossilsarch.common.FossilOptions;
import net.fossilsarch.common.ai.DinoAIControlledByPlayer;
import net.fossilsarch.common.ai.DinoAIEatLeavesWithHeight;
import net.fossilsarch.common.ai.DinoAIFollowOwner;
import net.fossilsarch.common.ai.DinoAIGrowup;
import net.fossilsarch.common.ai.DinoAIStarvation;
import net.fossilsarch.common.ai.DinoAIUseFeederWithHeight;
import net.fossilsarch.common.ai.DinoAIWander;
import net.fossilsarch.common.entity.EntityDinosaurce;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.EnumOrderType;
import net.fossilsarch.common.io.EnumSituation;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBrachiosaurus
extends EntityDinosaurce {
    public boolean isTamed = false;
    public final float HuntLimit = this.getHungerLimit() * 4 / 5;
    public String OwnerName;
    final float PUSHDOWN_HARDNESS = 5.0f;
    protected final int AGE_LIMIT = 36;

    public EntityBrachiosaurus(World world) {
        this(world, EntityBrachiosaurus.randomSpawnAge(world.field_73012_v));
        this.OrderStatus = EnumOrderType.FreeMove;
    }

    public EntityBrachiosaurus(World world, int dinoAge) {
        super(world);
        this.setDinoAge(dinoAge + dinoAge);
        this.SelfType = EnumDinoType.Brachiosaurus;
        this.func_70105_a(1.1f, 1.6f);
        this.setHunger(this.getHungerLimit());
        this.func_70606_j(8.0f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIGrowup(this, 36));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIStarvation(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.ridingHandler = new DinoAIControlledByPlayer(this, 0.34f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.ridingHandler);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0f, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEatLeavesWithHeight(this, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIUseFeederWithHeight(this, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWander(this, 1.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    private static int randomSpawnAge(Random rand) {
        boolean isChild;
        boolean bl = isChild = rand.nextInt(4) == 0;
        if (isChild) {
            return rand.nextInt(4);
        }
        return rand.nextInt(33) + 4;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + 10.0 * (double)this.getDinoAge());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public float func_70689_ay() {
        float speed = super.func_70689_ay();
        return speed * (0.3f + 0.05f * (float)this.getDinoAge());
    }

    @Override
    public int getHungerLimit() {
        return 500;
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized();
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.modelizedDrop()) {
            return true;
        }
        return super.func_70097_a(damagesource, i);
    }

    protected String func_70639_aQ() {
        if (this.field_70170_p.func_72890_a((Entity)this, 16.0) != null) {
            return "fossilsarch:Brach_living";
        }
        return null;
    }

    protected String func_70621_aR() {
        return "mob.cow.hurt";
    }

    protected String func_70673_aS() {
        return "fossilsarch:Brach_death";
    }

    @Override
    public String func_70905_p() {
        return this.OwnerName;
    }

    @Override
    public void func_70910_a(String s) {
        this.OwnerName = s.toString();
    }

    @Override
    public boolean func_70909_n() {
        return this.isTamed;
    }

    public void func_70903_f(boolean flag) {
        this.isTamed = flag;
    }

    @Override
    public void SetOrder(EnumOrderType input) {
        this.OrderStatus = input;
    }

    @Override
    public boolean HandleEating(int FoodValue) {
        return this.HandleEating(FoodValue, false);
    }

    public boolean HandleEating(int FoodValue, boolean FernFlag) {
        if (this.getHunger() >= this.getHungerLimit()) {
            if (this.func_70909_n() && !FernFlag) {
                this.SendStatusMessage(EnumSituation.Full, this.SelfType);
            }
            return false;
        }
        this.increaseHunger(FoodValue);
        this.showHeartsOrSmokeFX(false);
        if (this.getHunger() >= this.getHungerLimit()) {
            this.setHunger(this.getHungerLimit());
        }
        return true;
    }

    public boolean CheckEatable(int itemIndex) {
        Item tmp = Item.field_77698_e[itemIndex];
        boolean result = false;
        result = tmp == Item.field_77685_T || tmp == Item.field_77738_bf;
        return result;
    }

    @Override
    public void ShowPedia(EntityPlayer checker) {
        this.PediaTextCorrection(this.SelfType, checker);
        if (this.func_70909_n()) {
            mod_Fossil.ShowMessage(OwnerText + this.func_70905_p(), checker);
            mod_Fossil.ShowMessage(AgeText + this.getDinoAge(), checker);
            mod_Fossil.ShowMessage(HelthText + this.func_110143_aJ() + "/" + this.func_110138_aP(), checker);
            mod_Fossil.ShowMessage(HungerText + this.getHunger() + "/" + this.getHungerLimit(), checker);
        } else {
            mod_Fossil.ShowMessage(UntamedText, checker);
        }
    }

    @Override
    public String[] additionalPediaMessage() {
        String[] result = null;
        if (!this.func_70909_n()) {
            result = new String[]{UntamedText};
        } else {
            ArrayList<String> resultList = new ArrayList<String>();
            if (this.func_70909_n() && this.getDinoAge() > 4 && this.field_70153_n == null) {
                resultList.add(RidiableText);
            }
            if (!resultList.isEmpty()) {
                result = new String[1];
                result = resultList.toArray(result);
            }
        }
        return result;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.isModelized()) {
            return this.modelizedInteract(entityplayer);
        }
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.field_77993_c == Item.field_77685_T.field_77779_bT) {
            if (this.CheckEatable(itemstack.field_77993_c) && this.HandleEating(10)) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
                this.func_70691_i(3.0f);
            }
            return true;
        }
        if (FMLCommonHandler.instance().getSide().isClient() && itemstack != null && itemstack.field_77993_c == mod_Fossil.DinoPedia.field_77779_bT) {
            EntityDinosaurce.pediaingDino = this;
            mod_Fossil.callGUI(entityplayer, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (itemstack != null && itemstack.field_77993_c == mod_Fossil.ChickenEss.field_77779_bT) {
            if (this.getDinoAge() >= 12 || this.getHunger() <= 0) {
                return false;
            }
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            entityplayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77729_bt, 1));
            this.setDinoAgeTick(12000);
            this.setHunger(1 + new Random().nextInt(this.getHunger()));
            return true;
        }
        if (itemstack != null && itemstack.field_77993_c == Item.field_77669_D.field_77779_bT && entityplayer.field_71092_bJ.equalsIgnoreCase(this.func_70905_p())) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.OrderStatus = EnumOrderType.values()[(mod_Fossil.EnumToInt(this.OrderStatus) + 1) % 3];
                this.SendOrderMessage(this.OrderStatus);
            }
            return true;
        }
        if (this.func_70909_n() && this.getDinoAge() >= 2 && !this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n == entityplayer)) {
            entityplayer.field_70177_z = this.field_70177_z;
            entityplayer.func_70078_a((Entity)this);
            this.func_70778_a(null);
            this.field_70761_aq = this.field_70177_z;
            return true;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("OrderStatus", (byte)mod_Fossil.EnumToInt(this.OrderStatus));
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.InitSize();
        this.OrderStatus = EnumOrderType.values()[nbttagcompound.func_74771_c("OrderStatus")];
    }

    private void InitSize() {
        this.updateSize(false);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getDinoAge() >= 4) {
            this.BlockInteractive();
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + 10.0 * (double)this.getDinoAge());
    }

    protected boolean func_70780_i() {
        return this.isSelfSitting();
    }

    public void func_70108_f(Entity entity) {
        if (this.isModelized()) {
            return;
        }
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && this.field_70122_E && ((EntityLivingBase)entity).func_70047_e() < this.getHalfHeight()) {
            this.func_70074_a((EntityLivingBase)entity);
            ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            return;
        }
        super.func_70108_f(entity);
    }

    public void setSelfSitting(boolean b) {
        this.OrderStatus = b ? EnumOrderType.Stay : EnumOrderType.FreeMove;
    }

    public boolean isSelfSitting() {
        return this.OrderStatus == EnumOrderType.Stay;
    }

    public float func_70047_e() {
        return 4.0f + (float)this.getDinoAge() / 1.8f;
    }

    public float getHalfHeight() {
        return this.func_70047_e() / 2.0f;
    }

    @Override
    public void BlockInteractive() {
        if (!FossilOptions.TRexBreakingBlocks) {
            return;
        }
        if (this.isModelized()) {
            return;
        }
        int ObjectTall = 0;
        int TmpID = 0;
        int HeightCount = 0;
        int k = 0;
        for (int j = (int)Math.round(this.field_70121_D.field_72340_a) - 1; j <= (int)Math.round(this.field_70121_D.field_72336_d) + 1; ++j) {
            for (HeightCount = 0; HeightCount <= (int)this.getHalfHeight(); ++HeightCount) {
                for (int l = (int)Math.round(this.field_70121_D.field_72339_c) - 1; l <= (int)Math.round(this.field_70121_D.field_72334_f) + 1; ++l) {
                    k = (int)Math.round(this.field_70121_D.field_72338_b) + HeightCount;
                    TmpID = this.field_70170_p.func_72798_a(j, k, l);
                    if (Block.field_71973_m[TmpID] == null || !(Block.field_71973_m[TmpID].func_71934_m(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < this.PUSHDOWN_HARDNESS) || (ObjectTall = this.GetObjectTall(j, k, l)) <= 0 || this.isObjectTooTall(ObjectTall + HeightCount)) continue;
                    this.DestroyTower(j, k, l, ObjectTall);
                }
            }
        }
    }

    private boolean isObjectTooTall(int targetX, int targetY, int targetZ) {
        return (float)this.GetObjectTall(targetX, targetY, targetZ) > this.getHalfHeight();
    }

    private boolean isObjectTooTall(int ObjectTall) {
        float HalfHeight = this.getHalfHeight();
        return (float)ObjectTall > HalfHeight;
    }

    private int GetObjectTall(int targetX, int targetY, int targetZ) {
        int count = 0;
        while (!this.field_70170_p.func_72799_c(targetX, targetY + count, targetZ)) {
            ++count;
        }
        return count;
    }

    private void DestroyTower(int targetX, int bottomY, int targetZ, int ObjectTall) {
        int TmpID = 0;
        for (int y = bottomY; y <= bottomY + ObjectTall; ++y) {
            TmpID = this.field_70170_p.func_72798_a(targetX, y, targetZ);
            this.field_70170_p.func_72926_e(2001, targetX, y, targetZ, TmpID);
            this.field_70170_p.func_94575_c(targetX, y, targetZ, 0);
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getHalfHeight() * 1.2, this.field_70161_v);
    }

    protected void func_70779_j() {
        boolean flag = false;
        int i = -1;
        int j = -1;
        int k = -1;
        float f = -99999.0f;
        if (this.OrderStatus == EnumOrderType.FreeMove || !this.func_70909_n()) {
            for (int l = 0; l < 10 + this.getDinoAge(); ++l) {
                int k1;
                int j1;
                int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70146_Z.nextInt(24 + (int)(this.field_70130_N * this.field_70130_N * 4.0f)) - (12.0 + (double)(this.field_70130_N * this.field_70130_N * 2.0f))));
                float f1 = this.func_70783_a(i1, j1 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70146_Z.nextInt(7) - 3.0)), k1 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70146_Z.nextInt(24 + (int)(this.field_70130_N * this.field_70130_N * 4.0f)) - (12.0 + (double)(this.field_70130_N * this.field_70130_N * 2.0f)))));
                if (!(f1 > f)) continue;
                f = f1;
                i = i1;
                j = j1;
                k = k1;
                flag = true;
            }
            if (flag) {
                this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, i, j, k, 10.0f, true, false, true, false));
            }
        }
    }

    private void HandleRiding() {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerSP && this.field_70122_E) {
            if (((EntityPlayerSP)this.field_70153_n).field_71158_b.field_78901_c) {
                this.func_70664_aZ();
                ((EntityPlayerSP)this.field_70153_n).field_71158_b.field_78901_c = false;
            }
            this.field_70177_z -= ((EntityPlayerSP)this.field_70153_n).field_70702_br * 5.0f;
            while (this.field_70177_z < -180.0f) {
                this.field_70177_z += 360.0f;
            }
            while (this.field_70177_z >= 180.0f) {
                this.field_70177_z -= 360.0f;
            }
            this.field_70701_bs = ((EntityPlayerSP)this.field_70153_n).field_70701_bs;
        }
    }

    @Override
    public void updateSize(boolean shouldAddAge) {
        if (shouldAddAge && this.getDinoAge() < this.AGE_LIMIT) {
            this.increaseDinoAge();
        }
        this.func_70105_a((float)((double)1.1f + 0.2 * (double)this.getDinoAge()), (float)((double)1.6f + 0.15 * (double)this.getDinoAge()));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + 10.0 * (double)this.getDinoAge());
    }

    @Override
    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    @Override
    protected int foodValue(Item asked) {
        return 0;
    }

    @Override
    public void HandleEating(Item food) {
    }

    @Override
    public void HoldItem(Item itemGot) {
    }

    @Override
    public float getGLX() {
        return (float)(1.5 + 0.3 * (double)this.getDinoAge());
    }

    @Override
    public float getGLY() {
        return (float)(1.5 + 0.3 * (double)this.getDinoAge());
    }
}

