/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.List;
import net.fossilsarch.common.entity.EntityBrachiosaurus;
import net.fossilsarch.common.entity.EntityDinosaurce;
import net.fossilsarch.common.entity.EntityMosasaurus;
import net.fossilsarch.common.entity.EntityPlesiosaur;
import net.fossilsarch.common.entity.EntityPterosaur;
import net.fossilsarch.common.entity.EntityRaptor;
import net.fossilsarch.common.entity.EntityStegosaurus;
import net.fossilsarch.common.entity.EntityTRex;
import net.fossilsarch.common.entity.EntityTriceratops;
import net.fossilsarch.common.entity.Entitydil;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.EnumOrderType;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.src.ModLoader;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenTaiga;

public class EntityDinoEgg
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String HEAD = "Dinoegg.";
    private static final String MSGHEAD = "Dinoegg.msghead";
    private static final String MSGTAIL = ".msgtail";
    private static final String COLD = "cold";
    private static final String DRY = "dry";
    private static final String PEDIA = "PediaText.egg.";
    public int damageTaken = 0;
    public int timeSinceHit = 0;
    public EnumDinoType DinoInside;
    public int BirthTick = 0;
    public String ParentOwner = "";
    public final int HatchingNeedTime = 3000;

    public EntityDinoEgg(World world, EnumDinoType Inside) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.5f, 1.5f);
        this.field_70129_M = this.field_70131_O;
        this.DinoInside = Inside;
    }

    public EntityDinoEgg(World world) {
        this(world, null);
    }

    public EntityDinoEgg(World world, EnumDinoType Inside, EntityDinosaurce parent) {
        this(world, Inside);
        this.ParentOwner = parent.func_70905_p();
    }

    public String func_70023_ak() {
        ItemStack shell = new ItemStack(mod_Fossil.Ancientegg, 1, this.EnumToInt(this.DinoInside));
        return shell.func_82833_r();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public EntityDinoEgg(World world, double d, double d1, double d2, EnumDinoType Inside) {
        this(world, Inside);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        this.timeSinceHit = 10;
        this.damageTaken = (int)((float)this.damageTaken + i * 10.0f);
        this.func_70018_K();
        if (this.damageTaken > 40) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
        }
        return true;
    }

    public void func_70057_ab() {
        this.timeSinceHit = 10;
        this.damageTaken += this.damageTaken * 10;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        double d19;
        double d4;
        super.func_70071_h_();
        this.HandleHatching();
        super.func_70071_h_();
        if (this.timeSinceHit > 0) {
            --this.timeSinceHit;
        }
        if (this.damageTaken > 0) {
            --this.damageTaken;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int i = 5;
        double d = 0.0;
        for (int j = 0; j < i; ++j) {
            double d5 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(j + 0) / (double)i - 0.125;
            double d9 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(j + 1) / (double)i - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72332_a().func_72299_a(this.field_70121_D.field_72340_a, d5, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, d9, this.field_70121_D.field_72334_f);
        }
        if (d < 1.0) {
            double d3 = d * 2.0 - 1.0;
            this.field_70181_x += (double)0.04f * d3;
        } else {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x /= 2.0;
            }
            this.field_70181_x += (double)0.007f;
        }
        if (this.field_70153_n != null) {
            this.field_70159_w += this.field_70153_n.field_70159_w * 0.2;
            this.field_70179_y += this.field_70153_n.field_70179_y * 0.2;
        }
        if (this.field_70159_w < -(d4 = 0.4)) {
            this.field_70159_w = -d4;
        }
        if (this.field_70159_w > d4) {
            this.field_70159_w = d4;
        }
        if (this.field_70179_y < -d4) {
            this.field_70179_y = -d4;
        }
        if (this.field_70179_y > d4) {
            this.field_70179_y = d4;
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double d8 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (d8 > 0.15) {
            double d12 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double d15 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            int i1 = 0;
            while ((double)i1 < 1.0 + d8 * 60.0) {
                double d18 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double d20 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    double d21 = this.field_70165_t - d12 * d18 * 0.8 + d15 * d20;
                    double d23 = this.field_70161_v - d15 * d18 * 0.8 - d12 * d20;
                } else {
                    double d22 = this.field_70165_t + d12 + d15 * d18 * 0.7;
                    double d24 = this.field_70161_v + d15 - d12 * d18 * 0.7;
                }
                ++i1;
            }
        }
        if (this.field_70123_F && d8 > 0.15) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.95f;
            this.field_70179_y *= (double)0.99f;
        }
        this.field_70125_A = 0.0f;
        double d13 = this.field_70177_z;
        double d16 = this.field_70169_q - this.field_70165_t;
        double d17 = this.field_70166_s - this.field_70161_v;
        if (d16 * d16 + d17 * d17 > 0.001) {
            d13 = (float)(Math.atan2(d17, d16) * 180.0 / Math.PI);
        }
        for (d19 = d13 - (double)this.field_70177_z; d19 >= 180.0; d19 -= 360.0) {
        }
        while (d19 < -180.0) {
            d19 += 360.0;
        }
        if (d19 > 20.0) {
            d19 = 20.0;
        }
        if (d19 < -20.0) {
            d19 = -20.0;
        }
        this.field_70177_z = (float)((double)this.field_70177_z + d19);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.0, 0.0, 0.0));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBoat)) continue;
                entity.func_70108_f((Entity)this);
            }
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            int j2;
            int i2;
            int l1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(k1 % 2) - 0.5) * 0.8));
            if (this.field_70170_p.func_72798_a(l1, i2 = MathHelper.func_76128_c((double)this.field_70163_u), j2 = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(k1 / 2) - 0.5) * 0.8))) != Block.field_72037_aS.field_71990_ca) continue;
            this.field_70170_p.func_94575_c(l1, i2, j2, 0);
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        double d = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
        double d1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
        this.field_70153_n.func_70107_b(this.field_70165_t + d, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + d1);
    }

    private void HandleHatching() {
        float light = this.func_70013_c(1.0f);
        EntityPlayer PlayerNearby = null;
        if ((this.ParentOwner == "" || this.field_70170_p.func_72924_a(this.ParentOwner) == null) && this.field_70170_p.func_72890_a((Entity)this, 16.0) != null) {
            PlayerNearby = this.field_70170_p.func_72890_a((Entity)this, 16.0);
        }
        if (this.DinoInside == EnumDinoType.Mosasaurus) {
            this.BirthTick = this.field_70171_ac ? ++this.BirthTick : --this.BirthTick;
        } else if ((double)light >= 0.5) {
            ++this.BirthTick;
        } else if (!this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            --this.BirthTick;
        }
        if (this.BirthTick <= -3000) {
            String TailTmp = this.DinoInside == EnumDinoType.Mosasaurus ? StatCollector.func_74838_a((String)"Dinoegg.dry.msgtail") : StatCollector.func_74838_a((String)"Dinoegg.cold.msgtail");
            String MsgHeadTmp = StatCollector.func_74838_a((String)MSGHEAD);
            mod_Fossil.ShowMessage(MsgHeadTmp + EntityDinosaurce.GetNameByEnum(this.DinoInside, false) + TailTmp, PlayerNearby);
            this.func_70106_y();
            return;
        }
        if (this.BirthTick >= 3000) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            BiomeGenBase LocationBiome = this.field_70170_p.field_73011_w.field_76578_c.func_76935_a((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70161_v));
            EntityDinosaurce entityliving = null;
            switch (this.DinoInside) {
                case Triceratops: {
                    entityliving = new EntityTriceratops(this.field_70170_p, 0);
                    entityliving.setSubSpecies(this.field_70170_p.field_73012_v.nextInt(3) + 1);
                    if (PlayerNearby != null) {
                        entityliving.func_70910_a(PlayerNearby.field_71092_bJ);
                        entityliving.func_70903_f(true);
                        break;
                    }
                    entityliving.OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case Raptor: {
                    entityliving = new EntityRaptor(this.field_70170_p, 0);
                    if (LocationBiome instanceof BiomeGenForest) {
                        ((EntityRaptor)entityliving).ChangeSubType(2);
                    }
                    if (LocationBiome instanceof BiomeGenSnow || LocationBiome instanceof BiomeGenTaiga) {
                        ((EntityRaptor)entityliving).ChangeSubType(1);
                    }
                    if (PlayerNearby != null) {
                        entityliving.func_70910_a(PlayerNearby.field_71092_bJ);
                        entityliving.func_70903_f(true);
                        break;
                    }
                    entityliving.OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case TRex: {
                    entityliving = new EntityTRex(this.field_70170_p, 0);
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case Pterosaur: {
                    entityliving = new EntityPterosaur(this.field_70170_p, 0);
                    if (PlayerNearby != null) {
                        ((EntityDinosaurce)entityliving).func_70910_a(PlayerNearby.field_71092_bJ);
                        ((EntityDinosaurce)entityliving).func_70903_f(true);
                        break;
                    }
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case Plesiosaur: {
                    entityliving = new EntityPlesiosaur(this.field_70170_p, 0);
                    if (PlayerNearby == null) break;
                    ((EntityDinosaurce)entityliving).func_70910_a(PlayerNearby.field_71092_bJ);
                    ((EntityDinosaurce)entityliving).func_70903_f(true);
                    break;
                }
                case Mosasaurus: {
                    entityliving = new EntityMosasaurus(this.field_70170_p, 0);
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case Stegosaurus: {
                    entityliving = new EntityStegosaurus(this.field_70170_p, 0);
                    if (PlayerNearby != null) {
                        ((EntityDinosaurce)entityliving).func_70910_a(PlayerNearby.field_71092_bJ);
                        ((EntityDinosaurce)entityliving).func_70903_f(true);
                        break;
                    }
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case dilphosaur: {
                    entityliving = new Entitydil(this.field_70170_p, 0);
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                case Brachiosaurus: {
                    entityliving = new EntityBrachiosaurus(this.field_70170_p, 0);
                    if (PlayerNearby != null) {
                        ((EntityDinosaurce)entityliving).func_70910_a(PlayerNearby.field_71092_bJ);
                        ((EntityDinosaurce)entityliving).func_70903_f(true);
                        break;
                    }
                    ((EntityDinosaurce)entityliving).OrderStatus = EnumOrderType.FreeMove;
                    break;
                }
                default: {
                    mod_Fossil.ShowMessage("Bug:Impossible result.", PlayerNearby);
                    this.func_70106_y();
                    return;
                }
            }
            entityliving.func_70012_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) + 1, (int)Math.floor(this.field_70161_v), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (this.field_70170_p.func_72855_b(((EntityLiving)entityliving).field_70121_D) && this.field_70170_p.func_72945_a((Entity)entityliving, ((EntityLiving)entityliving).field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(((EntityLiving)entityliving).field_70121_D) ^ this.DinoInside == EnumDinoType.Mosasaurus) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entityliving);
                }
                if (PlayerNearby != null) {
                    mod_Fossil.ShowMessage(StatCollector.func_74838_a((String)"Dinoegg.Hatched"), PlayerNearby);
                }
                this.func_70106_y();
            } else {
                mod_Fossil.ShowMessage(StatCollector.func_74838_a((String)"Dinoegg.NoSpace"), PlayerNearby);
                this.BirthTick -= 500;
            }
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("BirthTick", this.BirthTick);
        nbttagcompound.func_74768_a("DinoType", this.EnumToInt(this.DinoInside));
        nbttagcompound.func_74778_a("ParentOwner", this.ParentOwner);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        EnumDinoType[] DinoChart = EnumDinoType.values();
        this.BirthTick = nbttagcompound.func_74762_e("BirthTick");
        this.DinoInside = DinoChart[nbttagcompound.func_74762_e("DinoType")];
        this.ParentOwner = nbttagcompound.func_74779_i("ParentOwner");
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack == null) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack shell = new ItemStack(mod_Fossil.Ancientegg, 1, this.EnumToInt(this.DinoInside));
                if (entityplayer.field_71071_by.func_70441_a(shell)) {
                    ModLoader.onItemPickup((EntityPlayer)entityplayer, (ItemStack)shell);
                    this.field_70170_p.func_72956_a((Entity)entityplayer, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.func_70106_y();
                } else {
                    return false;
                }
            }
            return false;
        }
        if (!this.field_70170_p.field_72995_K && itemstack.func_77973_b().field_77779_bT == mod_Fossil.DinoPedia.field_77779_bT) {
            this.showpedia(entityplayer);
            return true;
        }
        return false;
    }

    private int EnumToInt(EnumDinoType input) {
        return this.DinoInside.ordinal();
    }

    private void showpedia(EntityPlayer checker) {
        String TempStatus = "";
        String self = StatCollector.func_74838_a((String)"PediaText.egg.selfHead") + StatCollector.func_74838_a((String)this.DinoInside.getDinoName()) + StatCollector.func_74838_a((String)"PediaText.egg.selfTail");
        int Progress = (int)Math.floor((float)this.BirthTick / 3000.0f * 100.0f);
        mod_Fossil.ShowMessage(self, checker);
        TempStatus = this.DinoInside == EnumDinoType.Mosasaurus ? (this.BirthTick >= 0 ? StatCollector.func_74838_a((String)"PediaText.egg.wet") : StatCollector.func_74838_a((String)"PediaText.egg.dry")) : (this.BirthTick >= 0 ? StatCollector.func_74838_a((String)"PediaText.egg.warm") : StatCollector.func_74838_a((String)"PediaText.egg.cold"));
        String StatusText = StatCollector.func_74838_a((String)"PediaText.egg.Status");
        String HatchingText = StatCollector.func_74838_a((String)"PediaText.egg.Progress");
        mod_Fossil.ShowMessage(StatusText + TempStatus, checker);
        mod_Fossil.ShowMessage(HatchingText + Progress + "/100", checker);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.BirthTick);
        data.writeInt(this.EnumToInt(this.DinoInside));
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.BirthTick = data.readInt();
        this.DinoInside = EnumDinoType.values()[data.readInt()];
    }
}

