/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Random;
import net.fossilsarch.common.ai.DinoAIAvoidEntityWhenYoung;
import net.fossilsarch.common.ai.DinoAIFollowOwner;
import net.fossilsarch.common.ai.DinoAIGrowup;
import net.fossilsarch.common.ai.DinoAIPickItem;
import net.fossilsarch.common.ai.DinoAIStarvation;
import net.fossilsarch.common.ai.DinoAITargetNonTamedExceptSelfClass;
import net.fossilsarch.common.ai.DinoAIUseFeeder;
import net.fossilsarch.common.ai.DinoAIWander;
import net.fossilsarch.common.block.BlockBreakingRule;
import net.fossilsarch.common.entity.EntityDinosaurce;
import net.fossilsarch.common.io.EnumDinoEating;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.EnumOrderType;
import net.fossilsarch.common.io.EnumSituation;
import net.fossilsarch.mod_Fossil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTRex
extends EntityDinosaurce {
    public final int Areas = 15;
    public final float HuntLimit = (float)this.getHungerLimit() * 0.8f;
    private boolean looksWithInterest;
    private float field_25048_b;
    private float field_25054_c;
    private boolean field_25052_g;
    public boolean Screaming = false;
    public int SkillTick = 0;
    public int WeakToDeath = 0;
    public int TooNearMessageTick = 0;
    public boolean SneakScream = false;
    private final BlockBreakingRule blockBreakingBehavior = new BlockBreakingRule(this.field_70170_p, (EntityDinosaurce)this, 3, 5.0f);

    public EntityTRex(World world) {
        this(world, EntityTRex.randomSpawnAge(world.field_73012_v));
        this.OrderStatus = EnumOrderType.FreeMove;
    }

    public EntityTRex(World world, int age) {
        super(world);
        this.setDinoAge(age);
        this.SelfType = EnumDinoType.TRex;
        this.looksWithInterest = false;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70606_j(10 + 23 * age);
        this.attackStrength = 4 + this.getDinoAge();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIGrowup(this, 8, 23));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIStarvation(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIAvoidEntityWhenYoung((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0f, 1.2f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIFollowOwner(this, 1.0f, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIUseFeeder(this, 1.0f, 24, this.HuntLimit, EnumDinoEating.Carnivorous));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIWander(this, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77784_aq, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77741_bi, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77735_bk, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77782_ar, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77734_bj, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, Item.field_77736_bl, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, mod_Fossil.RawDinoMeat, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIPickItem(this, mod_Fossil.CookedDinoMeat, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAITargetNonTamedExceptSelfClass(this, EntityLivingBase.class, 50, false));
    }

    private static int randomSpawnAge(Random random) {
        return random.nextInt(8) + 16;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public int getHungerLimit() {
        return 500;
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized() && this.field_70153_n == null && !this.isWeak();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public boolean isYoung() {
        return this.getDinoAge() <= 3;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Angry", this.isSelfAngry());
        nbttagcompound.func_74757_a("Sitting", this.isSelfSitting());
        nbttagcompound.func_74768_a("WeakToDeath", this.WeakToDeath);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSelfAngry(nbttagcompound.func_74767_n("Angry"));
        this.setSelfSitting(nbttagcompound.func_74767_n("Sitting"));
        this.InitSize();
        this.WeakToDeath = nbttagcompound.func_74762_e("WeakToDeath");
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        if (this.field_70170_p.func_72890_a((Entity)this, 8.0) != null) {
            return "fossilsarch:TRex_Living";
        }
        return null;
    }

    protected String func_70621_aR() {
        return "fossilsarch:TRex_hit";
    }

    protected String func_70673_aS() {
        return "fossilsarch:TRex_Death";
    }

    @Override
    protected void func_70626_be() {
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public boolean func_70090_H() {
        if (this.field_70122_E) {
            return false;
        }
        return super.func_70090_H();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.blockBreakingBehavior.execute();
        if (!(this.func_110143_aJ() <= 0.0f)) {
            this.field_25054_c = this.field_25048_b;
            this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
            if (this.looksWithInterest) {
                this.field_70700_bx = 10;
            }
        }
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && (this.field_70153_n != null || this.isSelfAngry()) && this.field_70122_E && this.getDinoAge() > 3) {
            this.func_70074_a((EntityLivingBase)entity);
            ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            return;
        }
        super.func_70108_f(entity);
    }

    public boolean getSelfShaking() {
        return false;
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        if (this.isSelfSitting()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    private void handleScream() {
        EntityLivingBase target = this.func_70638_az();
        if (target == null) {
            this.Screaming = false;
            return;
        }
        double distance = this.func_70068_e((Entity)target);
        this.Screaming = distance <= (double)(this.field_70130_N * 4.0f * this.field_70130_N * 4.0f);
    }

    protected boolean func_70780_i() {
        return this.isSelfSitting() || this.field_25052_g;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (damagesource.func_76346_g() == this) {
            return false;
        }
        Entity entity = damagesource.func_76346_g();
        if (damagesource.field_76373_n.equals("arrow") && this.getDinoAge() >= 3) {
            return false;
        }
        if (i < 6.0f && entity != null && this.getDinoAge() >= 3) {
            return false;
        }
        if (i == 20.0f && entity == null) {
            return super.func_70097_a(damagesource, 200.0f);
        }
        this.func_70784_b((Entity)((EntityLivingBase)entity));
        return super.func_70097_a(damagesource, i);
    }

    protected void func_70665_d(DamageSource damagesource, float i) {
        i = this.func_70655_b(damagesource, i);
        i = this.func_70672_c(damagesource, i);
        this.func_70606_j(this.func_110143_aJ() - i);
    }

    protected Entity func_70782_k() {
        if (this.isSelfAngry()) {
            return this.field_70170_p.func_72890_a((Entity)this, 16.0);
        }
        return null;
    }

    protected void func_70785_a(Entity entity, float f) {
        this.func_70625_a(entity, 30.0f, 30.0f);
        if (!this.func_70781_l()) {
            this.func_70778_a(this.field_70170_p.func_72865_a((Entity)this, this.func_70777_m(), f, true, false, true, false));
        }
        if ((double)f > (double)this.field_70130_N * 1.6) {
            if (this.field_70122_E) {
                double d = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
                this.field_70159_w = d / (double)f1 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f1 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                if (this.getDinoAge() <= 3) {
                    this.field_70181_x = 0.4f;
                }
                if (f < 5.0f && !this.Screaming) {
                    if (this.getDinoAge() >= 3) {
                        this.field_70170_p.func_72956_a((Entity)this, "fossilsarch:TRex_scream", this.func_70599_aP() * 2.0f, 1.0f);
                    }
                    this.Screaming = true;
                }
            }
        } else {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.attackStrength);
        }
    }

    public void func_70074_a(EntityLivingBase entityliving) {
        super.func_70074_a(entityliving);
        if (this.getDinoAge() >= 3) {
            this.field_70170_p.func_72956_a((Entity)this, "fossilsarch:TRex_scream", this.func_70599_aP() * 2.0f, 1.0f);
        }
        if (!this.isWeak()) {
            if (entityliving instanceof EntityPig) {
                this.HandleEating(30);
            }
            if (entityliving instanceof EntitySheep) {
                this.HandleEating(35);
            }
            if (entityliving instanceof EntityCow) {
                this.HandleEating(50);
            }
            if (entityliving instanceof EntityChicken) {
                this.HandleEating(20);
            }
            if (entityliving instanceof EntityMob) {
                this.HandleEating(20);
            }
            this.heal(5);
        }
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (FMLCommonHandler.instance().getSide().isClient() && itemstack != null && itemstack.field_77993_c == mod_Fossil.DinoPedia.field_77779_bT) {
            EntityDinosaurce.pediaingDino = this;
            mod_Fossil.callGUI(entityplayer, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (this.EOCInteract(itemstack, entityplayer)) {
            return true;
        }
        if (!this.func_70909_n()) {
            if (itemstack != null) {
                if (itemstack.field_77993_c == mod_Fossil.Gen.field_77779_bT) {
                    if (this.isWeak() && !this.func_70909_n() && this.getDinoAge() > 3) {
                        this.heal(200);
                        this.HandleEating(500);
                        this.WeakToDeath = 0;
                        this.func_70903_f(true);
                        this.func_70910_a(entityplayer.field_71092_bJ);
                        --itemstack.field_77994_a;
                        return true;
                    }
                    if (!this.isWeak()) {
                        this.SendStatusMessage(EnumSituation.GemErrorHealth, this.SelfType);
                        --itemstack.field_77994_a;
                    }
                    if (this.getDinoAge() <= 3) {
                        this.SendStatusMessage(EnumSituation.GemErrorYoung, this.SelfType);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != entityplayer)) {
            entityplayer.field_70177_z = this.field_70177_z;
            entityplayer.func_70078_a((Entity)this);
            this.func_70778_a(null);
            this.field_70761_aq = this.field_70177_z;
            return true;
        }
        return false;
    }

    public int func_70641_bl() {
        return 200;
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public boolean isSelfSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setSelfAngry(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag != this.isSelfAngry()) {
            if (flag) {
                this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 2)));
            } else {
                this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFD)));
            }
        }
    }

    public void setSelfSitting(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFE)));
        }
    }

    public void func_70903_f(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFB)));
        }
    }

    private void InitSize() {
        this.func_70105_a((float)(0.5 + 0.5125 * (double)this.getDinoAge()), (float)(0.5 + 0.5125 * (double)this.getDinoAge()));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.attackStrength = 4 + this.getDinoAge();
    }

    @Override
    public boolean CheckSpace() {
        return !this.func_70094_T();
    }

    @Override
    public boolean HandleEating(int FoodValue) {
        if (this.getHunger() >= this.getHungerLimit()) {
            return false;
        }
        this.increaseHunger(FoodValue);
        this.showHeartsOrSmokeFX(false);
        if (this.getHunger() >= this.getHungerLimit()) {
            this.setHunger(this.getHungerLimit());
        }
        return true;
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getGLY() * 1.5, this.field_70161_v);
        }
    }

    private void Flee(Entity EscapeFrom, int range) {
        int DistanceX = new Random().nextInt(range) + 1;
        int DistanceZ = (int)Math.round(Math.sqrt(Math.pow(range, 2.0) - Math.pow(DistanceX, 2.0)));
        int TargetX = 0;
        int TargetY = 0;
        int TargetZ = 0;
        boolean flag = false;
        int i = -1;
        int j = -1;
        int k = -1;
        float f = -99999.0f;
        TargetX = EscapeFrom.field_70165_t <= this.field_70165_t ? (int)Math.round(this.field_70165_t) + DistanceX : (int)Math.round(this.field_70165_t) - DistanceX;
        TargetZ = EscapeFrom.field_70161_v <= this.field_70161_v ? (int)Math.round(this.field_70161_v) + DistanceZ : (int)Math.round(this.field_70161_v) - DistanceZ;
        for (int ic = 128; ic > 0; --ic) {
            if (this.field_70170_p.func_72799_c(TargetX, ic, TargetZ)) continue;
            TargetY = ic;
            break;
        }
        this.func_70903_f(false);
        this.setSelfSitting(false);
        this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, TargetX, TargetY, TargetZ, (float)range, true, false, true, false));
    }

    public void func_70636_d() {
        if (!this.isWeak()) {
            this.handleScream();
        } else {
            this.HandleWeak();
        }
        super.func_70636_d();
    }

    private boolean isBaby() {
        return this.getDinoAge() < 3;
    }

    protected void func_70664_aZ() {
        if (!this.func_70090_H()) {
            if (this.field_70153_n != null) {
                this.field_70181_x += 0.6299999803304672;
            } else {
                super.func_70664_aZ();
            }
        } else if (!this.field_70122_E) {
            this.field_70181_x -= 0.1;
        }
    }

    public void heal(int i) {
        if (this.func_110143_aJ() <= 0.0f) {
            return;
        }
        this.func_70606_j(this.func_110143_aJ() + (float)i);
        if (this.func_110143_aJ() > 200.0f) {
            this.func_70606_j(200.0f);
        }
    }

    public boolean isWeak() {
        return false;
    }

    private void HandleWeak() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.WeakToDeath;
        if (this.WeakToDeath >= 200) {
            this.func_70097_a(DamageSource.field_76377_j, 20.0f);
            return;
        }
        this.func_70784_b(null);
        this.func_70778_a(null);
        this.setSelfAngry(false);
    }

    @Override
    public void ShowPedia(EntityPlayer checker) {
        this.PediaTextCorrection(this.SelfType, checker);
        if (this.func_70909_n()) {
            mod_Fossil.ShowMessage(OwnerText + this.func_70905_p(), checker);
            mod_Fossil.ShowMessage(AgeText + this.getDinoAge(), checker);
            mod_Fossil.ShowMessage(HelthText + this.func_110143_aJ() + "/" + 20, checker);
            mod_Fossil.ShowMessage(HungerText + this.getHunger() + "/" + this.getHungerLimit(), checker);
            if (this.getDinoAge() >= 4 && this.func_70909_n()) {
                mod_Fossil.ShowMessage(RidiableText, checker);
            }
        } else if (!this.isWeak()) {
            mod_Fossil.ShowMessage(CautionText, checker);
        } else {
            mod_Fossil.ShowMessage(WeakText, checker);
        }
    }

    @Override
    public String[] additionalPediaMessage() {
        String[] result = null;
        if (!this.func_70909_n()) {
            result = new String[]{UntamedText};
        } else {
            ArrayList<String> resultList = new ArrayList<String>();
            if (this.getDinoAge() >= 4 && this.func_70909_n()) {
                resultList.add(RidiableText);
            }
            if (!this.isWeak() && !this.func_70909_n()) {
                resultList.add(CautionText);
            }
            if (!resultList.isEmpty()) {
                result = new String[1];
                result = resultList.toArray(result);
            }
        }
        return result;
    }

    @Override
    public void SetOrder(EnumOrderType input) {
        this.OrderStatus = input;
    }

    public boolean HandleEating(int FoodValue, boolean FernFlag) {
        return this.HandleEating(FoodValue);
    }

    public boolean CheckEatable(int itemIndex) {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return new EntityTRex(this.field_70170_p, 0);
    }

    public float func_70689_ay() {
        float f = 1.0f;
        if (this.getDinoAge() < 3) {
            f = super.func_70689_ay();
            if (this.field_70788_c > 0) {
                f *= 3.0f;
            }
        } else if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerSP) {
            EntityPlayerSP Rider = (EntityPlayerSP)this.field_70153_n;
            if (Rider.field_71158_b.field_78899_d) {
                f = 5.0f;
            }
        }
        return f;
    }

    @Override
    public void updateSize(boolean shouldAddAge) {
    }

    @Override
    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    @Override
    protected int foodValue(Item asked) {
        return 0;
    }

    @Override
    public void HandleEating(Item food) {
    }

    @Override
    public void HoldItem(Item itemGot) {
    }

    @Override
    public float getGLX() {
        return (float)(0.5 + 0.5125 * (double)this.getDinoAge());
    }

    @Override
    public float getGLY() {
        return (float)(0.5 + 0.5125 * (double)this.getDinoAge());
    }
}

