/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Random;
import net.fossilsarch.common.io.ByteArrayTag;
import net.fossilsarch.common.io.CompoundTag;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.NBTInputStream;
import net.fossilsarch.common.io.ShortTag;
import net.fossilsarch.common.worldgen.RelicHoleList;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenAcademy
implements IWorldGenerator {
    private File SchFile = new File(this.getClass().getResource("/FossilStructers/").getFile(), "academy1.schematic");
    private FileInputStream SchInp;
    private NBTInputStream SchSource;
    private CompoundTag Tg;
    private int WidthX;
    private int Layers;
    private int WidthZ;
    private byte[] BlockArray;
    private byte[] MDArray;
    private int GenCount = 0;
    private RelicHoleList Damages;
    private static final int GenLimit = 500;

    public WorldGenAcademy() {
        mod_Fossil.DebugMessage("Model route:" + this.SchFile.getPath());
        if (this.SchFile.exists()) {
            try {
                this.SchInp = new FileInputStream(this.SchFile);
                this.SchSource = new NBTInputStream(this.SchInp);
                this.Tg = (CompoundTag)this.SchSource.readTag();
                this.SchSource.close();
            }
            catch (Throwable t) {
                return;
            }
            this.WidthX = ((ShortTag)this.Tg.getValue().get("Width")).getValue().shortValue();
            this.Layers = ((ShortTag)this.Tg.getValue().get("Height")).getValue().shortValue();
            this.WidthZ = ((ShortTag)this.Tg.getValue().get("Length")).getValue().shortValue();
            this.BlockArray = ((ByteArrayTag)this.Tg.getValue().get("Blocks")).getValue();
            this.MDArray = ((ByteArrayTag)this.Tg.getValue().get("Data")).getValue();
            mod_Fossil.DebugMessage("Academy model loaded");
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int ScanZ;
        int ScanX;
        int ScanY;
        chunkX *= 16;
        chunkZ *= 16;
        int posY = 50 + random.nextInt(20);
        if (!this.SchFile.exists()) {
            return;
        }
        if (this.GenCount != 0) {
            --this.GenCount;
            return;
        }
        this.GenCount = 500;
        int SoildCount = 0;
        int SoildLimit = this.WidthX * this.WidthZ / 2;
        this.Damages = new RelicHoleList(random, this.WidthX, this.Layers, this.WidthZ, this.BlockArray, 15, 3);
        for (ScanY = 2; ScanY < this.Layers; ++ScanY) {
            if (ScanY == 2) {
                block1: for (ScanX = 0; ScanX < this.WidthX; ++ScanX) {
                    for (ScanZ = 0; ScanZ < this.WidthZ; ++ScanZ) {
                        if (world.func_72809_s(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ)) {
                            ++SoildCount;
                        }
                        if (SoildCount >= SoildLimit) continue block1;
                    }
                }
                if (SoildCount >= SoildLimit) continue;
                return;
            }
            if (world.func_72799_c(chunkX - this.WidthX / 2, posY + ScanY, chunkZ - this.WidthZ / 2)) continue;
            return;
        }
        for (ScanY = 0; ScanY < this.Layers; ++ScanY) {
            for (ScanZ = 0; ScanZ < this.WidthZ; ++ScanZ) {
                for (ScanX = 0; ScanX < this.WidthX; ++ScanX) {
                    int MixedIndex = ScanY * this.WidthX * this.WidthZ + ScanZ * this.WidthX + ScanX;
                    short TmpBlock = this.BlockArray[MixedIndex];
                    int TmpMD = this.MDArray[MixedIndex];
                    if (TmpBlock == Block.field_72069_aq.field_71990_ca) {
                        TmpBlock = 0;
                    }
                    if (TmpBlock == Block.field_72014_bd.field_71990_ca && random.nextInt(100) < 10) {
                        TmpBlock = 0;
                    }
                    if (TmpBlock == Block.field_72081_al.field_71990_ca || TmpBlock == Block.field_72041_aW.field_71990_ca) {
                        if (TmpBlock == Block.field_72041_aW.field_71990_ca) {
                            TmpMD = 2;
                        }
                        TmpBlock = (short)Block.field_72007_bm.field_71990_ca;
                    } else if (this.Damages.isHole(ScanX, ScanY, ScanZ)) {
                        TmpBlock = 0;
                    }
                    if (TmpBlock != 0) {
                        if (TmpBlock == Block.field_72071_ax.field_71990_ca) {
                            TmpBlock = (short)mod_Fossil.blockcultivateIdle.field_71990_ca;
                        }
                        world.func_72832_d(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ, (int)TmpBlock, TmpMD, 2);
                        if (Block.field_71973_m[TmpBlock] == null || !Block.field_71973_m[TmpBlock].hasTileEntity(TmpMD)) continue;
                        this.SetupTileEntitys(world, random, chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ, ScanY);
                        continue;
                    }
                    Material MatCheck = world.func_72803_f(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ);
                    if (MatCheck == Material.field_76244_g || MatCheck == Material.field_76251_o) continue;
                    world.func_72832_d(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ, 0, 0, 3);
                }
            }
        }
        mod_Fossil.DebugMessage("Placing Academy of " + " at " + chunkX + ',' + posY + ',' + chunkZ);
    }

    public void SetupTileEntitys(World world, Random rand, int CordX, int CordY, int CordZ, int ScanY) {
        TileEntity Target = world.func_72796_p(CordX, CordY, CordZ);
        boolean isDisc = false;
        if (Target == null) {
            return;
        }
        if (Target instanceof TileEntityChest) {
            TileEntityChest Chest = (TileEntityChest)Target;
            ItemStack Tmp = null;
            isDisc = ScanY > this.Layers / 2;
            int Count = isDisc ? 1 : rand.nextInt(10);
            for (int i = 1; i <= Count; ++i) {
                Tmp = this.GetRandomContent(rand, isDisc);
                if (Tmp == null) continue;
                Chest.func_70299_a(rand.nextInt(Chest.func_70302_i_()), Tmp);
            }
        } else {
            return;
        }
    }

    public ItemStack GetRandomContent(Random rand, boolean isDisc) {
        int Chance = rand.nextInt(1000);
        if (isDisc) {
            return new ItemStack(Item.field_77698_e[Item.field_77819_bI.field_77779_bT + rand.nextInt(11)], 1);
        }
        if (Chance < 10) {
            return new ItemStack(mod_Fossil.AncientJavelin, rand.nextInt(4) + 1);
        }
        if (Chance < 200) {
            return new ItemStack(mod_Fossil.biofossil);
        }
        if (Chance < 300) {
            return new ItemStack(mod_Fossil.DNA, rand.nextInt(2) + 1, rand.nextInt(EnumDinoType.values().length));
        }
        if (Chance < 400) {
            return new ItemStack((Item)Item.field_77726_bs, 1, 1 + rand.nextInt(19));
        }
        return null;
    }
}

