/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import net.fossilsarch.common.entity.EntityBones;
import net.fossilsarch.common.io.ByteArrayTag;
import net.fossilsarch.common.io.CompoundTag;
import net.fossilsarch.common.io.EnumShipTypes;
import net.fossilsarch.common.io.NBTInputStream;
import net.fossilsarch.common.io.ShortTag;
import net.fossilsarch.common.worldgen.RelicHoleList;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenShipWreck
implements IWorldGenerator {
    private File SchFile;
    private InputStream SchInp;
    private NBTInputStream SchSource = null;
    private ArrayList ModelTagList = new ArrayList();
    private int WidthX;
    private int Layers;
    private int WidthZ;
    private byte[] BlockArray;
    private byte[] MDArray;
    private int ShipCount = 0;
    private static final int ShipLimit = 12500;
    private RelicHoleList Damages;
    public EnumShipTypes SelfType;
    private final int OCEAN_DEPTH = 14;
    private final String[] shipList = new String[]{"cheheWreck", "dukeWreck", "galleonWreck", "ShipWreck", "shortRangeWreck", "vikingWreck"};
    private boolean loaded = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldGenShipWreck() {
        String ZIP_LOC = "FossilStructers/shipWrecks/";
        String FILE_LOC = "/FossilStructers/shipWrecks/";
        String SCH_NAME = ".schematic";
        for (int i = 0; i < this.shipList.length; ++i) {
            for (int j = 0; j < 360; j += 90) {
                String jName = j == 0 ? "" : "_" + String.valueOf(j);
                URL tester = this.getClass().getResource("/FossilStructers/shipWrecks/" + this.shipList[i] + jName + ".schematic");
                if (tester == null) continue;
                try {
                    this.SchFile = new File(tester.getFile());
                    this.SchInp = new FileInputStream(this.SchFile);
                    mod_Fossil.DebugMessage("Model route:" + this.SchFile.getPath());
                    this.SchSource = new NBTInputStream(this.SchInp);
                    this.ModelTagList.add((CompoundTag)this.SchSource.readTag());
                    mod_Fossil.DebugMessage("Ship model " + this.SchFile.getName() + " loaded");
                    continue;
                }
                catch (Throwable t) {
                    this.loaded = false;
                    continue;
                }
                finally {
                    try {
                        if (this.SchSource != null) {
                            this.SchSource.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int ScanY;
        int posY = 60;
        chunkX *= 16;
        chunkZ *= 16;
        if (!this.loaded) {
            return;
        }
        int heightRemind = 0;
        if (this.ModelTagList.isEmpty()) {
            return;
        }
        CompoundTag Tg = (CompoundTag)this.ModelTagList.get(random.nextInt(this.ModelTagList.size()));
        this.WidthX = ((ShortTag)Tg.getValue().get("Width")).getValue().shortValue();
        this.Layers = ((ShortTag)Tg.getValue().get("Height")).getValue().shortValue();
        if (this.Layers > this.OCEAN_DEPTH) {
            heightRemind = this.Layers - this.OCEAN_DEPTH;
        }
        this.WidthZ = ((ShortTag)Tg.getValue().get("Length")).getValue().shortValue();
        this.BlockArray = ((ByteArrayTag)Tg.getValue().get("Blocks")).getValue();
        this.MDArray = ((ByteArrayTag)Tg.getValue().get("Data")).getValue();
        if (this.ShipCount != 0) {
            --this.ShipCount;
            return;
        }
        this.ShipCount = 12500;
        int WaterLayerCount = 0;
        this.SelfType = EnumShipTypes.GetRandom(random);
        this.Damages = new RelicHoleList(random, this.WidthX, this.Layers, this.WidthZ, this.BlockArray, -1, -1);
        while (!world.func_72809_s(chunkX + this.WidthX / 2, posY, chunkZ + this.WidthZ / 2)) {
            --posY;
        }
        for (ScanY = 0; ScanY < this.Layers - heightRemind && (world.func_72803_f(chunkX - this.WidthX / 2, posY + ScanY, chunkZ - this.WidthZ / 2) != Material.field_76244_g || ++WaterLayerCount < this.Layers / 2); ++ScanY) {
        }
        if (WaterLayerCount < this.Layers / 2) {
            return;
        }
        posY -= heightRemind;
        for (ScanY = 0; ScanY < this.Layers; ++ScanY) {
            for (int ScanZ = 0; ScanZ < this.WidthZ; ++ScanZ) {
                for (int ScanX = 0; ScanX < this.WidthX; ++ScanX) {
                    int MixedIndex = ScanY * this.WidthX * this.WidthZ + ScanZ * this.WidthX + ScanX;
                    if (MixedIndex >= this.BlockArray.length) {
                        return;
                    }
                    byte TmpBlock = this.BlockArray[MixedIndex];
                    int TmpMD = this.MDArray[MixedIndex];
                    if (TmpBlock == Block.field_72069_aq.field_71990_ca) {
                        TmpBlock = 0;
                    } else if (this.Damages.isHole(ScanX, ScanY, ScanZ)) {
                        TmpBlock = 0;
                    }
                    if (TmpBlock != 0) {
                        if (TmpBlock == Block.field_71988_x.field_71990_ca) {
                            TmpMD = this.SelfType.getMetaData();
                        }
                        world.func_72832_d(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ, (int)TmpBlock, TmpMD, 2);
                        if (!Block.field_71973_m[TmpBlock].hasTileEntity(TmpMD)) continue;
                        this.SetupTileEntitys(world, random, chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ);
                        continue;
                    }
                    if (random.nextInt(10000) >= 5) continue;
                    EntityBones bones = new EntityBones(world);
                    bones.func_70012_b(chunkX - this.WidthX / 2 + ScanX, posY + ScanY, chunkZ - this.WidthZ / 2 + ScanZ, random.nextFloat() * 360.0f, 0.0f);
                    if (!world.func_72855_b(bones.field_70121_D) || world.func_72945_a((Entity)bones, bones.field_70121_D).size() != 0) continue;
                    world.func_72838_d((Entity)bones);
                }
            }
        }
        mod_Fossil.DebugMessage("Placing shipwreck of " + this.SelfType.toString() + " at " + chunkX + ',' + posY + ',' + chunkZ);
    }

    private short SwapCargoBlock(Random rand) {
        int Chance = rand.nextInt(1000);
        switch (this.SelfType) {
            case Science: {
                if (Chance < 10) {
                    return (short)mod_Fossil.blockanalyzerIdle.field_71990_ca;
                }
                if (Chance < 20) {
                    return (short)mod_Fossil.blockcultivateIdle.field_71990_ca;
                }
                if (Chance >= 30) break;
                return (short)mod_Fossil.blockworktableIdle.field_71990_ca;
            }
            case MetalTrader: {
                if (Chance < 500) {
                    return (short)Block.field_72083_ai.field_71990_ca;
                }
                if (Chance >= 600) break;
                return (short)Block.field_72105_ah.field_71990_ca;
            }
            case Battleship: {
                if (Chance >= 333) break;
                return (short)Block.field_72091_am.field_71990_ca;
            }
            default: {
                if (Chance >= 100) break;
                return (short)mod_Fossil.blockSkull.field_71990_ca;
            }
        }
        return 0;
    }

    private byte SwapCargoMD(Random rand) {
        return 0;
    }

    public void SetupTileEntitys(World world, Random rand, int CordX, int CordY, int CordZ) {
        TileEntity Target = world.func_72796_p(CordX, CordY, CordZ);
        if (Target == null) {
            return;
        }
        if (Target instanceof TileEntityFurnace) {
            return;
        }
        if (Target instanceof TileEntityChest) {
            TileEntityChest Chest = (TileEntityChest)Target;
            ItemStack Tmp = null;
            int Count = rand.nextInt(27);
            for (int i = 1; i <= Count; ++i) {
                Tmp = this.GetRandomContent(rand);
                if (Tmp == null) continue;
                Chest.func_70299_a(rand.nextInt(Chest.func_70302_i_()), Tmp);
            }
        } else if (Target instanceof TileEntityDispenser) {
            if (this.SelfType != EnumShipTypes.Battleship) {
                return;
            }
            TileEntityDispenser Disper = (TileEntityDispenser)Target;
            int Count = rand.nextInt(3);
            for (int i = 1; i <= Count; ++i) {
                ItemStack Tmp = new ItemStack(Item.field_77704_l, rand.nextInt(63) + 1);
                if (Tmp == null) continue;
                Disper.func_70299_a(i, Tmp);
            }
        } else {
            return;
        }
    }

    public ItemStack GetRandomContent(Random rand) {
        int Chance = rand.nextInt(1000);
        switch (this.SelfType) {
            case Science: {
                if (Chance < 100) {
                    return new ItemStack((Item)Item.field_77726_bs, 1, 1 + rand.nextInt(19));
                }
                if (Chance < 200) {
                    return new ItemStack(mod_Fossil.relic, rand.nextInt(63) + 1);
                }
                if (Chance >= 300) break;
                return new ItemStack(mod_Fossil.stoneboard);
            }
            case Battleship: {
                if (Chance < 2) {
                    return new ItemStack(mod_Fossil.AncientJavelin);
                }
                if (Chance <= 35) {
                    return new ItemStack(Block.field_72091_am, rand.nextInt(9) + 1);
                }
                if (Chance < 70) {
                    return new ItemStack(Item.field_77716_q);
                }
                if (Chance < 90) {
                    return new ItemStack(mod_Fossil.Ironjavelin, rand.nextInt(63) + 1);
                }
                if (Chance < 240) {
                    return new ItemStack((Item)Item.field_77707_k);
                }
                if (Chance >= 750) break;
                return new ItemStack(Item.field_77704_l, rand.nextInt(63) + 1);
            }
            case MetalTrader: {
                if (Chance == 0) {
                    return new ItemStack(mod_Fossil.Gen);
                }
                if (Chance <= 10) {
                    return new ItemStack(Block.field_72071_ax);
                }
                if (Chance < 250) {
                    return new ItemStack(Block.field_72083_ai, rand.nextInt(14) + 1);
                }
                if (Chance >= 350) break;
                return new ItemStack(Item.field_77717_p, rand.nextInt(31) + 1);
            }
            default: {
                if (Chance < 15) {
                    return new ItemStack(mod_Fossil.blockSkull);
                }
                if (Chance < 100) {
                    return new ItemStack(Item.field_77764_aP, rand.nextInt(63) + 1);
                }
                if (Chance < 300) {
                    return new ItemStack(Item.field_77754_aU, rand.nextInt(63) + 1);
                }
                if (Chance >= 750) break;
                return new ItemStack(Item.field_77737_bm, rand.nextInt(63) + 1);
            }
        }
        if (Chance == 900) {
            return new ItemStack(Item.field_77750_aQ);
        }
        return null;
    }
}

