/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.ItemIds;
import enhancedportals.lib.Reference;
import enhancedportals.lib.Strings;
import enhancedportals.tileentity.TileEntityAutomaticDialler;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemNetworkCard
extends Item {
    Icon texture;

    public ItemNetworkCard() {
        super(ItemIds.NetworkCard);
        this.field_77787_bX = false;
        this.func_77656_e(0);
        this.func_77637_a(Reference.CREATIVE_TAB);
        this.func_77655_b("networkCard");
        this.field_77777_bU = 1;
    }

    public boolean addData(ItemStack stack, TileEntityPortalModifier modifier) {
        if (this.isSet(stack)) {
            return false;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Network", modifier.modifierNetwork);
        stack.func_77982_d(tagCompound);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        if (this.isSet(itemStack)) {
            String[] network = itemStack.func_77978_p().func_74779_i("Network").split(" ");
            String[] net = new String[9];
            for (int i = 0; i < 9; ++i) {
                net[i] = network.length > i ? network[i] : "";
            }
            list.add(net[0] + " " + net[1] + " " + net[2]);
            if (network.length > 3) {
                list.add(net[3] + " " + net[4] + " " + net[5]);
            }
            if (network.length > 6) {
                list.add(net[6] + " " + net[7] + " " + net[8]);
            }
        } else {
            list.add(Strings.NetworkNotSet.toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return this.isSet(itemStack);
    }

    public boolean isSet(ItemStack stack) {
        return stack.func_77942_o();
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_72798_a(x, y, z) == BlockIds.PortalModifier) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)world.func_72796_p(x, y, z);
            if (!this.isSet(itemStack)) {
                this.addData(itemStack, modifier);
            } else {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                String network = tagCompound.func_74779_i("Network");
                if (!modifier.modifierNetwork.equals(network) && !modifier.isActive()) {
                    modifier.modifierNetwork = network;
                    EnhancedPortals.proxy.ModifierNetwork.removeFromAllNetworks(new WorldPosition(x, y, z, world));
                    EnhancedPortals.proxy.ModifierNetwork.addToNetwork(network, new WorldPosition(x, y, z, world));
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    ((EntityPlayerMP)player).field_71133_b.func_71203_ab().func_72385_f((EntityPlayerMP)player);
                    player.func_71035_c(Strings.ChatNetworkSuccessful.toString());
                } else if (modifier.isActive()) {
                    player.func_71035_c(Strings.ChatModifierActive.toString());
                }
            }
        } else if (world.func_72798_a(x, y, z) == BlockIds.AutomaticDialler) {
            TileEntityAutomaticDialler dial = (TileEntityAutomaticDialler)world.func_72796_p(x, y, z);
            if (!this.isSet(itemStack)) {
                player.func_71035_c(Strings.ChatNotLinked.toString());
            } else {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                String network = tagCompound.func_74779_i("Network");
                if (!dial.activeNetwork.equals(network)) {
                    dial.activeNetwork = network;
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    ((EntityPlayerMP)player).field_71133_b.func_71203_ab().func_72385_f((EntityPlayerMP)player);
                    player.func_71035_c(Strings.ChatNetworkSuccessful.toString());
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.texture = iconRegister.func_94245_a("EP2:networkCard");
    }
}

