/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.lib;

import enhancedportals.lib.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.Configuration;

public class Settings {
    public static Configuration config;
    public static boolean AllowPortalModifiers;
    public static boolean AllowDialHomeDevices;
    public static boolean AllowObsidianStairs;
    public static boolean AllowTeleporting;
    public static boolean AllowFlintSteel;
    public static boolean DisableModifierRecipe;
    public static boolean DisableDDRecipe;
    public static boolean RenderPortalEffect;
    public static boolean AllowPortalColours;
    public static boolean AdventureModeLimitation;
    public static boolean AlternateCraftingRecipe;
    public static boolean UseNewParticleEffects;
    public static boolean RequireFancyGraphicsForParticles;
    public static int PigmenLevel;
    public static int SoundLevel;
    public static int ParticleLevel;
    public static int MinimumPortalSize;
    public static int MaximumPortalSize;
    public static List<Integer> ExcludedBlockList;
    public static List<Integer> BorderBlocks;
    public static List<Integer> DestroyBlocks;
    public static List<Integer> NetherFrameUpgrade;
    public static List<Integer> ResourceFrameUpgrade;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Integer> addToList(List<Integer> list, String str) {
        if (str.contains(" ")) {
            String[] strs;
            for (String s : strs = str.split(" ")) {
                try {
                    int i = Integer.parseInt(s);
                    if (list.contains(i)) continue;
                    list.add(i);
                }
                catch (Exception e) {
                    Reference.log.log(Level.WARNING, String.format("'%s' isn't a valid block ID", s));
                }
            }
            return list;
        } else {
            if (str.length() <= 0) return list;
            try {
                int i = Integer.parseInt(str);
                if (list.contains(i)) return list;
                list.add(i);
                return list;
            }
            catch (Exception e) {
                Reference.log.log(Level.WARNING, String.format("'%s' isn't a valid block ID", str));
            }
        }
        return list;
    }

    public static boolean canUse(EntityPlayer player) {
        return player.field_71075_bZ.field_75099_e && AdventureModeLimitation;
    }

    public static boolean isBlockExcluded(int id) {
        for (int i : ExcludedBlockList) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    public static void setConfigOption(String category, String property, boolean val) {
        config.load();
        if (config.getCategoryNames().contains(category) && config.getCategory(category).containsKey(property)) {
            config.getCategory(category).get(property).set(val);
        }
        config.save();
    }

    public static void setConfigOption(String category, String property, int val) {
        config.load();
        if (config.getCategoryNames().contains(category) && config.getCategory(category).containsKey(property)) {
            config.getCategory(category).get(property).set(val);
        }
        config.save();
    }

    static {
        AllowPortalModifiers = true;
        AllowDialHomeDevices = true;
        AllowObsidianStairs = true;
        AllowTeleporting = true;
        AllowFlintSteel = true;
        DisableModifierRecipe = false;
        DisableDDRecipe = false;
        RenderPortalEffect = true;
        AllowPortalColours = true;
        AdventureModeLimitation = true;
        AlternateCraftingRecipe = false;
        UseNewParticleEffects = true;
        RequireFancyGraphicsForParticles = true;
        PigmenLevel = 100;
        SoundLevel = 100;
        ParticleLevel = 100;
        MinimumPortalSize = 0;
        MaximumPortalSize = 0;
        ExcludedBlockList = new ArrayList<Integer>();
        BorderBlocks = new ArrayList<Integer>();
        DestroyBlocks = new ArrayList<Integer>();
        NetherFrameUpgrade = new ArrayList<Integer>();
        ResourceFrameUpgrade = new ArrayList<Integer>();
    }
}

