/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.tileentity.TileEntityDialDevice;
import enhancedportals.tileentity.TileEntityDialDeviceBasic;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.world.World;

public class PacketDialRequest
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    String network;

    public PacketDialRequest() {
    }

    public PacketDialRequest(TileEntityEnhancedPortals dialDevice, String diallingNetwork) {
        this.position = dialDevice.getBlockPosition();
        this.dimension = dialDevice.field_70331_k.field_73011_w.field_76574_g;
        this.network = diallingNetwork;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.network = stream.readUTF();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        World world = EnhancedPortals.proxy.getWorld(this.dimension);
        if (!world.field_72995_K) {
            if (WorldHelper.getBlockId((World)world, (BlockPosition)this.position) == BlockIds.DialDeviceBasic) {
                if (WorldHelper.getTileEntity((World)world, (BlockPosition)this.position) instanceof TileEntityDialDeviceBasic) {
                    TileEntityDialDeviceBasic device = (TileEntityDialDeviceBasic)WorldHelper.getTileEntity((World)world, (BlockPosition)this.position);
                    device.processDiallingRequest(this.network, player);
                }
            } else if (WorldHelper.getBlockId((World)world, (BlockPosition)this.position) == BlockIds.DialDevice && WorldHelper.getTileEntity((World)world, (BlockPosition)this.position) instanceof TileEntityDialDevice) {
                TileEntityDialDevice device = (TileEntityDialDevice)WorldHelper.getTileEntity((World)world, (BlockPosition)this.position);
                device.processDiallingRequest(Integer.parseInt(this.network), player);
            }
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.network});
    }
}

