/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;

public class PacketGui
extends PacketEnhancedPortals {
    int dimension;
    int guiID;
    BlockPosition position;

    public PacketGui() {
    }

    public PacketGui(int x, int y, int z, int d, int gui) {
        this.position = new BlockPosition(x, y, z);
        this.dimension = d;
        this.guiID = gui;
    }

    public PacketGui(int x, int y, int z, World world, int gui) {
        this.position = new BlockPosition(x, y, z);
        this.dimension = world.field_73011_w.field_76574_g;
        this.guiID = gui;
    }

    public PacketGui(TileEntityEnhancedPortals tileEntity, int gui) {
        this.position = tileEntity.getBlockPosition();
        this.dimension = tileEntity.field_70331_k.field_73011_w.field_76574_g;
        this.guiID = gui;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.guiID = stream.readInt();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        player.openGui((Object)EnhancedPortals.instance, this.guiID, EnhancedPortals.proxy.getWorld(this.dimension), this.position.getX(), this.position.getY(), this.position.getZ());
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketDispatcher.sendPacketToPlayer((Packet)PacketEnhancedPortals.makePacket(this), (Player)((Player)player));
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.guiID});
    }
}

