/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.portal.upgrades.Upgrade;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.tileentity.TileEntity;

public class PacketPortalModifierUpgrade
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    byte[] upgrades;

    public PacketPortalModifierUpgrade() {
    }

    public PacketPortalModifierUpgrade(TileEntityPortalModifier modifier) {
        this.position = modifier.getBlockPosition();
        this.dimension = modifier.field_70331_k.field_73011_w.field_76574_g;
        this.upgrades = modifier.upgradeHandler.getInstalledUpgrades();
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.upgrades = new byte[stream.readInt()];
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = stream.readByte();
        }
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.PortalModifier && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityPortalModifier) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
            if (WorldHelper.getWorld((int)this.dimension).field_72995_K) {
                modifier.upgradeHandler.addUpgradesFromByteArray(this.upgrades, modifier);
                WorldHelper.markBlockForUpdate((int)this.dimension, (BlockPosition)this.position);
            } else {
                LinkedList<Byte> upgradeList = new LinkedList<Byte>();
                for (byte b : modifier.upgradeHandler.getInstalledUpgrades()) {
                    upgradeList.add(b);
                }
                for (byte b : this.upgrades) {
                    if (modifier.upgradeHandler.hasUpgrade(b)) {
                        upgradeList.remove((Object)b);
                        continue;
                    }
                    modifier.upgradeHandler.addUpgrade(b, (TileEntity)modifier);
                }
                while (!upgradeList.isEmpty()) {
                    byte upgradeID = (Byte)upgradeList.remove();
                    EntityItem entity = new EntityItem(WorldHelper.getWorld((int)this.dimension), (double)this.position.getX() + 0.5, (double)this.position.getY() + 0.5, (double)this.position.getZ() + 0.5, Upgrade.getUpgrade(upgradeID).getItemStack());
                    WorldHelper.getWorld((int)this.dimension).func_72838_d((Entity)entity);
                    for (int i = 0; i < modifier.upgradeHandler.getUpgrades().size(); ++i) {
                        if (modifier.upgradeHandler.getUpgrades().get(i).getUpgradeID() != upgradeID) continue;
                        modifier.upgradeHandler.getUpgrades().remove(i);
                    }
                }
            }
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.upgrades});
    }
}

