/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.Reference;
import enhancedportals.lib.Settings;
import enhancedportals.lib.Strings;
import enhancedportals.lib.Textures;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketNetherPortalUpdate;
import enhancedportals.portal.teleportation.TeleportManager;
import enhancedportals.portal.upgrades.modifier.UpgradeDimensional;
import enhancedportals.portal.upgrades.modifier.UpgradeMomentum;
import enhancedportals.portal.upgrades.modifier.UpgradeParticles;
import enhancedportals.portal.upgrades.modifier.UpgradeSounds;
import enhancedportals.tileentity.TileEntityNetherPortal;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Portal {
    WorldPosition portalModifier;
    WorldPosition position;
    public byte shape;
    public byte thickness;
    public boolean producesSound;
    public boolean producesParticles;
    public String texture;

    public Portal() {
    }

    public Portal(int x, int y, int z, World world) {
        TileEntity te;
        this.position = new WorldPosition(x, y, z, world);
        this.shape = 0;
        if (world.func_72798_a(x, y, z) == BlockIds.NetherPortal && (te = world.func_72796_p(x, y, z)) instanceof TileEntityNetherPortal) {
            TileEntityNetherPortal portal = (TileEntityNetherPortal)te;
            this.texture = portal.texture;
            this.producesParticles = portal.producesParticles;
            this.producesSound = portal.producesSound;
            this.thickness = portal.thickness;
            return;
        }
        this.texture = "";
        this.thickness = 0;
        this.producesParticles = true;
        this.producesSound = true;
        this.findPortalShape();
    }

    public Portal(TileEntityPortalModifier modifier) {
        WorldPosition loc = new WorldPosition(modifier.field_70329_l, modifier.field_70330_m, modifier.field_70327_n, modifier.field_70331_k);
        this.position = loc.getOffset(ForgeDirection.getOrientation((int)loc.getMetadata()));
        this.shape = 0;
        this.texture = modifier.texture;
        this.producesParticles = !modifier.upgradeHandler.hasUpgrade(new UpgradeParticles());
        this.producesSound = !modifier.upgradeHandler.hasUpgrade(new UpgradeSounds());
        this.portalModifier = loc;
        this.thickness = modifier.thickness;
        this.findPortalShape();
    }

    public boolean createPortal() {
        return this.createPortal(1, 0);
    }

    public boolean createPortal(int minLimit, int maxLimit) {
        if (this.position.getWorld().field_72995_K || !this.preChecks() || !this.findPortalShape()) {
            return false;
        }
        if (Settings.MinimumPortalSize > 0) {
            minLimit = Settings.MinimumPortalSize;
        }
        if (Settings.MaximumPortalSize > 0) {
            maxLimit = Settings.MaximumPortalSize;
        }
        Queue<WorldPosition> queue = new LinkedList<WorldPosition>();
        LinkedList<WorldPosition> addedBlocks = new LinkedList<WorldPosition>();
        int usedChances = 0;
        int MAX_CHANCES = 10;
        queue.add(this.position);
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            if (!this.isBlockRemovable(current)) continue;
            int sides = this.getSides(current);
            if (sides == -1) {
                this.removePortal(addedBlocks);
                return false;
            }
            if (sides < 2 && usedChances < MAX_CHANCES) {
                ++usedChances;
                sides += 2;
            }
            if (sides < 2) continue;
            addedBlocks.add(current);
            current.setBlock(BlockIds.NetherPortal, addedBlocks.size() == 1 ? this.shape + 1 : this.shape, 3);
            queue = this.updateQueue(queue, current);
            TileEntity te = current.getTileEntity();
            if (te == null || !(te instanceof TileEntityNetherPortal)) continue;
            TileEntityNetherPortal portal = (TileEntityNetherPortal)te;
            portal.texture = this.texture;
            portal.producesParticles = this.producesParticles;
            portal.producesSound = this.producesSound;
            portal.thickness = this.thickness;
            if (this.portalModifier == null) continue;
            portal.setParentModifier(this.portalModifier);
        }
        if (!this.validatePortal(addedBlocks)) {
            return false;
        }
        if (addedBlocks.size() < minLimit) {
            this.removePortal(addedBlocks);
            return false;
        }
        if (maxLimit != 0 && addedBlocks.size() > maxLimit) {
            this.removePortal(addedBlocks);
            return false;
        }
        return true;
    }

    public boolean createPortal(int[] extraBorderBlocks) {
        if (extraBorderBlocks == null || extraBorderBlocks.length == 0) {
            return this.createPortal();
        }
        int size = Settings.BorderBlocks.size();
        for (int i : extraBorderBlocks) {
            Settings.BorderBlocks.add(i);
        }
        boolean status = this.createPortal();
        for (int i = size; i < Settings.BorderBlocks.size(); ++i) {
            Settings.BorderBlocks.remove(i);
        }
        return status;
    }

    public boolean createPortal(int[] extraBorderBlocks, ItemStack stack) {
        if (extraBorderBlocks == null || extraBorderBlocks.length == 0) {
            return this.createPortal(stack);
        }
        int size = Settings.BorderBlocks.size();
        for (int i : extraBorderBlocks) {
            Settings.BorderBlocks.add(i);
        }
        boolean status = this.createPortal(stack);
        for (int i = size; i < Settings.BorderBlocks.size(); ++i) {
            Settings.BorderBlocks.remove(i);
        }
        return status;
    }

    public boolean createPortal(ItemStack stack) {
        if (stack.field_77993_c == Item.field_77709_i.field_77779_bT) {
            return Settings.AllowFlintSteel ? this.createPortal(6, 6) : this.createPortal(1, 0);
        }
        if (stack.field_77993_c == EnhancedPortals.proxy.itemEnhancedFlintSteel.field_77779_bT) {
            return this.createPortal(1, 0);
        }
        return false;
    }

    public boolean createPortal(String texture, byte thickness, int[] extraBorderBlocks) {
        this.texture = texture;
        this.thickness = thickness;
        return this.createPortal(extraBorderBlocks);
    }

    private boolean findPortalShape() {
        if (this.shape >= 2 && this.shape <= 7) {
            return true;
        }
        if (this.position.getBlockId() == BlockIds.NetherPortal) {
            this.shape = (byte)this.position.getMetadata();
            if (this.shape == 3 || this.shape == 5 || this.shape == 7) {
                this.shape = (byte)(this.shape - 1);
                return true;
            }
            return this.shape == 2 || this.shape == 4 || this.shape == 6;
        }
        this.shape = this.ghostPortal();
        if (this.shape == -1) {
            this.shape = 0;
            return false;
        }
        return true;
    }

    private int getSides(WorldPosition location) {
        int totalSides = 0;
        WorldPosition[] allBlocks = new WorldPosition[4];
        if (this.shape == 6) {
            allBlocks[0] = location.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = location.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = location.getOffset(ForgeDirection.EAST);
            allBlocks[3] = location.getOffset(ForgeDirection.WEST);
        } else if (this.shape == 2) {
            allBlocks[0] = location.getOffset(ForgeDirection.WEST);
            allBlocks[1] = location.getOffset(ForgeDirection.EAST);
            allBlocks[2] = location.getOffset(ForgeDirection.UP);
            allBlocks[3] = location.getOffset(ForgeDirection.DOWN);
        } else if (this.shape == 4) {
            allBlocks[0] = location.getOffset(ForgeDirection.NORTH);
            allBlocks[1] = location.getOffset(ForgeDirection.SOUTH);
            allBlocks[2] = location.getOffset(ForgeDirection.UP);
            allBlocks[3] = location.getOffset(ForgeDirection.DOWN);
        }
        for (WorldPosition val : allBlocks) {
            if (this.isBlockFrame(val.getBlockId(), true)) {
                ++totalSides;
                continue;
            }
            if (this.isBlockRemovable(val)) continue;
            return -1;
        }
        return totalSides;
    }

    private byte ghostPortal() {
        if (this.ghostPortal(2)) {
            return 2;
        }
        if (this.ghostPortal(4)) {
            return 4;
        }
        if (this.ghostPortal(6)) {
            return 6;
        }
        return -1;
    }

    private boolean ghostPortal(int theShape) {
        this.shape = (byte)theShape;
        if (this.position.getWorld().field_72995_K || !this.preChecks()) {
            return false;
        }
        Queue<WorldPosition> queue = new LinkedList<WorldPosition>();
        LinkedList<WorldPosition> addedBlocks = new LinkedList<WorldPosition>();
        int usedChances = 0;
        int MAX_CHANCES = 10;
        queue.add(this.position);
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            if (!this.isBlockRemovable(current) || this.queueContains(addedBlocks, current)) continue;
            int sides = this.getSides(current);
            if (sides == -1) {
                this.removePortal(addedBlocks);
                return false;
            }
            if (sides < 2 && usedChances < MAX_CHANCES) {
                ++usedChances;
                sides += 2;
            }
            if (sides < 2) continue;
            addedBlocks.add(current);
            queue = this.updateQueue(queue, current);
        }
        return true;
    }

    public boolean handleBlockActivation(EntityPlayer player) {
        if (this.position.getWorld().field_72995_K) {
            return false;
        }
        ItemStack item = player.func_71045_bC();
        int dyeColour = Textures.getDyeColour(item);
        if (dyeColour >= 0) {
            if (this.updateTexture("C:" + dyeColour) && !player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private void handleDialDeviceTeleportation(Entity entity, TileEntityPortalModifier modifier) {
        WorldPosition exitLocation = EnhancedPortals.proxy.DialDeviceNetwork.getNetwork(modifier.tempDialDeviceNetwork).get(0);
        if (exitLocation == null || exitLocation.equals((Object)this.position)) {
            return;
        }
        if (this.upgradeCheck(modifier, modifier.field_70331_k.field_73011_w.field_76574_g, exitLocation.getDimension())) {
            TeleportManager.teleportEntity(entity, exitLocation, modifier, modifier.upgradeHandler.hasUpgrade(new UpgradeMomentum()), false);
            TeleportManager.setCanEntityTravel(entity, false);
        } else if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71035_c(Strings.ChatMissingUpgrade.toString());
        }
    }

    public void handleEntityCollide(Entity entity) {
        if (!(this.position.getTileEntity() instanceof TileEntityNetherPortal)) {
            return;
        }
        TileEntityNetherPortal portal = (TileEntityNetherPortal)this.position.getTileEntity();
        if (this.position.getWorld().field_72995_K) {
            if (Settings.RenderPortalEffect && !portal.texture.equals("I:" + Item.field_82792_bS.field_77779_bT + ":0")) {
                entity.func_70063_aa();
            }
            return;
        }
        if (portal.getParentModifier() == null) {
            this.handleVanillaTeleportation(entity, this.position.getWorld());
            return;
        }
        if (portal.getParentModifier() != null && entity.field_71088_bW == 0) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)portal.getParentModifier().getTileEntity();
            if (modifier == null) {
                return;
            }
            if (modifier.isRemotelyControlled()) {
                if (modifier.tempDialDeviceNetwork.equals("")) {
                    Reference.log.log(Level.WARNING, "Created a portal from a Dialling Device, but modifier doesn't have a network?");
                } else {
                    this.handleDialDeviceTeleportation(entity, modifier);
                }
            } else {
                if (modifier == null || modifier.modifierNetwork.equals("")) {
                    this.handleVanillaTeleportation(entity, this.position.getWorld());
                    return;
                }
                this.handleModifierTeleportation(entity, modifier);
            }
        }
        TeleportManager.setCanEntityTravel(entity, false);
    }

    private void handleModifierTeleportation(Entity entity, TileEntityPortalModifier modifier) {
        List<WorldPosition> validLocations = EnhancedPortals.proxy.ModifierNetwork.getNetworkExcluding(modifier.modifierNetwork, new WorldPosition(modifier.field_70329_l, modifier.field_70330_m, modifier.field_70327_n, modifier.field_70331_k));
        boolean missingUpgrade = false;
        boolean teleport = false;
        if (validLocations.isEmpty()) {
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71035_c(Strings.ChatNoLinkedPortals.toString());
            }
            TeleportManager.setCanEntityTravel(entity, false);
            return;
        }
        while (!validLocations.isEmpty()) {
            WorldPosition randomLocation = validLocations.remove(new Random().nextInt(validLocations.size()));
            if (!this.upgradeCheck(modifier, modifier.field_70331_k.field_73011_w.field_76574_g, randomLocation.getDimension())) {
                missingUpgrade = true;
                continue;
            }
            if (!TeleportManager.teleportEntity(entity, randomLocation, modifier, modifier.upgradeHandler.hasUpgrade(new UpgradeMomentum()), validLocations.size() <= 1)) continue;
            teleport = true;
            validLocations.clear();
        }
        if (missingUpgrade && !teleport && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71035_c(Strings.ChatMissingUpgrade.toString());
        }
    }

    public void handleNeighborChange(int id) {
        if (this.position.getWorld().field_72995_K || id == 0 || !this.findPortalShape()) {
            return;
        }
        if (this.shape == 2 || this.shape == 3) {
            if (this.position.getOffset(ForgeDirection.EAST).isAirBlock() || this.position.getOffset(ForgeDirection.WEST).isAirBlock() || this.position.getOffset(ForgeDirection.UP).isAirBlock() || this.position.getOffset(ForgeDirection.DOWN).isAirBlock()) {
                this.removePortal();
            }
        } else if (this.shape == 4 || this.shape == 5) {
            if (this.position.getOffset(ForgeDirection.NORTH).isAirBlock() || this.position.getOffset(ForgeDirection.SOUTH).isAirBlock() || this.position.getOffset(ForgeDirection.UP).isAirBlock() || this.position.getOffset(ForgeDirection.DOWN).isAirBlock()) {
                this.removePortal();
            }
        } else if ((this.shape == 6 || this.shape == 7) && (this.position.getOffset(ForgeDirection.EAST).isAirBlock() || this.position.getOffset(ForgeDirection.WEST).isAirBlock() || this.position.getOffset(ForgeDirection.NORTH).isAirBlock() || this.position.getOffset(ForgeDirection.SOUTH).isAirBlock())) {
            this.removePortal();
        }
    }

    private void handleVanillaTeleportation(Entity entity, World world) {
        if (world.field_73011_w.field_76574_g > 0 || world.field_73011_w.field_76574_g < -1) {
            return;
        }
        entity.func_70063_aa();
    }

    public boolean isBlockFrame(int val, boolean includeSelf) {
        if (includeSelf && val == BlockIds.NetherPortal) {
            return true;
        }
        for (int i : Settings.BorderBlocks) {
            if (i != val) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockFrame(int val, int[] extraIds) {
        if (!this.isBlockFrame(val, false)) {
            if (extraIds == null || extraIds.length == 0) {
                return false;
            }
            for (int i : extraIds) {
                if (i != val) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isBlockRemovable(WorldPosition pos) {
        if (pos.isAirBlock()) {
            return true;
        }
        int val = pos.getBlockId();
        for (int i : Settings.DestroyBlocks) {
            if (i != val) continue;
            return true;
        }
        return false;
    }

    private boolean preChecks() {
        if (this.position.getWorld().field_72995_K) {
            return false;
        }
        if (this.isBlockRemovable(this.position)) {
            return this.shape != 2 && this.shape != 4 || !this.position.canBlockSeeTheSky();
        }
        return false;
    }

    private boolean queueContains(Queue<WorldPosition> queue, WorldPosition loc) {
        for (WorldPosition queueLoc : queue) {
            if (!queueLoc.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public boolean removePortal() {
        if (this.position.getWorld().field_72995_K || this.position.getBlockId() != BlockIds.NetherPortal || !this.findPortalShape()) {
            return false;
        }
        Queue<WorldPosition> queue = new LinkedList<WorldPosition>();
        queue.add(this.position);
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            if (current.getBlockId() != BlockIds.NetherPortal) continue;
            current.setBlockToAir();
            queue = this.updateQueue(queue, current);
        }
        return true;
    }

    private void removePortal(Queue<WorldPosition> addedBlocks) {
        while (!addedBlocks.isEmpty()) {
            WorldPosition current = addedBlocks.remove();
            current.setBlockToAir();
        }
    }

    public boolean updateData(boolean sound, boolean particles, byte thickness) {
        if (this.position.getBlockId() != BlockIds.NetherPortal || !this.findPortalShape() || this.producesSound == sound && this.producesParticles == particles && this.thickness == thickness) {
            return false;
        }
        LinkedList<WorldPosition> queue = new LinkedList<WorldPosition>();
        LinkedList<WorldPosition> addedBlocks = new LinkedList<WorldPosition>();
        queue.add(this.position);
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            TileEntity te = current.getTileEntity();
            if (te == null || !(te instanceof TileEntityNetherPortal) || this.queueContains(addedBlocks, current)) continue;
            TileEntityNetherPortal portal = (TileEntityNetherPortal)te;
            portal.producesSound = sound;
            portal.producesParticles = particles;
            portal.thickness = thickness;
            current.markBlockForUpdate();
            addedBlocks.add(current);
            this.updateQueue(queue, current);
            if (current.getMetadata() != 3 && current.getMetadata() != 5 && current.getMetadata() != 7 || FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) continue;
            PacketDispatcher.sendPacketToAllAround((double)((double)this.position.getX() + 0.5), (double)((double)this.position.getY() + 0.5), (double)((double)this.position.getZ() + 0.5), (double)256.0, (int)this.position.getWorld().field_73011_w.field_76574_g, (Packet)PacketEnhancedPortals.makePacket(new PacketNetherPortalUpdate((TileEntityNetherPortal)te)));
        }
        return true;
    }

    private Queue<WorldPosition> updateQueue(Queue<WorldPosition> queue, WorldPosition location) {
        if (this.shape == 2) {
            queue.add(location.getOffset(ForgeDirection.UP));
            queue.add(location.getOffset(ForgeDirection.DOWN));
            queue.add(location.getOffset(ForgeDirection.EAST));
            queue.add(location.getOffset(ForgeDirection.WEST));
        } else if (this.shape == 4) {
            queue.add(location.getOffset(ForgeDirection.UP));
            queue.add(location.getOffset(ForgeDirection.DOWN));
            queue.add(location.getOffset(ForgeDirection.NORTH));
            queue.add(location.getOffset(ForgeDirection.SOUTH));
        } else if (this.shape == 6) {
            queue.add(location.getOffset(ForgeDirection.NORTH));
            queue.add(location.getOffset(ForgeDirection.SOUTH));
            queue.add(location.getOffset(ForgeDirection.EAST));
            queue.add(location.getOffset(ForgeDirection.WEST));
        }
        return queue;
    }

    public boolean updateTexture(String newTexture) {
        if (this.position.getBlockId() != BlockIds.NetherPortal || !this.findPortalShape() || this.texture.equals(newTexture)) {
            return false;
        }
        LinkedList<WorldPosition> queue = new LinkedList<WorldPosition>();
        LinkedList<WorldPosition> addedBlocks = new LinkedList<WorldPosition>();
        queue.add(this.position);
        this.texture = newTexture;
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            TileEntity te = current.getTileEntity();
            if (te == null || !(te instanceof TileEntityNetherPortal) || this.queueContains(addedBlocks, current)) continue;
            ((TileEntityNetherPortal)te).texture = this.texture;
            current.markBlockForUpdate();
            addedBlocks.add(current);
            this.updateQueue(queue, current);
            if (current.getMetadata() != 3 && current.getMetadata() != 5 && current.getMetadata() != 7 || FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) continue;
            PacketDispatcher.sendPacketToAllAround((double)((double)this.position.getX() + 0.5), (double)((double)this.position.getY() + 0.5), (double)((double)this.position.getZ() + 0.5), (double)256.0, (int)this.position.getWorld().field_73011_w.field_76574_g, (Packet)PacketEnhancedPortals.makePacket(new PacketNetherPortalUpdate((TileEntityNetherPortal)te)));
        }
        return true;
    }

    private boolean upgradeCheck(TileEntityPortalModifier modifier, int entryDimension, int exitDimension) {
        boolean hasUpgrade = modifier.upgradeHandler.hasUpgrade(new UpgradeDimensional());
        if (!(exitDimension != -1 && exitDimension != 0 && exitDimension != 1 || hasUpgrade || exitDimension == -1 && entryDimension == 0 || exitDimension == 0 && entryDimension == -1)) {
            return false;
        }
        if (exitDimension == entryDimension && !hasUpgrade) {
            return false;
        }
        return exitDimension <= 1 && exitDimension >= -1 || hasUpgrade;
    }

    private boolean validatePortal(Queue<WorldPosition> addedBlocks) {
        if (this.position.getWorld().field_72995_K) {
            return true;
        }
        Queue<WorldPosition> queue = new LinkedList<WorldPosition>();
        LinkedList<WorldPosition> checkedQueue = new LinkedList<WorldPosition>();
        queue.add(this.position);
        while (!queue.isEmpty()) {
            WorldPosition current = (WorldPosition)queue.remove();
            if (current.getBlockId() != BlockIds.NetherPortal || this.queueContains(checkedQueue, current)) continue;
            int sides = this.getSides(current);
            if (sides != 4) {
                this.removePortal(addedBlocks);
                return false;
            }
            queue = this.updateQueue(queue, current);
            checkedQueue.add(current);
        }
        return true;
    }
}

