/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tileentity;

import cpw.mods.fml.common.network.PacketDispatcher;
import enhancedcore.world.BlockPosition;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketDialDeviceUpdate;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.portal.network.DialDeviceNetworkObject;
import enhancedportals.tileentity.TileEntityDialDeviceBase;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;

public class TileEntityDialDevice
extends TileEntityDialDeviceBase {
    public ArrayList<DialDeviceNetworkObject> destinationList = new ArrayList();
    public int selectedDestination = -1;
    public int tickTimer;

    public TileEntityDialDevice() {
        this.active = false;
        this.tickTimer = 720;
    }

    @Override
    protected int getBlockID() {
        return BlockIds.DialDevice;
    }

    public boolean hasDestination(DialDeviceNetworkObject obj2) {
        for (DialDeviceNetworkObject obj : this.destinationList) {
            if (!obj.displayName.equals(obj2.displayName) || !obj.texture.equals(obj2.texture) || !obj.network.equals(obj2.network) || obj.thickness != obj2.thickness) continue;
            return true;
        }
        return false;
    }

    public void processDiallingRequest(int id, EntityPlayer player) {
        DialDeviceNetworkObject obj = this.destinationList.get(id);
        this.processDiallingRequest(obj.network, player, obj.texture, obj.thickness, this.tickTimer);
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.timer = tagCompound.func_74762_e("TickTimer");
        if (tagCompound.func_74764_b("mX")) {
            this.active = true;
            this.modifierLocation = new BlockPosition(tagCompound.func_74762_e("mX"), tagCompound.func_74762_e("mY"), tagCompound.func_74762_e("mZ"));
            this.timer = tagCompound.func_74762_e("Timer");
            this.ticksToGo = tagCompound.func_74762_e("TicksToGo");
            this.dialledNetwork = tagCompound.func_74779_i("DialledNetwork");
        }
        NBTTagList list = tagCompound.func_74761_m("Entries");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)list.func_74743_b(i);
            String name = tag.func_74779_i("Name");
            String network = tag.func_74779_i("Network");
            byte thickness = tag.func_74771_c("Thickness");
            String texture = tag.func_74779_i("Texture");
            this.destinationList.add(new DialDeviceNetworkObject(name, network, texture, thickness));
        }
    }

    public boolean removeDestination(DialDeviceNetworkObject obj2) {
        for (int i = 0; i < this.destinationList.size(); ++i) {
            DialDeviceNetworkObject obj = this.destinationList.get(i);
            if (!obj.displayName.equals(obj2.displayName) || !obj.texture.equals(obj2.texture) || !obj.network.equals(obj2.network) || obj.thickness != obj2.thickness) continue;
            this.destinationList.remove(i);
            return true;
        }
        return false;
    }

    @Override
    protected void sendUpdatePacket() {
        PacketDispatcher.sendPacketToAllAround((double)((double)this.field_70329_l + 0.5), (double)((double)this.field_70330_m + 0.5), (double)((double)this.field_70327_n + 0.5), (double)128.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)PacketEnhancedPortals.makePacket(new PacketDialDeviceUpdate(this)));
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        tagCompound.func_74768_a("TickTimer", this.tickTimer);
        if (this.active) {
            tagCompound.func_74768_a("mX", this.modifierLocation.getX());
            tagCompound.func_74768_a("mY", this.modifierLocation.getY());
            tagCompound.func_74768_a("mZ", this.modifierLocation.getZ());
            tagCompound.func_74768_a("Timer", this.timer);
            tagCompound.func_74768_a("TicksToGo", this.ticksToGo);
            tagCompound.func_74778_a("DialledNetwork", this.dialledNetwork);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.destinationList.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            DialDeviceNetworkObject obj = this.destinationList.get(i);
            if (obj == null) continue;
            tag.func_74778_a("Name", obj.displayName);
            tag.func_74778_a("Network", obj.network);
            tag.func_74774_a("Thickness", obj.thickness);
            tag.func_74778_a("Texture", obj.texture);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Entries", (NBTBase)list);
    }
}

