/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.world;

import cpw.mods.fml.common.IWorldGenerator;
import enhancedportals.lib.BlockIds;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class RuinsGenerator
implements IWorldGenerator {
    public int GENERATION_CHANCE = 10;
    private String[][][] smallStructures = new String[][][]{{{"49 49 49 49 49"}, {"49 PORTAL:4 PORTAL:5 PORTAL:4 49"}, {"49 PORTAL:4 PORTAL:4 PORTAL:4 49"}, {"49 49 49 49 49"}}};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == -1) {
            this.generateNether(world, random, chunkX * 16, chunkZ * 16);
        } else if (world.field_73011_w.field_76574_g == 0) {
            this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
        } else if (world.field_73011_w.field_76574_g > 1) {
            this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateNether(World world, Random rand, int x, int z) {
    }

    private void generateOverworld(World world, Random rand, int x, int z) {
        if (rand.nextInt(this.GENERATION_CHANCE) != 0) {
            return;
        }
        this.generateStructure(this.smallStructures[0], world, x, 100, z);
    }

    private void generateStructure(String[][] string, World world, int xCoord, int yCoord, int zCoord) {
        for (int y = 0; y < string.length; ++y) {
            for (int x = 0; x < string[y].length; ++x) {
                String[] blocks;
                int z = 0;
                int blockID = 0;
                int blockMeta = 0;
                for (String str : blocks = string[y][x].split(" ")) {
                    if (str.contains(":")) {
                        String s = str.split(":")[0];
                        if (s.equals("PORTAL")) {
                            s = "" + BlockIds.NetherPortal;
                        }
                        blockID = Integer.parseInt(s);
                        blockMeta = Integer.parseInt(str.split(":")[1]);
                    } else {
                        blockID = Integer.parseInt(str);
                        blockMeta = 0;
                    }
                    world.func_72832_d(xCoord + x, yCoord + y, zCoord + z, blockID, blockMeta, 0);
                    ++z;
                }
            }
        }
    }
}

