/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tmechworks.TMechworks;
import tmechworks.blocks.logic.AdvancedDrawbridgeLogic;
import tmechworks.blocks.logic.DrawbridgeLogic;
import tmechworks.blocks.logic.FirestarterLogic;
import tmechworks.client.block.MachineRender;
import tmechworks.common.CommonProxy;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.blocks.InventoryBlock;
import tmechworks.lib.blocks.InventoryLogic;
import tmechworks.lib.util.CoordTuple;

public class RedstoneMachine
extends InventoryBlock {
    static ArrayList<CoordTuple> directions = new ArrayList(6);

    public RedstoneMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71849_a(TMechworksRegistry.Mechworks);
        this.func_71848_c(12.0f);
        this.func_71884_a(field_71977_i);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0 || world.func_72805_g(x, y, z) == 2) {
            ItemStack stack;
            TileEntity logic = world.func_72796_p(x, y, z);
            if (logic != null && logic instanceof DrawbridgeLogic && ((DrawbridgeLogic)logic).func_70301_a(1) != null) {
                stack = ((DrawbridgeLogic)logic).func_70301_a(1);
                if (stack.field_77993_c < 4096 && Block.field_71973_m[stack.field_77993_c] != null) {
                    return field_71984_q[stack.field_77993_c];
                }
            }
            if (logic != null && logic instanceof AdvancedDrawbridgeLogic && ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack() != null) {
                stack = ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack();
                if (stack.field_77993_c < 4096 && Block.field_71973_m[stack.field_77993_c] != null) {
                    return field_71984_q[stack.field_77993_c];
                }
            }
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0 && world.func_72805_g(x, y, z) == 2) {
            ItemStack stack;
            TileEntity logic = world.func_72796_p(x, y, z);
            if (logic != null && logic instanceof DrawbridgeLogic) {
                ItemStack stack2 = ((DrawbridgeLogic)logic).func_70301_a(1);
                if (stack2 != null && stack2.field_77993_c < 4096 && Block.field_71973_m[stack2.field_77993_c] != null && stack2.field_77993_c != this.field_71990_ca) {
                    return Block.field_71973_m[stack2.field_77993_c].func_71920_b(world, x, y, z);
                }
            } else if (logic != null && logic instanceof AdvancedDrawbridgeLogic && (stack = ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack()) != null && stack.field_77993_c < 4096 && Block.field_71973_m[stack.field_77993_c] != null && stack.field_77993_c != this.field_71990_ca) {
                return Block.field_71973_m[stack.field_77993_c].func_71920_b(world, x, y, z);
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new DrawbridgeLogic();
            }
            case 1: {
                return new FirestarterLogic();
            }
            case 2: {
                return new AdvancedDrawbridgeLogic();
            }
            case 3: {
                DrawbridgeLogic logic = new DrawbridgeLogic();
                logic.setMaximumExtension((byte)64);
                return logic;
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: 
            case 3: {
                return CommonProxy.drawbridgeID;
            }
            case 2: {
                return CommonProxy.advDrawbridgeID;
            }
        }
        return null;
    }

    @Override
    public Object getModInstance() {
        return TMechworks.instance;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"drawbridge_top", "drawbridge_side", "drawbridge_bottom", "drawbridge_top_face", "drawbridge_side_face", "drawbridge_bottom_face", "firestarter_top", "firestarter_side", "firestarter_bottom", "drawbridge_side_advanced", "drawbridge_top_extended", "drawbridge_side_extended", "drawbridge_bottom_extended", "drawbridge_top_face_extended", "drawbridge_side_face_extended", "drawbridge_bottom_face_extended"};
        return textureNames;
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tmechworks:machines/" + textureNames[i]);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            return this.icons[this.getTextureIndex(side) + 6];
        }
        if (meta == 2) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side, true)];
        }
        if (meta == 3) {
            if (side == 5) {
                return this.icons[13];
            }
            return this.icons[this.getTextureIndex(side) + 10];
        }
        return this.icons[0];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 3) {
            Block block;
            int offset = meta == 0 ? 0 : 10;
            DrawbridgeLogic drawbridge = (DrawbridgeLogic)logic;
            ItemStack stack = drawbridge.func_70301_a(1);
            if (stack != null && stack.field_77993_c < 4096 && (block = Block.field_71973_m[stack.field_77993_c]) != null && block.func_71886_c()) {
                return block.func_71858_a(side, stack.func_77960_j());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3 + offset];
            }
            return this.icons[this.getTextureIndex(side) + offset];
        }
        if (meta == 2) {
            Block block;
            AdvancedDrawbridgeLogic drawbridge = (AdvancedDrawbridgeLogic)logic;
            ItemStack stack = drawbridge.camoInventory.getCamoStack();
            if (stack != null && stack.field_77993_c < 4096 && (block = Block.field_71973_m[stack.field_77993_c]) != null && block.func_71886_c()) {
                return block.func_71858_a(side, stack.func_77960_j());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3];
            }
            return this.icons[this.getTextureIndex(side, true)];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[6];
            }
            if (side / 2 == direction / 2) {
                return this.icons[8];
            }
            return this.icons[7];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        return this.getTextureIndex(side, false);
    }

    public int getTextureIndex(int side, boolean alt) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return alt ? 9 : 1;
    }

    public int func_71857_b() {
        return MachineRender.model;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        if (metadata == 1) {
            return side == ForgeDirection.UP;
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 4; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        IActiveLogic logic = (IActiveLogic)world.func_72796_p(x, y, z);
        IFacingLogic facing = (IFacingLogic)logic;
        int direction = facing.getRenderDirection();
        boolean active = false;
        for (int i = 0; i < 6; ++i) {
            if (direction == i) continue;
            CoordTuple coord = directions.get(i);
            if (this.getIndirectPowerLevelTo(world, x + coord.x, y + coord.y, z + coord.z, i) <= 0 && !this.activeRedstone(world, coord.x, y + coord.y, z + coord.z)) continue;
            active = true;
            break;
        }
        logic.setActive(active);
    }

    public int getIndirectPowerLevelTo(World world, int x, int y, int z, int side) {
        if (world.func_72809_s(x, y, z)) {
            return world.func_94577_B(x, y, z);
        }
        int i1 = world.func_72798_a(x, y, z);
        return i1 == 0 ? 0 : Block.field_71973_m[i1].func_71865_a((IBlockAccess)world, x, y, z, side);
    }

    boolean activeRedstone(World world, int x, int y, int z) {
        Block wire = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (wire != null && wire.field_71990_ca == Block.field_72075_av.field_71990_ca) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return false;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        System.out.println("Destroy block");
        player.func_71020_j(0.025f);
        int meta = world.func_72805_g(x, y, z);
        if (meta < 4 && meta != 1) {
            ItemStack stack = this.getDrawbridgeBlock(world, x, y, z, meta);
            this.dropDrawbridgeLogic(world, x, y, z, stack);
        }
        return world.func_94571_i(x, y, z);
    }

    private ItemStack getDrawbridgeBlock(World world, int x, int y, int z, int meta) {
        IDrawbridgeLogicBase drawbridge;
        ItemStack stack = new ItemStack(this.field_71990_ca, 1, meta);
        InventoryLogic logic = (InventoryLogic)world.func_72796_p(x, y, z);
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack camo = null;
        boolean hasTag = false;
        if (meta == 0 || meta == 3) {
            ItemStack contents = logic.func_70301_a(0);
            if (contents != null) {
                NBTTagCompound contentTag = new NBTTagCompound();
                contents.func_77955_b(contentTag);
                tag.func_74766_a("Contents", contentTag);
                hasTag = true;
            }
            camo = logic.func_70301_a(1);
        } else if (meta == 2) {
            AdvancedDrawbridgeLogic advDrawbridge = (AdvancedDrawbridgeLogic)logic;
            camo = advDrawbridge.camoInventory.getCamoStack();
            for (int i = 1; i <= 16; ++i) {
                ItemStack slot = logic.func_70301_a(i - 1);
                if (slot == null) continue;
                NBTTagCompound contentTag = new NBTTagCompound();
                slot.func_77955_b(contentTag);
                tag.func_74766_a("Slot" + i, contentTag);
                hasTag = true;
            }
        }
        if (camo != null) {
            NBTTagCompound camoTag = new NBTTagCompound();
            camo.func_77955_b(camoTag);
            tag.func_74766_a("Camoflauge", camoTag);
            hasTag = true;
        }
        if ((drawbridge = (IDrawbridgeLogicBase)((Object)logic)).getPlacementDirection() != 4) {
            tag.func_74774_a("Placement", drawbridge.getPlacementDirection());
            hasTag = true;
        }
        if (hasTag) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    protected void dropDrawbridgeLogic(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int id = this.func_71922_a(world, x, y, z);
        if (id == 0) {
            return null;
        }
        Item item = Item.field_77698_e[id];
        if (item == null) {
            return null;
        }
        int meta = this.func_71873_h(world, x, y, z);
        if (meta != 1 && meta < 4) {
            return this.getDrawbridgeBlock(world, x, y, z, meta);
        }
        return new ItemStack(id, 1, meta);
    }

    public void func_71893_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta == 1 || meta >= 4) {
            super.func_71893_a(world, player, x, y, z, meta);
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_71860_a(world, x, y, z, living, stack);
        if (stack.func_77942_o()) {
            int meta = stack.func_77960_j();
            if (meta == 0 || meta == 3) {
                NBTTagCompound camoTag;
                DrawbridgeLogic logic = (DrawbridgeLogic)world.func_72796_p(x, y, z);
                NBTTagCompound contentTag = stack.func_77978_p().func_74775_l("Contents");
                if (contentTag != null) {
                    ItemStack contents = ItemStack.func_77949_a((NBTTagCompound)contentTag);
                    logic.func_70299_a(0, contents);
                }
                if ((camoTag = stack.func_77978_p().func_74775_l("Camoflauge")) != null) {
                    ItemStack camoflauge = ItemStack.func_77949_a((NBTTagCompound)camoTag);
                    logic.func_70299_a(1, camoflauge);
                }
                if (stack.func_77978_p().func_74764_b("Placement")) {
                    logic.setPlacementDirection(stack.func_77978_p().func_74771_c("Placement"));
                }
            } else if (meta == 2) {
                AdvancedDrawbridgeLogic logic = (AdvancedDrawbridgeLogic)world.func_72796_p(x, y, z);
                for (int i = 1; i <= 16; ++i) {
                    NBTTagCompound contentTag = stack.func_77978_p().func_74775_l("Slot" + i);
                    if (contentTag == null) continue;
                    ItemStack contents = ItemStack.func_77949_a((NBTTagCompound)contentTag);
                    logic.func_70299_a(i - 1, contents);
                    logic.setBufferSlotContents(i - 1, contents);
                }
                NBTTagCompound camoTag = stack.func_77978_p().func_74775_l("Camoflauge");
                if (camoTag != null) {
                    ItemStack camoflauge = ItemStack.func_77949_a((NBTTagCompound)camoTag);
                    logic.camoInventory.func_70299_a(0, camoflauge);
                }
                if (stack.func_77978_p().func_74764_b("Placement")) {
                    logic.setPlacementDirection(stack.func_77978_p().func_74771_c("Placement"));
                }
            }
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    static {
        directions.add(new CoordTuple(0, -1, 0));
        directions.add(new CoordTuple(0, 1, 0));
        directions.add(new CoordTuple(0, 0, -1));
        directions.add(new CoordTuple(0, 0, 1));
        directions.add(new CoordTuple(-1, 0, 0));
        directions.add(new CoordTuple(1, 0, 0));
    }
}

