/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorModTypeFilter;
import tconstruct.library.armor.EnumArmorPart;

public class AModDamageBoost
extends ArmorModTypeFilter {
    final boolean modifierType;
    final int modifyAmount;
    final double scaleAmount;
    private static final UUID headScale = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c10");
    private static final UUID chestScale = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c11");
    private static final UUID pantsScale = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c12");
    private static final UUID shoesScale = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c13");
    private static final UUID headFlat = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c14");
    private static final UUID chestFlat = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c15");
    private static final UUID pantsFlat = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c16");
    private static final UUID shoesFlat = UUID.fromString("8d39e761-c100-4f81-853d-12dc8b424c17");

    public AModDamageBoost(int effect, EnumSet<EnumArmorPart> armorTypes, ItemStack[] items, int[] values, boolean type, int modifiers, double scale) {
        super(effect, "ExoAttack" + (type ? "Percent" : "Flat"), armorTypes, items, values);
        this.modifierType = type;
        this.modifyAmount = modifiers;
        this.scaleAmount = scale;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int amount = this.matchingAmount(input) * this.modifyAmount;
        return tags.func_74762_e("Modifiers") >= amount;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack armor) {
        NBTTagList attributes;
        NBTTagCompound baseTag = armor.func_77978_p();
        NBTTagCompound armorTag = armor.func_77978_p().func_74775_l(this.getTagName());
        int modifiers = armorTag.func_74762_e("Modifiers");
        armorTag.func_74768_a("Modifiers", modifiers -= this.matchingAmount(input) * this.modifyAmount);
        int amount = this.matchingAmount(input);
        if (armorTag.func_74764_b(this.key)) {
            amount += armorTag.func_74762_e(this.key);
        }
        armorTag.func_74768_a(this.key, amount);
        if (baseTag.func_74764_b("AttributeModifiers")) {
            attributes = baseTag.func_74761_m("AttributeModifiers");
            for (int iter = 0; iter < attributes.func_74745_c(); ++iter) {
                NBTTagCompound tag = (NBTTagCompound)attributes.func_74743_b(iter);
                if (!tag.func_74779_i("AttributeName").equals("generic.attackDamage")) continue;
                attributes.func_74744_a(iter);
            }
        } else {
            attributes = new NBTTagList();
            baseTag.func_74782_a("AttributeModifiers", (NBTBase)attributes);
        }
        attributes.func_74742_a((NBTBase)AModDamageBoost.getAttributeTag("generic.attackDamage", this.key, (double)amount * this.scaleAmount, this.modifierType, this.getUUIDFromItem(armor)));
    }

    UUID getUUIDFromItem(ItemStack stack) {
        ArmorCore item = (ArmorCore)stack.func_77973_b();
        switch (item.armorPart) {
            case HELMET: {
                return this.modifierType ? headScale : headFlat;
            }
            case CHEST: {
                return this.modifierType ? chestScale : chestFlat;
            }
            case PANTS: {
                return this.modifierType ? pantsScale : pantsFlat;
            }
            case SHOES: {
                return this.modifierType ? shoesScale : pantsFlat;
            }
        }
        return null;
    }
}

