/*
 * Decompiled with CFR 0.152.
 */
package worldcore.asm;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDummyContainer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import worldcore.interfaces.IWCFog;

public class WCFogColour
implements IClassTransformer {
    public byte[] transform(String name, String newname, byte[] bytes) {
        if (name.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return WCFogColour.patchEntityRenderer(newname, bytes, false);
        }
        if (name.equals("bfe")) {
            return WCFogColour.patchEntityRenderer(newname, bytes, true);
        }
        return bytes;
    }

    public static byte[] patchEntityRenderer(String name, byte[] bytes, boolean obfuscated) {
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean found = false;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("updateFogColor") && !methodNode.name.equals("i")) continue;
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                if (!(insnNode instanceof MethodInsnNode)) continue;
                MethodInsnNode node = (MethodInsnNode)insnNode;
                if (!node.name.equals("getFogColor") && !node.name.equals("f")) continue;
                InsnList toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toInject.add((AbstractInsnNode)new VarInsnNode(23, 1));
                if (obfuscated) {
                    toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCFogColour", "getFogVec", "(Lnn;Labw;F)Latc;"));
                } else {
                    toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCFogColour", "getFogVec", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/world/World;F)Lnet/minecraft/util/Vec3;"));
                }
                toInject.add((AbstractInsnNode)new VarInsnNode(58, 9));
                methodNode.instructions.insert(node.getNext(), toInject);
                ArrayList<AbstractInsnNode> remNodes = new ArrayList<AbstractInsnNode>();
                AbstractInsnNode currentNode = node.getPrevious().getPrevious();
                for (int i = -2; i <= 1; ++i) {
                    remNodes.add(currentNode);
                    currentNode = currentNode.getNext();
                }
                for (AbstractInsnNode remNode : remNodes) {
                    methodNode.instructions.remove(remNode);
                }
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            throw new RuntimeException("updateFogColor transformer failed");
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static int getFogBlendColour(World world, float partialRenderTick, int playerX, int playerZ) {
        int multiplier;
        int distance = Minecraft.func_71410_x().field_71474_y.field_74347_j ? ForgeDummyContainer.blendRanges[Minecraft.func_71410_x().field_71474_y.field_74339_e] : 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int wr = (int)(world.func_72948_g((float)partialRenderTick).field_72450_a * 255.0);
        int wg = (int)(world.func_72948_g((float)partialRenderTick).field_72448_b * 255.0);
        int wb = (int)(world.func_72948_g((float)partialRenderTick).field_72449_c * 255.0);
        int defaultcolour = (wr << 16) + (wg << 8) + wb;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                int colour = 0;
                colour = biome instanceof IWCFog ? ((IWCFog)biome).getFogColour() : defaultcolour;
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        float celestialAngle = world.func_72826_c(partialRenderTick);
        float celestialAngleMultiplier = MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (celestialAngleMultiplier < 0.0f) {
            celestialAngleMultiplier = 0.0f;
        }
        if (celestialAngleMultiplier > 1.0f) {
            celestialAngleMultiplier = 1.0f;
        }
        return (multiplier = ((r = (int)((float)r * celestialAngleMultiplier)) / divider & 0xFF) << 16 | ((g = (int)((float)g * celestialAngleMultiplier)) / divider & 0xFF) << 8 | (b = (int)((float)b * celestialAngleMultiplier)) / divider & 0xFF) == 0 ? defaultcolour : multiplier;
    }

    public static Vec3 getFogVec(Entity entity, World world, float partialRenderTick) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int multiplier = WCFogColour.getFogBlendColour(world, partialRenderTick, x, z);
        float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(multiplier & 0xFF) / 255.0f;
        return world.func_82732_R().func_72345_a((double)r, (double)g, (double)b);
    }
}

