/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Core;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import lumien.randomthings.Blocks.BlockCraftingTextures;
import lumien.randomthings.Blocks.BlockFluidDisplay;
import lumien.randomthings.Blocks.BlockInventoryInterface;
import lumien.randomthings.Blocks.BlockItemCollector;
import lumien.randomthings.Blocks.BlockOnlineDetector;
import lumien.randomthings.Blocks.BlockPlayerInterface;
import lumien.randomthings.Blocks.ModBlocks;
import lumien.randomthings.Client.GUI.GuiHandler;
import lumien.randomthings.Commands.CommandPlayerInterface;
import lumien.randomthings.Commands.CommandRT;
import lumien.randomthings.Configuration.ConfigurationHandler;
import lumien.randomthings.Core.CreativeTabRandomThings;
import lumien.randomthings.Core.RandomThingsLogger;
import lumien.randomthings.Entity.ModEntitys;
import lumien.randomthings.Events.RTEventHandler;
import lumien.randomthings.Handlers.RTClientTickHandler;
import lumien.randomthings.Handlers.RTCraftingHandler;
import lumien.randomthings.Handlers.RTTickHandler;
import lumien.randomthings.Handlers.RandomOptionsBackground;
import lumien.randomthings.Items.ModItems;
import lumien.randomthings.Library.BlackLists;
import lumien.randomthings.Library.DungeonLoot;
import lumien.randomthings.Library.ModFeatures;
import lumien.randomthings.Library.Recipes;
import lumien.randomthings.Library.VanillaChanges;
import lumien.randomthings.Network.PacketHandler;
import lumien.randomthings.PotionEffects.ModPotions;
import lumien.randomthings.Proxys.CommonProxy;
import lumien.randomthings.TileEntities.ModTileEntitys;
import lumien.randomthings.Utility.OverrideUtils;
import lumien.randomthings.Waila.RTDataProvider;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RandomThings", name="Random Things", version="1.9")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, channels={"RandomThings"}, packetHandler=PacketHandler.class)
public class RandomThings {
    @Mod.Instance(value="RandomThings")
    public static RandomThings instance;
    public static CreativeTabs creativeTab;
    @SidedProxy(clientSide="lumien.randomthings.Proxys.ClientProxy", serverSide="lumien.randomthings.Proxys.CommonProxy")
    public static CommonProxy proxy;
    public static RTClientTickHandler clientTickHandler;
    public static RTTickHandler serverTickHandler;
    public static ILogAgent logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Block b = Block.field_72060_ay;
        Item i = Item.field_77698_e[b.field_71990_ca];
        OverrideUtils.removeVanillaBlock(Block.field_72060_ay);
        ModBlocks.craftingTextures = new BlockCraftingTextures(Block.field_72060_ay.field_71990_ca, Material.field_76245_d);
        OverrideUtils.removeVanillaBlock(ModBlocks.craftingTextures);
        Block.field_71973_m[Block.field_72060_ay.field_71990_ca] = b;
        Item.field_77698_e[i.field_77779_bT] = i;
        ConfigurationHandler.init(event);
        ModBlocks.init();
        ModItems.init();
        Recipes.init();
        ModTileEntitys.init();
        DungeonLoot.init();
        ModEntitys.registerEntitys();
        ModBlocks.lamps();
        ModBlocks.glass();
        ModBlocks.redstoneBlocks();
        this.extendPotionArray();
        ModPotions.init();
        proxy.registerSoundHandler();
        GameRegistry.registerCraftingHandler((ICraftingHandler)new RTCraftingHandler());
        LanguageRegistry.addName((Object)new ItemStack(Block.field_71946_M, 1, 0), (String)"Glass");
        RTEventHandler h = new RTEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)h);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        serverTickHandler = new RTTickHandler();
        clientTickHandler = new RTClientTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)serverTickHandler, (Side)Side.SERVER);
        TickRegistry.registerTickHandler((ITickHandler)clientTickHandler, (Side)Side.CLIENT);
        if (event.getSide().isClient()) {
            if (VanillaChanges.SEASONAL_BACKGROUNDS) {
                Calendar c = Calendar.getInstance();
                int day = c.get(5);
                int month = c.get(2) + 1;
                if (day >= 23 && day <= 30 && month == 12) {
                    RandomOptionsBackground.setBackgroundBlock("snow");
                }
                if (day == 31 && month == 10) {
                    RandomOptionsBackground.setBackgroundBlock("pumpkin_side");
                }
            }
            if (VanillaChanges.RANDOM_BACKGROUNDS) {
                RandomOptionsBackground.setRandomBlock();
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        if (ModFeatures.WAILA_SUPPORT) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"lumien.randomthings.Core.RandomThings.callbackRegister");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModBlocks.crafting();
        proxy.crafting();
    }

    @Mod.EventHandler
    public void receivedMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!m.key.equals("fertilizeBlacklist") || !m.isStringMessage()) continue;
            BlackLists.addFertilizeException(m.getSender(), m.getStringValue());
            FMLLog.log((String)"RandomThings", (Level)Level.INFO, (String)"Added %s from %s to the Blacklist for %s", (Object[])new Object[]{m.getStringValue(), m.getSender(), "Fertilized Dirt"});
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager servercommand = (ServerCommandManager)command;
        servercommand.func_71560_a((ICommand)new CommandPlayerInterface());
        servercommand.func_71560_a((ICommand)new CommandRT());
    }

    public static void callbackRegister(IWailaRegistrar registery) {
        RTDataProvider wailaProvider = new RTDataProvider();
        registery.registerStackProvider((IWailaDataProvider)wailaProvider, BlockItemCollector.class);
        registery.registerBodyProvider((IWailaDataProvider)wailaProvider, BlockPlayerInterface.class);
        registery.registerBodyProvider((IWailaDataProvider)wailaProvider, BlockInventoryInterface.class);
        registery.registerBodyProvider((IWailaDataProvider)wailaProvider, BlockOnlineDetector.class);
        registery.registerBodyProvider((IWailaDataProvider)wailaProvider, BlockFluidDisplay.class);
    }

    private void extendPotionArray() {
        if (Potion.field_76425_a.length < 128) {
            logger.func_98233_a("Extending Potion Array");
            logger.func_98233_a("Old length: " + Potion.field_76425_a.length + " New length: 128");
            Potion[] newArray = Arrays.copyOf(Potion.field_76425_a, 128);
            try {
                for (Field f : Potion.class.getDeclaredFields()) {
                    if (f.getType() != Potion[].class) continue;
                    OverrideUtils.setFinalStatic(f, newArray);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        creativeTab = new CreativeTabRandomThings();
        logger = new RandomThingsLogger();
    }
}

