/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Network;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import lumien.randomthings.Network.PacketME;
import lumien.randomthings.Network.Packets.PacketBlockTeleporter;
import lumien.randomthings.Network.Packets.PacketEnderPorter;
import lumien.randomthings.Network.Packets.PacketEntityDetector;
import lumien.randomthings.Network.Packets.PacketInventoryInterface;
import lumien.randomthings.Network.Packets.PacketItemCollector;
import lumien.randomthings.Network.Packets.PacketLockMode;
import lumien.randomthings.Network.Packets.PacketMagneticForce;
import lumien.randomthings.Network.Packets.PacketNightJade;
import lumien.randomthings.Network.Packets.PacketOnlineDetector;
import lumien.randomthings.Network.Packets.PacketPlayerInterface;
import lumien.randomthings.Network.Packets.PacketRedstoneMode;
import lumien.randomthings.Network.Packets.PacketRevive;
import lumien.randomthings.Network.Packets.PacketSpawnParticle;
import lumien.randomthings.Network.Packets.PacketWeatherEgg;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public enum PacketTypeHandler {
    SPAWN_PARTICLE(PacketSpawnParticle.class),
    INVENTORY_INTERFACE(PacketInventoryInterface.class),
    REVIVE(PacketRevive.class),
    ENTITY_DETECTOR(PacketEntityDetector.class),
    ONLINE_DETECTOR(PacketOnlineDetector.class),
    ENDER_PORTER(PacketEnderPorter.class),
    MAGNETIC_FORCE(PacketMagneticForce.class),
    PLAYER_INTERFACE(PacketPlayerInterface.class),
    ITEM_COLLECTOR(PacketItemCollector.class),
    WEATHER_EGG(PacketWeatherEgg.class),
    BLOCK_TELEPORTER(PacketBlockTeleporter.class),
    REDSTONE_MODE(PacketRedstoneMode.class),
    NIGHT_JADE(PacketNightJade.class),
    LOCK_MODE(PacketLockMode.class);

    private Class<? extends PacketME> claz;

    private PacketTypeHandler(Class<? extends PacketME> clazz) {
        this.claz = clazz;
    }

    public static PacketME buildPacket(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        int identifier = bis.read();
        DataInputStream dis = new DataInputStream(bis);
        PacketME packet = null;
        try {
            packet = PacketTypeHandler.values()[identifier].claz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        packet.readPopulate(dis);
        return packet;
    }

    public static PacketME buildPacket(PacketTypeHandler type) {
        PacketME packet = null;
        try {
            packet = PacketTypeHandler.values()[type.ordinal()].claz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return packet;
    }

    public static Packet populatePacket(PacketME packetEE) {
        byte[] data = packetEE.populate();
        Packet250CustomPayload packet250 = new Packet250CustomPayload();
        packet250.field_73630_a = "RandomThings";
        packet250.field_73629_c = data;
        packet250.field_73628_b = data.length;
        packet250.field_73287_r = false;
        return packet250;
    }
}

