/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Utility;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lumien.randomthings.Blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.FoodStats;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class OverrideUtils {
    public static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    public static void setFoodStats(EntityPlayer player, FoodStats stats) {
        Field[] fields;
        for (Field f : fields = EntityPlayer.class.getDeclaredFields()) {
            if (f.getType() != FoodStats.class) continue;
            f.setAccessible(true);
            try {
                f.set(player, stats);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public static void removeRecipe(ItemStack output, int recipeCount) {
        int counter = 0;
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        Iterator irecipe = recipes.iterator();
        while (irecipe.hasNext()) {
            ItemStack is = ((IRecipe)irecipe.next()).func_77571_b();
            if (is != null && is.field_77993_c == output.field_77993_c && is.func_77960_j() == output.func_77960_j()) {
                irecipe.remove();
                ++counter;
            }
            if (counter != recipeCount) continue;
            break;
        }
    }

    public static void fixCraftingTableRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            if (recipe instanceof ShapedRecipes) {
                ShapedRecipes sr = (ShapedRecipes)recipe;
                for (ItemStack is : sr.field_77574_d) {
                    ItemBlock ib;
                    if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof ItemBlock) || (ib = (ItemBlock)is.func_77973_b()).func_77883_f() != Block.field_72060_ay.field_71990_ca) continue;
                    is.field_77993_c = ModBlocks.coloredCrafting.field_71990_ca;
                }
            } else if (recipe instanceof ShapedOreRecipe) {
                Object[] input;
                ShapedOreRecipe sor = (ShapedOreRecipe)recipe;
                for (Object o : input = sor.getInput()) {
                    ItemStack is;
                    if (!(o instanceof ItemStack) || (is = (ItemStack)o).func_77973_b() == null || !(is.func_77973_b() instanceof ItemBlock) || ((ItemBlock)is.func_77973_b()).func_77883_f() != Block.field_72060_ay.field_71990_ca) continue;
                    ((ItemStack)o).field_77993_c = ModBlocks.coloredCrafting.field_71990_ca;
                }
            } else if (recipe instanceof ShapelessRecipes) {
                ShapelessRecipes slr = (ShapelessRecipes)recipe;
                for (int i = 0; i < slr.field_77579_b.size(); ++i) {
                    ItemStack is;
                    if (!(slr.field_77579_b.get(i) instanceof ItemStack) || (is = (ItemStack)slr.field_77579_b.get(i)).func_77973_b() == null || !(is.func_77973_b() instanceof ItemBlock) || ((ItemBlock)is.func_77973_b()).func_77883_f() != Block.field_72060_ay.field_71990_ca) continue;
                    is.field_77993_c = ModBlocks.coloredCrafting.field_71990_ca;
                }
            }
            ItemStack itemStack = recipe.func_77571_b();
        }
    }

    public static ArrayList<Field> searchBlockField(Class block) {
        Field[] fields;
        ArrayList<Field> found = new ArrayList<Field>();
        for (Field f : fields = Block.class.getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers) || f.getType() != Block.class) continue;
            try {
                if (!block.isInstance(f.get(Block.class))) continue;
                found.add(f);
            }
            catch (Exception e) {
                System.out.println("Error while searching for a Block.");
                e.printStackTrace();
            }
        }
        return found;
    }

    public static void overrideBlockConstant(Block newBlock, String fieldName) {
        try {
            OverrideUtils.setFinalStatic(Block.class.getField(fieldName), newBlock);
        }
        catch (Exception e) {
            System.out.println("Error while overwriting fieldName");
            e.printStackTrace();
        }
    }

    public static void removeVanillaBlock(Block vanillaBlock) {
        Block.field_71973_m[vanillaBlock.field_71990_ca] = null;
        Item.field_77698_e[vanillaBlock.field_71990_ca] = null;
    }
}

