/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.entities;

import calclavia.api.icbm.IMissile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.sounds.GCCoreSoundUpdaterSpaceship;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.mars.items.GCMarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class GCMarsEntityRocketT2
extends EntityTieredRocket {
    public IUpdatePlayerListBox rocketSoundUpdater;

    public GCMarsEntityRocketT2(World par1World) {
        super(par1World);
    }

    public GCMarsEntityRocketT2(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
    }

    public GCMarsEntityRocketT2(World par1World, double par2, double par4, double par6, boolean reversed, IRocketType.EnumRocketType rocketType, ItemStack[] inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.cargoItems = inv;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.func_73660_a();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() && this.field_70146_Z.nextInt(i) == 0) && !GCCoreConfigManager.disableSpaceshipParticles && this.hasValidFuel() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.rocketSoundUpdater != null && (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() || this.getLaunched())) {
            this.rocketSoundUpdater.func_73660_a();
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.hasValidFuel()) {
            if (!this.landing) {
                double d = this.timeSinceLaunch / 150.0f;
                if ((d = Math.min(d, 1.0)) != 0.0) {
                    this.field_70181_x = -d * 1.5 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        if (!this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)GCCorePacketManager.getPacket((String)"GCCoreEntities", (Entity)this, (ArrayList)this.getNetworkedData(new ArrayList())));
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket((String)"GalacticraftCore", (GCCorePacketHandlerClient.EnumPacketClient)GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, (Object[])new Object[]{0}));
        if (playerBase != null) {
            if (this.cargoItems == null || this.cargoItems.length == 0) {
                playerBase.setRocketStacks(new ItemStack[3]);
            } else {
                playerBase.setRocketStacks(this.cargoItems);
            }
            playerBase.setRocketType(this.rocketType.getIndex());
            playerBase.setRocketItem(GCMarsItems.spaceship);
            playerBase.setFuelLevel(this.fuelTank.getFluidAmount());
        }
    }

    protected void spawnParticles(boolean launched) {
        double x1 = 2.9 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 2.9 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = 2.9 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
        double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r);
        if (!this.field_70128_L) {
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.4 - this.field_70146_Z.nextDouble() / 10.0 + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.4 + x1, y - 0.0 + y1, this.field_70161_v + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.4 + x1, y - 0.0 + y1, this.field_70161_v + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + 0.4 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v - 0.4 + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(this.field_70165_t + x1 - 0.8, y - 0.0 + y1, this.field_70161_v + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(this.field_70165_t + x1 + 0.8, y - 0.0 + y1, this.field_70161_v + z1), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + z1 - 0.8), new Vector3(x1, y1, z1));
            GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(this.field_70165_t + x1, y - 0.0 + y1, this.field_70161_v + z1 + 0.8), new Vector3(x1, y1, z1));
        }
    }

    protected void onRocketLand(int x, int y, int z) {
        super.onRocketLand(x, y, z);
        if (this.rocketSoundUpdater instanceof GCCoreSoundUpdaterSpaceship) {
            ((GCCoreSoundUpdaterSpaceship)this.rocketSoundUpdater).stopRocketSound();
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70128_L ? false : par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="calclavia.api.icbm.IMissileLockable", modID="ICBM|Explosion")
    public boolean canLock(IMissile missile) {
        return true;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="calclavia.api.icbm.IMissileLockable", modID="ICBM|Explosion")
    public Vector3 getPredictedPosition(int ticks) {
        return new Vector3((Entity)this);
    }

    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof GCCoreTileEntityLandingPad;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="calclavia.api.icbm.sentry.IAATarget", modID="ICBM|Explosion")
    public void destroyCraft() {
        this.func_70106_y();
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="calclavia.api.icbm.sentry.IAATarget", modID="ICBM|Explosion")
    public int doDamage(int damage) {
        this.shipDamage += (float)damage;
        return damage;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="calclavia.api.icbm.sentry.IAATarget", modID="ICBM|Explosion")
    public boolean canBeTargeted(Object entity) {
        return this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.timeSinceLaunch > 50.0f;
    }

    public int getRocketTier() {
        return 2;
    }

    public int getFuelTankCapacity() {
        return 1500;
    }

    public int getPreLaunchWait() {
        return 400;
    }
}

