/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.world.gen;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.core.world.gen.GCCoreWorldGenMinableMeta;
import micdoodle8.mods.galacticraft.mars.blocks.GCMarsBlocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class GCMarsBiomeDecorator {
    protected World currentWorld;
    protected Random rand;
    protected int chunkX;
    protected int chunkZ;
    protected WorldGenerator dirtGen;
    protected WorldGenerator deshGen;
    protected WorldGenerator tinGen;
    protected WorldGenerator copperGen;
    protected WorldGenerator ironGen;

    public GCMarsBiomeDecorator() {
        this.copperGen = new GCCoreWorldGenMinableMeta(GCMarsBlocks.marsBlock.field_71990_ca, 4, 0, true, GCMarsBlocks.marsBlock.field_71990_ca, 9);
        this.tinGen = new GCCoreWorldGenMinableMeta(GCMarsBlocks.marsBlock.field_71990_ca, 4, 1, true, GCMarsBlocks.marsBlock.field_71990_ca, 9);
        this.deshGen = new GCCoreWorldGenMinableMeta(GCMarsBlocks.marsBlock.field_71990_ca, 4, 2, true, GCMarsBlocks.marsBlock.field_71990_ca, 9);
        this.ironGen = new GCCoreWorldGenMinableMeta(GCMarsBlocks.marsBlock.field_71990_ca, 8, 3, true, GCMarsBlocks.marsBlock.field_71990_ca, 9);
        this.dirtGen = new GCCoreWorldGenMinableMeta(GCMarsBlocks.marsBlock.field_71990_ca, 32, 6, true, GCMarsBlocks.marsBlock.field_71990_ca, 9);
    }

    public void decorate(World world, Random random, int chunkX, int chunkZ) {
        if (this.currentWorld != null) {
            throw new RuntimeException("Already decorating!!");
        }
        this.currentWorld = world;
        this.rand = random;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.generateMars();
        this.currentWorld = null;
        this.rand = null;
    }

    protected void generateOre(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var6 = this.chunkX + this.rand.nextInt(16);
            int var7 = this.rand.nextInt(maxY - minY) + minY;
            int var8 = this.chunkZ + this.rand.nextInt(16);
            worldGenerator.func_76484_a(this.currentWorld, this.rand, var6, var7, var8);
        }
    }

    protected void generateMars() {
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Pre(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        this.generateOre(20, this.dirtGen, 0, 200);
        this.generateOre(15, this.deshGen, 0, 128);
        this.generateOre(26, this.copperGen, 0, 60);
        this.generateOre(23, this.tinGen, 0, 60);
        this.generateOre(20, this.ironGen, 0, 64);
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Post(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
    }
}

