/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.blocks;

import com.foodplus.blocks.refrigerator.RefrigeratorTileEntity;
import com.foodplus.core.Blocks;
import com.foodplus.core.FoodPlus;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Refrigerator
extends BlockContainer {
    private final Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory;
    @SideOnly(value=Side.CLIENT)
    private Icon RefrigeratorIconTop;
    @SideOnly(value=Side.CLIENT)
    private Icon RefrigeratorIconFront;

    public Refrigerator(int par1, boolean par2) {
        super(par1, Material.field_76246_e);
        this.isActive = par2;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return Blocks.RefrigeratorIdle.field_71990_ca;
    }

    public void func_71861_g(World par1World, int par2, int par3, int par4) {
        super.func_71861_g(par1World, par2, par3, par4);
        this.setDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K) {
            int l = par1World.func_72798_a(par2, par3, par4 - 1);
            int i1 = par1World.func_72798_a(par2, par3, par4 + 1);
            int j1 = par1World.func_72798_a(par2 - 1, par3, par4);
            int k1 = par1World.func_72798_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (Block.field_71970_n[l] && !Block.field_71970_n[i1]) {
                b0 = 3;
            }
            if (Block.field_71970_n[i1] && !Block.field_71970_n[l]) {
                b0 = 2;
            }
            if (Block.field_71970_n[j1] && !Block.field_71970_n[k1]) {
                b0 = 5;
            }
            if (Block.field_71970_n[k1] && !Block.field_71970_n[j1]) {
                b0 = 4;
            }
            par1World.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return par1 == 1 ? this.RefrigeratorIconTop : (par1 == 0 ? this.RefrigeratorIconTop : (par1 != par2 ? this.field_94336_cN : this.RefrigeratorIconFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a("foodplus:Refrigerator_side");
        this.RefrigeratorIconFront = par1IconRegister.func_94245_a(this.isActive ? "foodplus:Refrigerator_front_on" : "foodplus:Refrigerator_front_off");
        this.RefrigeratorIconTop = par1IconRegister.func_94245_a("foodplus:Refrigerator_top");
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int i, float f, float g, float t) {
        TileEntity tile_entity = world.func_72796_p(x, y, z);
        if (tile_entity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)FoodPlus.instance, 0, world, x, y, z);
        return true;
    }

    public static void updateFurnaceBlockState(boolean par0, World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        TileEntity tileentity = par1World.func_72796_p(par2, par3, par4);
        keepFurnaceInventory = true;
        if (par0) {
            par1World.func_94575_c(par2, par3, par4, Blocks.RefrigeratorBurning.field_71990_ca);
        } else {
            par1World.func_94575_c(par2, par3, par4, Blocks.RefrigeratorIdle.field_71990_ca);
        }
        keepFurnaceInventory = false;
        par1World.func_72921_c(par2, par3, par4, l, 2);
        if (tileentity != null) {
            tileentity.func_70312_q();
            par1World.func_72837_a(par2, par3, par4, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.isActive) {
            int l = par1World.func_72805_g(par2, par3, par4);
            float f = (float)par2 + 0.5f;
            float f1 = (float)par3 + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)par4 + 0.5f;
            float f3 = 0.52f;
            float f4 = par5Random.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                par1World.func_72869_a("dripWater", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                par1World.func_72869_a("snowballpoof", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 5) {
                par1World.func_72869_a("dripWater", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                par1World.func_72869_a("snowballpoof", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 2) {
                par1World.func_72869_a("snowballpoof", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                par1World.func_72869_a("dripWater", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (l == 3) {
                par1World.func_72869_a("snowballpoof", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                par1World.func_72869_a("dripWater", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    public TileEntity func_72274_a(World par1World) {
        return new RefrigeratorTileEntity();
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.func_72921_c(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.func_72921_c(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.func_72921_c(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.func_72921_c(par2, par3, par4, 4, 2);
        }
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityFurnace)par1World.func_72796_p(par2, par3, par4)).func_94129_a(par6ItemStack.func_82833_r());
        }
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntity tileentityfurnace;
        if (!keepFurnaceInventory && (tileentityfurnace = par1World.func_72796_p(par2, par3, par4)) != null) {
            for (int j1 = 0; j1 < ((IInventory)tileentityfurnace).func_70302_i_(); ++j1) {
                ItemStack itemstack = ((IInventory)tileentityfurnace).func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.furnaceRand.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.field_77993_c, k1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.furnaceRand.nextGaussian() * f3;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_96440_m(par2, par3, par4, par5);
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World par1World, int par2, int par3, int par4, int par5) {
        return Container.func_94526_b((IInventory)((IInventory)par1World.func_72796_p(par2, par3, par4)));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return Blocks.RefrigeratorIdle.field_71990_ca;
    }
}

