/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.foodplus.blocks.refrigerator.RefrigeratorRecipeManager;
import com.foodplus.blocks.refrigerator.RefrigeratorTileEntity;
import com.foodplus.core.gui.GuiRefrigerator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class NEIRefrigeratorRecipeManager
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static TreeSet<Integer> efuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRefrigerator.class;
    }

    public String getRecipeName() {
        return "Freezing";
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            NEIRefrigeratorRecipeManager.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("freezing") && ((Object)((Object)this)).getClass() == NEIRefrigeratorRecipeManager.class) {
            ItemStack item;
            HashMap recipes = (HashMap)RefrigeratorRecipeManager.smelting().getSmeltingList();
            HashMap metarecipes = (HashMap)RefrigeratorRecipeManager.smelting().getMetaSmeltingList();
            for (Map.Entry recipe : recipes.entrySet()) {
                item = (ItemStack)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)recipe.getKey()).intValue(), 1, -1), item));
            }
            if (metarecipes == null) {
                return;
            }
            for (Map.Entry recipe : metarecipes.entrySet()) {
                item = (ItemStack)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack item;
        HashMap recipes = (HashMap)RefrigeratorRecipeManager.smelting().getSmeltingList();
        HashMap metarecipes = (HashMap)RefrigeratorRecipeManager.smelting().getMetaSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType((ItemStack)item, (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)recipe.getKey()).intValue(), 1, -1), item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType((ItemStack)item, (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == NEIRefrigeratorRecipeManager.class) {
            this.loadCraftingRecipes("freezing", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack item;
        HashMap recipes = (HashMap)RefrigeratorRecipeManager.smelting().getSmeltingList();
        HashMap metarecipes = (HashMap)RefrigeratorRecipeManager.smelting().getMetaSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)recipe.getKey()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)((List)recipe.getKey()).get(0) || ingredient.func_77960_j() != ((Integer)((List)recipe.getKey()).get(1)).intValue()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
    }

    public String getGuiTexture() {
        return "foodplus:textures/gui/container/Refrigerator.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void removeFuels() {
        efuels = new TreeSet();
        efuels.add(Block.field_72000_bn.field_71990_ca);
        efuels.add(Block.field_72001_bo.field_71990_ca);
        efuels.add(Block.field_72053_aD.field_71990_ca);
        efuels.add(Block.field_72042_aI.field_71990_ca);
        efuels.add(Block.field_72054_aE.field_71990_ca);
        efuels.add(Block.field_72004_bj.field_71990_ca);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.field_77993_c) || (burnTime = RefrigeratorTileEntity.getItemBurnTime(item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public String getOverlayIdentifier() {
        return "freezing";
    }

    static {
        NEIRefrigeratorRecipeManager.removeFuels();
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)NEIRefrigeratorRecipeManager.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public PositionedStack getIngredient() {
            int cycle = NEIRefrigeratorRecipeManager.this.cycleticks / 48;
            if (this.ingred.item.func_77960_j() == -1) {
                PositionedStack stack = this.ingred.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.ingred;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return NEIRefrigeratorRecipeManager.afuels.get((int)(NEIRefrigeratorRecipeManager.this.cycleticks / 48 % NEIRefrigeratorRecipeManager.afuels.size())).stack;
        }
    }
}

