/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;

public class InfusionRecipe {
    public AspectList aspects;
    public String research;
    public ItemStack[] components;
    public ItemStack recipeInput;
    public Object recipeOutput;
    public int instability;

    public InfusionRecipe(String research, Object output, int inst, AspectList aspects2, ItemStack input, ItemStack[] recipe) {
        this.research = research;
        this.recipeOutput = output;
        this.recipeInput = input;
        this.aspects = aspects2;
        this.components = recipe;
        this.instability = inst;
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.recipeInput == null) {
            return false;
        }
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete(player.field_71092_bJ, this.research)) {
            return false;
        }
        ItemStack i2 = central.func_77946_l();
        if (this.recipeInput.func_77960_j() == Short.MAX_VALUE) {
            i2.func_77964_b(Short.MAX_VALUE);
        }
        if (!this.areItemStacksEqual(i2, this.recipeInput, true)) {
            return false;
        }
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.components) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (comp.func_77960_j() == Short.MAX_VALUE) {
                    i2.func_77964_b(Short.MAX_VALUE);
                }
                if (!this.areItemStacksEqual(i2, comp, true)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    private boolean areItemStacksEqual(ItemStack stack0, ItemStack stack1, boolean fuzzy) {
        if (stack0 == null && stack1 != null) {
            return false;
        }
        if (stack0 != null && stack1 == null) {
            return false;
        }
        if (stack0 == null && stack1 == null) {
            return true;
        }
        boolean t1 = false;
        if (fuzzy) {
            ItemStack[] ores;
            t1 = true;
            int od = OreDictionary.getOreID((ItemStack)stack0);
            if (od != -1 && ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{stack1}, ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]))) {
                return true;
            }
        } else {
            t1 = ItemStack.func_77970_a((ItemStack)stack0, (ItemStack)stack1);
        }
        return stack0.field_77993_c != stack1.field_77993_c ? false : (stack0.func_77960_j() != stack1.func_77960_j() ? false : (stack0.field_77994_a > stack0.func_77976_d() ? false : t1));
    }

    public Object getRecipeOutput() {
        return this.recipeOutput;
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    public String getResearch() {
        return this.research;
    }
}

