/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.GunBoxType;
import co.uk.flansmods.common.TileEntityGunBox;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGunBox
extends BlockContainer {
    public BlockGunBox(int i) {
        super(i, Material.field_76245_d);
        this.func_71848_c(2.0f);
        this.func_71894_b(4.0f);
        this.func_71849_a(FlansMod.tabFlanGuns);
    }

    public void buyGun(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyGun(type, i);
        }
        if (i <= type.numGuns && type.guns[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.gunParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.field_77993_c != check.field_77993_c || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.gunParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.field_77993_c != remove.field_77993_c || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.guns[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    public void buyAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 1);
        }
        if (i <= type.numGuns && type.bulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.bulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.field_77993_c != check.field_77993_c || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.bulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.field_77993_c != remove.field_77993_c || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.bullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    public void buyAltAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 2);
        }
        if (i <= type.numGuns && type.altBulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.altBulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.field_77993_c != check.field_77993_c || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.altBulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.field_77993_c != remove.field_77993_c || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.altBullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iba, int x, int y, int z, int side) {
        TileEntityGunBox TE = (TileEntityGunBox)iba.func_72796_p(x, y, z);
        GunBoxType type = TE.getType();
        if (type == null) {
            return null;
        }
        if (side == 1) {
            return type.top;
        }
        if (side == 0) {
            return type.bottom;
        }
        return type.side;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        GunBoxType type = GunBoxType.getBox(metadata);
        if (type == null) {
            return null;
        }
        if (side == 1) {
            return type.top;
        }
        if (side == 0) {
            return type.bottom;
        }
        return type.side;
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntityGunBox tileEntity = (TileEntityGunBox)world.func_72796_p(i, j, k);
        if (tileEntity != null) {
            if (!entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)FlansMod.instance, 5, world, i, j, k);
            } else {
                return false;
            }
        }
        return true;
    }

    public void addCreativeItems(ArrayList itemList) {
        itemList.add(new ItemStack((Block)this));
    }

    public Block purchaseItem(int i, int id, InventoryPlayer inventory, GunBoxType type) {
        switch (i) {
            case 0: {
                this.buyGun(id, inventory, type);
                break;
            }
            case 1: {
                this.buyAmmo(id, inventory, type);
                break;
            }
            case 2: {
                this.buyAltAmmo(id, inventory, type);
            }
        }
        return this;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityGunBox();
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityGunBox te = (TileEntityGunBox)world.func_72796_p(x, y, z);
        if (te != null && te.getType() != null) {
            ret.add(new ItemStack(this.field_71990_ca, 1, te.getType().gunBoxID));
        }
        return ret;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntityGunBox te = (TileEntityGunBox)world.func_72796_p(x, y, z);
        if (te != null && te.getType() != null) {
            world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), new ItemStack(this.field_71990_ca, 1, te.getType().gunBoxID)));
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        for (GunBoxType type : GunBoxType.gunBoxMap.values()) {
            type.top = register.func_94245_a("FlansMod:" + type.topTexturePath);
            type.side = register.func_94245_a("FlansMod:" + type.sideTexturePath);
            type.bottom = register.func_94245_a("FlansMod:" + type.bottomTexturePath);
        }
    }
}

