/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.driveables.EntityDriveable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerPlaneInventory
extends Container {
    public InventoryPlayer inventory;
    public World world;
    public EntityDriveable plane;
    public int numItems;
    public int screen;
    public int maxScroll;
    public int scroll;

    public ContainerPlaneInventory(InventoryPlayer inventoryplayer, World worldy, EntityDriveable entPlane, int i) {
        this.inventory = inventoryplayer;
        this.world = worldy;
        this.plane = entPlane;
        this.screen = i;
        this.numItems = 0;
        switch (i) {
            case 0: {
                this.numItems = this.plane.driveableData.numGuns;
                this.maxScroll = this.numItems > 3 ? this.numItems - 3 : 0;
                break;
            }
            case 1: {
                this.numItems = this.plane.getDriveableType().numBombSlots;
                this.maxScroll = (this.numItems + 7) / 8 > 3 ? (this.numItems + 7) / 8 - 3 : 0;
                break;
            }
            case 2: {
                this.numItems = this.plane.getDriveableType().numCargoSlots;
                this.maxScroll = (this.numItems + 7) / 8 > 3 ? (this.numItems + 7) / 8 - 3 : 0;
            }
        }
        switch (this.screen) {
            case 0: {
                int slotsDone = 0;
                for (int j = 0; j < this.plane.driveableData.numGuns; ++j) {
                    int yPos = -1000;
                    if (slotsDone < 3 + this.scroll && slotsDone >= this.scroll) {
                        yPos = 25 + 19 * slotsDone;
                    }
                    this.func_75146_a(new Slot((IInventory)this.plane.driveableData, j, 29, yPos));
                    ++slotsDone;
                }
                break;
            }
            case 1: 
            case 2: {
                int startSlot = this.plane.driveableData.getBombInventoryStart();
                if (this.screen == 2) {
                    startSlot = this.plane.driveableData.getCargoInventoryStart();
                }
                int m = (this.numItems + 7) / 8;
                for (int row = 0; row < m; ++row) {
                    int yPos = -1000;
                    if (row < 3 + this.scroll && row >= this.scroll) {
                        yPos = 25 + 19 * (row - this.scroll);
                    }
                    for (int col = 0; col < ((row + this.scroll + 1) * 8 <= this.numItems ? 8 : this.numItems % 8); ++col) {
                        this.func_75146_a(new Slot((IInventory)this.plane.driveableData, startSlot + row * 8 + col, 10 + 18 * col, yPos));
                    }
                }
                break;
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, col + row * 9 + 9, 8 + col * 18, 98 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, col, 8 + col * 18, 156));
        }
    }

    public void updateScroll(int scrololol) {
        this.scroll = scrololol;
        switch (this.screen) {
            case 0: {
                int slotsDone = 0;
                for (int i = 0; i < this.plane.driveableData.numGuns; ++i) {
                    int yPos = -1000;
                    if (slotsDone < 3 + this.scroll && slotsDone >= this.scroll) {
                        yPos = 25 + 19 * (slotsDone - this.scroll);
                    }
                    ((Slot)this.field_75151_b.get((int)slotsDone)).field_75221_f = yPos;
                    ++slotsDone;
                }
                break;
            }
            case 1: 
            case 2: {
                int m = (this.numItems + 7) / 8;
                for (int row = 0; row < m; ++row) {
                    int yPos = -1000;
                    if (row < 3 + this.scroll && row >= this.scroll) {
                        yPos = 25 + 19 * (row - this.scroll);
                    }
                    for (int col = 0; col < ((row + 1) * 8 <= this.numItems ? 8 : this.numItems % 8); ++col) {
                        ((Slot)this.field_75151_b.get((int)(row * 8 + col))).field_75221_f = yPos;
                    }
                }
                break;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot != null && currentSlot.func_75216_d()) {
            ItemStack slotStack = currentSlot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotID >= this.numItems ? !this.func_75135_a(slotStack, 0, this.numItems, false) : !this.func_75135_a(slotStack, this.numItems, this.field_75151_b.size(), true)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                currentSlot.func_75215_d((ItemStack)null);
            } else {
                currentSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
            currentSlot.func_82870_a(player, slotStack);
        }
        return stack;
    }
}

